/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.StringUtil;

public class CapellaCategoryServices {
    private static final String TD_TD = "</td><td>";

    private CapellaCategoryServices() {
    }

    public static String edgeToTableLine(NamedElement edge, String projectName, String outputFolder) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<tr>");
        stringBuilder.append("<td id=\"" + CapellaServices.getAnchorId((EObject)edge) + "\">");
        stringBuilder.append(CapellaServices.getImageLinkFromElement((EObject)edge, projectName, outputFolder));
        stringBuilder.append(" ");
        NamedElement ne = edge;
        stringBuilder.append(ne.getName());
        stringBuilder.append(TD_TD);
        EObject source = null;
        EObject target = null;
        if (edge instanceof FunctionalExchange) {
            FunctionalExchange fe = (FunctionalExchange)edge;
            source = fe.getSource().eContainer();
            target = fe.getTarget().eContainer();
        } else if (edge instanceof ComponentExchange) {
            ComponentExchange ce = (ComponentExchange)edge;
            source = ce.getSource().eContainer();
            target = ce.getTarget().eContainer();
        } else if (edge instanceof PhysicalLink) {
            PhysicalLink pl = (PhysicalLink)edge;
            source = pl.getSourcePhysicalPort().eContainer();
            target = pl.getTargetPhysicalPort().eContainer();
        }
        stringBuilder.append(CapellaServices.getImageLinkFromElement(source, projectName, outputFolder));
        stringBuilder.append(" ");
        stringBuilder.append(CapellaServices.getHyperlinkFromElement(source));
        stringBuilder.append(TD_TD);
        stringBuilder.append(CapellaServices.getImageLinkFromElement(target, projectName, outputFolder));
        stringBuilder.append(" ");
        stringBuilder.append(CapellaServices.getHyperlinkFromElement(target));
        stringBuilder.append(TD_TD);
        if (edge.getDescription() != null) {
            stringBuilder.append(StringUtil.transformAREFString((EObject)edge, edge.getDescription(), projectName, outputFolder));
        } else {
            stringBuilder.append("");
        }
        stringBuilder.append("</td></tr>");
        return stringBuilder.toString();
    }
}

