/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.query.DRepresentationQuery;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.docgen.diagram.CapellaHelper;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.SortedTreeNode;

public class TreeServices {
    public static final String DIAGRAMS_TREE_ID = "diagramsTreeView";
    private static final Comparator<DefaultMutableTreeNode> diagramsComparator = new Comparator<DefaultMutableTreeNode>(){

        @Override
        public int compare(DefaultMutableTreeNode arg0, DefaultMutableTreeNode arg1) {
            DRepresentationDescriptor result;
            DRepresentationQuery rep2descQuery;
            Object obj0 = arg0.getUserObject();
            Object obj1 = arg1.getUserObject();
            String str0 = "";
            String str1 = "";
            if (obj0 instanceof DRepresentation) {
                rep2descQuery = new DRepresentationQuery((DRepresentation)obj0);
                result = rep2descQuery.getRepresentationDescriptor();
                str0 = result == null ? "" : result.getName();
            } else if (obj0 instanceof Viewpoint) {
                str0 = ((Viewpoint)obj0).getName();
            } else if (obj0 instanceof RepresentationDescription) {
                str0 = ((RepresentationDescription)obj0).getName();
            }
            if (obj1 instanceof DRepresentation) {
                rep2descQuery = new DRepresentationQuery((DRepresentation)obj1);
                result = rep2descQuery.getRepresentationDescriptor();
                str1 = result == null ? "" : result.getName();
            } else if (obj1 instanceof Viewpoint) {
                str1 = ((Viewpoint)obj1).getName();
            } else if (obj1 instanceof RepresentationDescription) {
                str1 = ((RepresentationDescription)obj1).getName();
            }
            return str0.compareTo(str1);
        }
    };

    public static String getDiagramsTree(BlockArchitecture archi, String projectName, String outputFolder) {
        StringBuilder sb = new StringBuilder();
        DefaultMutableTreeNode tree = TreeServices.buildDiagramsTree(archi);
        sb.append("<ul id=\"").append(DIAGRAMS_TREE_ID).append("\" class=\"treeview\">");
        sb.append(TreeServices.printDiagramsTree(tree, projectName, outputFolder));
        sb.append("</ul>");
        return sb.toString();
    }

    private static DefaultMutableTreeNode buildDiagramsTree(BlockArchitecture archi) {
        SortedTreeNode tree = new SortedTreeNode(diagramsComparator);
        HashMap<DiagramDescription, SortedTreeNode> repDescToTreeNodeMap = new HashMap<DiagramDescription, SortedTreeNode>();
        HashMap<Viewpoint, SortedTreeNode> vpToTreeNodeMap = new HashMap<Viewpoint, SortedTreeNode>();
        for (DRepresentation rep : CapellaHelper.getAllDiagramsIn(archi)) {
            SortedTreeNode vpNode;
            DiagramDescription description = null;
            if (rep instanceof DSemanticDiagram) {
                target = ((DSemanticDiagram)rep).getTarget();
                if (!CapellaHelper.exportRefToDiagram(rep, target)) continue;
                description = ((DSemanticDiagram)rep).getDescription();
            } else {
                if (!(rep instanceof DTable)) break;
                target = ((DTable)rep).getTarget();
                if (!CapellaHelper.exportRefToDiagram(rep, target)) continue;
                description = ((DTable)rep).getDescription();
            }
            Viewpoint vp = (Viewpoint)description.eContainer();
            SortedTreeNode descNode = (SortedTreeNode)repDescToTreeNodeMap.get(description);
            if (descNode == null) {
                descNode = new SortedTreeNode((Object)description, diagramsComparator);
                repDescToTreeNodeMap.put(description, descNode);
            }
            if ((vpNode = (SortedTreeNode)vpToTreeNodeMap.get(vp)) == null) {
                vpNode = new SortedTreeNode((Object)vp, diagramsComparator);
                vpToTreeNodeMap.put(vp, vpNode);
            }
            SortedTreeNode repNode = new SortedTreeNode((Object)rep, diagramsComparator);
            if (!tree.isNodeChild(vpNode)) {
                tree.add(vpNode);
            }
            if (!vpNode.isNodeChild(descNode)) {
                vpNode.add(descNode);
            }
            descNode.add(repNode);
        }
        return tree;
    }

    private static String printDiagramsTree(DefaultMutableTreeNode tree, String projectName, String outputFolder) {
        StringBuilder sb = new StringBuilder();
        Enumeration<TreeNode> childs = tree.children();
        if (childs instanceof Enumeration) {
            while (childs.hasMoreElements()) {
                DefaultMutableTreeNode node;
                sb.append("<li>");
                TreeNode element = childs.nextElement();
                if (element instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)element).getUserObject() instanceof EObject) {
                    EObject obj = (EObject)node.getUserObject();
                    if (obj instanceof Viewpoint) {
                        Viewpoint vp = (Viewpoint)obj;
                        sb.append(CapellaServices.getImageLinkFromElement((EObject)vp, projectName, outputFolder));
                        sb.append(CapellaServices.getHyperlinkFromElement((EObject)vp, vp.getName()));
                        sb.append("<ul>");
                        sb.append(TreeServices.printDiagramsTree(node, projectName, outputFolder));
                        sb.append("</ul>");
                    } else if (obj instanceof RepresentationDescription) {
                        RepresentationDescription description = (RepresentationDescription)obj;
                        sb.append(CapellaServices.getImageLinkFromElement((EObject)description, projectName, outputFolder));
                        sb.append(description.getName());
                        sb.append("<ul>");
                        sb.append(TreeServices.printDiagramsTree(node, projectName, outputFolder));
                        sb.append("</ul>");
                    } else if (obj instanceof DRepresentation) {
                        DRepresentation rep = (DRepresentation)obj;
                        sb.append(CapellaServices.getImageLinkFromElement((EObject)rep, projectName, outputFolder));
                        DRepresentationQuery rep2descQuery = new DRepresentationQuery(rep);
                        DRepresentationDescriptor result = rep2descQuery.getRepresentationDescriptor();
                        sb.append(CapellaServices.getHyperlinkFromElement((EObject)rep, result == null ? "" : result.getName()));
                    }
                }
                sb.append("</li>");
            }
        }
        return sb.toString();
    }
}

