/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.extension.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.model.pattern.BundleAccessor;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternNature;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.engine.PatternEngine;
import org.eclipse.egf.pattern.execution.ExecutionContext;
import org.eclipse.egf.pattern.extension.ExtensionHelper;
import org.eclipse.egf.pattern.extension.PatternExtension;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.Bundle;
import org.polarsys.kitalpha.doc.gen.business.core.Activator;
import org.polarsys.kitalpha.doc.gen.business.core.extension.page.PageExtensionElement;
import org.polarsys.kitalpha.doc.gen.business.core.extension.page.PageExtensionManager;
import org.polarsys.kitalpha.doc.gen.business.core.util.IDiagramHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.IFileNameService;

public class PageExtensionRegistry {
    private ResourceSet egfResourceSet = new ResourceSetImpl();
    private Collection<PageExtensionElement> extensions;
    private static PageExtensionRegistry instance;

    private PageExtensionRegistry() {
        PageExtensionManager pageExtesionManager = new PageExtensionManager();
        this.extensions = pageExtesionManager.loadExtensions();
    }

    public static PageExtensionRegistry getInstance() {
        if (instance == null) {
            instance = new PageExtensionRegistry();
        }
        return instance;
    }

    public void addExtension(PageExtensionElement ext) {
        this.extensions.add(ext);
    }

    public Collection<String> getDomains() {
        ArrayList<String> result = new ArrayList<String>();
        for (PageExtensionElement ext : this.extensions) {
            String domain = ext.getDomain();
            if (result.contains(domain)) continue;
            result.add(domain);
        }
        return result;
    }

    public Collection<PageExtensionElement> getExtensions(String domain, PageExtensionElement.PageExtensionActivationStatus status) {
        ArrayList<PageExtensionElement> result = new ArrayList<PageExtensionElement>();
        for (PageExtensionElement ext : this.extensions) {
            if (!ext.getDomain().equalsIgnoreCase(domain) || status != null && !ext.getCurrentActivactionStatus().equals((Object)status)) continue;
            result.add(ext);
        }
        return result;
    }

    public Collection<PageExtensionElement> getActiveExtensions(String domain) {
        return this.getExtensions(domain, PageExtensionElement.PageExtensionActivationStatus.Active);
    }

    public Collection<PageExtensionElement> getExtensions(String domain) {
        return this.getExtensions(domain, null);
    }

    public Collection<PageExtensionElement> getCategoryExtensions(String domain, String category) {
        ArrayList<PageExtensionElement> result = new ArrayList<PageExtensionElement>();
        Collection<PageExtensionElement> catExtensions = this.getExtensions(domain, null);
        for (PageExtensionElement pee : catExtensions) {
            if (!pee.getCategory().equalsIgnoreCase(category)) continue;
            result.add(pee);
        }
        return result;
    }

    public Collection<IDiagramHelper> getDiagramHelpersExtensions(String domain) {
        return this.getActiveExtensions(domain).stream().map(PageExtensionElement::getDiagramHelper).filter(diagramHelper -> diagramHelper != null).collect(Collectors.toSet());
    }

    public Collection<IFileNameService> getFileNameServicesExtensions(String domain) {
        return this.getActiveExtensions(domain).stream().map(PageExtensionElement::getFileNameService).filter(fileNS -> fileNS != null).collect(Collectors.toSet());
    }

    public Collection<String> getCategories(String domain) {
        return this.getCategories(domain, null);
    }

    public Collection<String> getCategories(String domain, PageExtensionElement.PageExtensionActivationStatus status) {
        ArrayList<String> result = new ArrayList<String>();
        Collection<PageExtensionElement> etxs = this.getExtensions(domain, status);
        for (PageExtensionElement ext : etxs) {
            String category = ext.getCategory();
            if (result.contains(category)) continue;
            result.add(category);
        }
        return result;
    }

    public void setCategoryActivationStatus(String domain, String category, PageExtensionElement.PageExtensionActivationStatus status) {
        Collection<PageExtensionElement> etxs = this.getCategoryExtensions(domain, category);
        for (PageExtensionElement ext : etxs) {
            ext.setCurrentActivactionStatus(status);
        }
    }

    public PageExtensionElement.PageExtensionActivationStatus getCategoryActivationStatus(String domain, String category) {
        Collection<PageExtensionElement> exts = this.getCategoryExtensions(domain, category);
        boolean isActive = false;
        boolean isInactive = false;
        for (PageExtensionElement ext : exts) {
            switch (ext.getCurrentActivactionStatus()) {
                case Active: {
                    if (isInactive) {
                        return PageExtensionElement.PageExtensionActivationStatus.Unknown;
                    }
                    isActive = true;
                    break;
                }
                case Inactive: {
                    if (isActive) {
                        return PageExtensionElement.PageExtensionActivationStatus.Unknown;
                    }
                    isInactive = true;
                    break;
                }
                case Unknown: {
                    return PageExtensionElement.PageExtensionActivationStatus.Unknown;
                }
            }
        }
        return exts.isEmpty() ? PageExtensionElement.PageExtensionActivationStatus.Unknown : ((PageExtensionElement)((List)exts).get(0)).getCurrentActivactionStatus();
    }

    public boolean isPageCandidate(EObject model, String domain) {
        Collection<PageExtensionElement> etxs = this.getActiveExtensions(domain);
        for (PageExtensionElement ext : etxs) {
            List<URI> patternURI = ext.getPageURI();
            for (URI uri : patternURI) {
                Pattern pattern;
                EList parameters;
                EObject eObject = this.egfResourceSet.getEObject(uri, true);
                if (eObject == null || !(eObject instanceof Pattern) || (parameters = (pattern = (Pattern)eObject).getParameters()) == null || parameters.isEmpty()) continue;
                PatternParameter firstParameter = (PatternParameter)parameters.get(0);
                try {
                    if (!this.checkPatternParameter(model, firstParameter) || !this.checkPatternPrecondition(model, pattern)) continue;
                    return true;
                }
                catch (PatternException | ExtensionHelper.MissingExtensionException e) {
                    Activator.logError(e.getMessage(), e);
                }
            }
        }
        return false;
    }

    private boolean checkPatternParameter(EObject model, PatternParameter parameter) {
        String modelURI;
        String parameterType = parameter.getType();
        if (parameterType.equalsIgnoreCase(modelURI = EcoreUtil.getURI((EObject)model.eClass()).toString())) {
            return true;
        }
        EList superTypes = model.eClass().getEAllSuperTypes();
        for (EClass eClass : superTypes) {
            String eclassURI = EcoreUtil.getURI((EObject)eClass).toString();
            if (!parameterType.equalsIgnoreCase(eclassURI)) continue;
            return true;
        }
        return false;
    }

    private boolean checkPatternPrecondition(EObject model, Pattern pattern) throws ExtensionHelper.MissingExtensionException, PatternException {
        HashMap<PatternParameter, EObject> parameters = new HashMap<PatternParameter, EObject>();
        parameters.put((PatternParameter)pattern.getAllParameters().get(0), model);
        PatternExtension extension = ExtensionHelper.getExtension((PatternNature)pattern.getNature());
        PatternEngine engine = extension.createEngine(pattern);
        return engine.checkCondition(this.createPatternContext(pattern), parameters);
    }

    protected PatternContext createPatternContext(final Pattern pattern) {
        return new ExecutionContext(new BundleAccessor(){

            public Bundle getBundle(String id) throws PatternException {
                URI uri = EcoreUtil.getURI((EObject)pattern);
                String pluginID = uri.segment(1);
                return Platform.getBundle((String)pluginID);
            }
        });
    }
}

