/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.query.SiriusReferenceFinder;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.polarsys.kitalpha.doc.gen.business.core.internal.GenDocDiagramEditPartService;
import org.polarsys.kitalpha.doc.gen.business.core.preference.helper.DocgenDiagramPreferencesHelper;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;

public class SiriusHelper {
    private SiriusHelper() {
    }

    public static Collection<DRepresentation> getDiagramForObject(EObject element) {
        Session currentSession = DiagramSessionHelper.getCurrentSession();
        return SiriusHelper.getDiagramForObject(element, currentSession);
    }

    public static Collection<DRepresentation> getDiagramForObject(EObject element, boolean showInvisible) {
        Session currentSession = DiagramSessionHelper.getCurrentSession();
        return SiriusHelper.getDiagramForObject(element, currentSession, showInvisible);
    }

    public static Collection<DRepresentation> getDiagramForObject(EObject element, Session session) {
        return SiriusHelper.getDiagramForObject(element, session, false);
    }

    public static Collection<DRepresentation> getDiagramForObject(EObject element, Session session, boolean showInvisible) {
        Optional opFinder;
        ArrayList<DRepresentation> result = new ArrayList<DRepresentation>();
        if (DocgenDiagramPreferencesHelper.getExportDiagram() && (opFinder = SiriusReferenceFinder.of((EObject)element)).isPresent()) {
            SiriusReferenceFinder finder = (SiriusReferenceFinder)opFinder.get();
            HashSet<EObject> elements = new HashSet<EObject>();
            elements.add(element);
            Map referencingSiriusElements = finder.getReferencingSiriusElements(elements, SiriusReferenceFinder.SearchScope.ALL_REPRESENTATIONS_SCOPE);
            if (!referencingSiriusElements.isEmpty()) {
                Collection representations = (Collection)referencingSiriusElements.get(element);
                representations.stream().filter(rep -> rep instanceof DRepresentation || rep instanceof DRepresentationElement).forEach(rep -> {
                    DRepresentation repToAdd = null;
                    if (rep instanceof DRepresentation) {
                        repToAdd = (DRepresentation)rep;
                    } else if (rep instanceof DRepresentationElement && rep instanceof DDiagramElement) {
                        Option representation;
                        DDiagramElement ddElem = (DDiagramElement)rep;
                        if ((showInvisible || ddElem.isVisible()) && (representation = new EObjectQuery(rep).getRepresentation()).some()) {
                            repToAdd = (DRepresentation)representation.get();
                        }
                    }
                    if (!result.contains(repToAdd)) {
                        result.add(repToAdd);
                    }
                });
            }
        }
        return result;
    }

    public static double initAutoScaling(GenDocDiagramEditPartService tool, DiagramEditPart diagramEditPart) {
        tool.setAutoScalingEnabled(true);
        tool.getExportResolutionFactor(diagramEditPart);
        double scalingFactor = tool.getScalingFactor();
        if (scalingFactor >= 1.0) {
            tool.setAutoScalingEnabled(false);
        }
        return scalingFactor;
    }
}

