/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.configuration.ui.viewer;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.BrowserElementWrapper;
import org.polarsys.capella.docgen.configuration.ui.Activator;

public class GenerationContainerCheckedTreeViewer
extends ContainerCheckedTreeViewer {
    private static final String IMPOSSIBLE_TO_GET_ELEMENT_FROM_MAP = "Impossible to get element from map";
    private static final String REMOVE = "remove";
    private static final String VIRTUAL_DISPOSE_KEY = "org.eclipse.jface.DISPOSE_LISTENER";

    public GenerationContainerCheckedTreeViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void doCheckStateChanged(Widget item) {
        if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            treeItem.setGrayed(false);
            this.updateChildrenItems(treeItem);
            this.updateParentItems(treeItem.getParentItem());
        }
    }

    private void updateChildrenItems(TreeItem parent) {
        Item[] children = this.getChildren((Widget)parent);
        boolean state = parent.getChecked();
        int i = 0;
        while (i < children.length) {
            TreeItem curr = (TreeItem)children[i];
            if (curr.getData() != null && (curr.getChecked() != state || curr.getGrayed())) {
                curr.setChecked(state);
                curr.setGrayed(false);
                this.updateChildrenItems(curr);
            }
            ++i;
        }
    }

    private void updateParentItems(TreeItem item) {
        if (item != null) {
            Item[] children = this.getChildren((Widget)item);
            boolean containsChecked = false;
            boolean containsUnchecked = false;
            int i = 0;
            while (i < children.length) {
                TreeItem curr = (TreeItem)children[i];
                containsChecked |= curr.getChecked();
                containsUnchecked |= !curr.getChecked() || curr.getGrayed();
                ++i;
            }
            item.setChecked(containsChecked);
            item.setGrayed(containsChecked && containsUnchecked);
            this.updateParentItems(item.getParentItem());
        }
    }

    protected void mapElement(Object element, Widget item) {
        Optional value = ReflectionHelper.getFieldValueWithoutException((Object)((Object)this), (String)"elementMap");
        if (!value.isPresent()) {
            return;
        }
        if (value.get() != null) {
            Object widgetOrWidgets = this.getElementMap(value.get(), element);
            if (widgetOrWidgets == null) {
                this.putElementMap(value.get(), element, item);
            } else if (widgetOrWidgets instanceof Widget) {
                if (widgetOrWidgets != item) {
                    this.putElementMap(value.get(), element, new Widget[]{(Widget)widgetOrWidgets, item});
                }
            } else {
                Widget[] widgets = (Widget[])widgetOrWidgets;
                int indexOfItem = Arrays.asList(widgets).indexOf(item);
                if (indexOfItem == -1) {
                    int length = widgets.length;
                    Widget[] widgetArray = widgets;
                    widgets = new Widget[length + 1];
                    System.arraycopy(widgetArray, 0, widgets, 0, length);
                    widgets[length] = item;
                    this.putElementMap(value.get(), element, widgets);
                }
            }
        }
        this.unmapItemsOnTree(item);
    }

    private void unmapItemsOnTree(final Widget item) {
        if ((this.getTree().getStyle() & 0x10000000) != 0 && item.getData(VIRTUAL_DISPOSE_KEY) == null) {
            item.setData(VIRTUAL_DISPOSE_KEY, (Object)Boolean.TRUE);
            item.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Optional treeIsDisposed = ReflectionHelper.getFieldValueWithoutException((Object)this, (String)"treeIsDisposed");
                    if (treeIsDisposed.isPresent() && !((Boolean)treeIsDisposed.get()).booleanValue()) {
                        Object data = item.getData();
                        if (GenerationContainerCheckedTreeViewer.this.usingElementMap() && data != null) {
                            GenerationContainerCheckedTreeViewer.this.unmapElement(data, item);
                        }
                    }
                }
            });
        }
    }

    private void putElementMap(Object elementMap, Object element, Object item) {
        ReflectionHelper.invokeMethodWithoutException((Object)elementMap, elementMap.getClass(), (String)"put", (Class[])new Class[]{Object.class, Object.class}, (Object[])new Object[]{element, item}, (boolean)true);
        if (element instanceof DRepresentationDescriptor) {
            ReflectionHelper.invokeMethodWithoutException((Object)elementMap, elementMap.getClass(), (String)"put", (Class[])new Class[]{Object.class, Object.class}, (Object[])new Object[]{((DRepresentationDescriptor)element).getRepresentation(), item}, (boolean)true);
        }
        if (element instanceof DRepresentationElement) {
            ReflectionHelper.invokeMethodWithoutException((Object)elementMap, elementMap.getClass(), (String)"put", (Class[])new Class[]{Object.class, Object.class}, (Object[])new Object[]{((DRepresentationElement)element).getTarget(), item}, (boolean)true);
        }
        if (element instanceof BrowserElementWrapper) {
            ReflectionHelper.invokeMethodWithoutException((Object)elementMap, elementMap.getClass(), (String)"put", (Class[])new Class[]{Object.class, Object.class}, (Object[])new Object[]{((BrowserElementWrapper)element).getElement(), item}, (boolean)true);
        }
    }

    private Object getElementMap(Object elementMap, Object element) {
        try {
            return ReflectionHelper.invokeMethod((Object)elementMap, elementMap.getClass(), (String)"get", (Class[])new Class[]{Object.class}, (Object[])new Object[]{element}, (boolean)true);
        }
        catch (SecurityException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_GET_ELEMENT_FROM_MAP, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_GET_ELEMENT_FROM_MAP, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_GET_ELEMENT_FROM_MAP, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_GET_ELEMENT_FROM_MAP, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Activator.getDefault().getLog().error(IMPOSSIBLE_TO_GET_ELEMENT_FROM_MAP, (Throwable)e);
        }
        return null;
    }

    private void removeElementMap(Object elementMap, Object element) {
        ReflectionHelper.invokeMethodWithoutException((Object)elementMap, elementMap.getClass(), (String)REMOVE, (Class[])new Class[]{Object.class}, (Object[])new Object[]{element}, (boolean)true);
        if (element instanceof BrowserElementWrapper) {
            ReflectionHelper.invokeMethodWithoutException((Object)elementMap, elementMap.getClass(), (String)REMOVE, (Class[])new Class[]{Object.class}, (Object[])new Object[]{((BrowserElementWrapper)element).getElement()}, (boolean)true);
        }
        if (element instanceof DRepresentationDescriptor) {
            ReflectionHelper.invokeMethodWithoutException((Object)elementMap, elementMap.getClass(), (String)REMOVE, (Class[])new Class[]{Object.class}, (Object[])new Object[]{((DRepresentationDescriptor)element).getRepresentation()}, (boolean)true);
        }
    }

    protected void unmapElement(Object element, Widget item) {
        Optional value = ReflectionHelper.getFieldValueWithoutException((Object)((Object)this), (String)"elementMap");
        if (!value.isPresent()) {
            return;
        }
        Object widgetOrWidgets = this.getElementMap(value.get(), element);
        if (widgetOrWidgets instanceof Widget) {
            if (item == widgetOrWidgets) {
                this.removeElementMap(value.get(), element);
            }
        } else if (widgetOrWidgets != null) {
            Widget[] widgets = (Widget[])widgetOrWidgets;
            int indexOfItem = Arrays.asList(widgets).indexOf(item);
            if (indexOfItem == -1) {
                return;
            }
            int length = widgets.length;
            if (indexOfItem == 0) {
                if (length == 1) {
                    this.removeElementMap(value.get(), element);
                } else {
                    Widget[] updatedWidgets = new Widget[length - 1];
                    System.arraycopy(widgets, 1, updatedWidgets, 0, length - 1);
                    this.putElementMap(value.get(), element, updatedWidgets);
                }
            } else {
                Widget[] updatedWidgets = new Widget[length - 1];
                System.arraycopy(widgets, 0, updatedWidgets, 0, indexOfItem);
                System.arraycopy(widgets, indexOfItem + 1, updatedWidgets, indexOfItem, length - indexOfItem - 1);
                this.putElementMap(value.get(), element, updatedWidgets);
            }
        }
    }

    public void createChildren(Widget widget) {
        super.createChildren(widget);
    }
}

