/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.configuration.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.polarsys.capella.common.ui.toolkit.browser.category.CategoryImpl;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.BrowserElementWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.CategoryWrapper;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigatorPatternFilter;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.CapellaNavigatorLabelProvider;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.docgen.configuration.ui.Activator;
import org.polarsys.capella.docgen.configuration.ui.Messages;
import org.polarsys.capella.docgen.configuration.ui.utils.ConfigurationUtils;
import org.polarsys.capella.docgen.configuration.ui.viewer.CapellaFilteredTree;
import org.polarsys.capella.docgen.configuration.ui.viewer.GenerationContainerCheckedTreeViewer;
import org.polarsys.capella.docgen.configuration.ui.viewer.providers.DetailsContentProvider;
import org.polarsys.capella.docgen.configuration.ui.viewer.providers.DetailsLabelProvider;
import org.polarsys.capella.docgen.configuration.ui.viewer.providers.SessionContentProvider;

public class SelectElementsWizardPage
extends WizardPage {
    private static final int DEFAULT_EXPAND_LEVEL = 2;
    private Session session;
    private Text fileText;
    private CapellaCommonNavigatorPatternFilter leftPatternFilter;
    private CapellaCommonNavigatorPatternFilter rightPatternFilter;
    private GenerationContainerCheckedTreeViewer leftTreeViewer;
    private GenerationContainerCheckedTreeViewer rightTreeViewer;
    private Button buttonLoad;
    private Button buttonSave;
    private ISelection initialSelection;

    public SelectElementsWizardPage(ISelection selection) {
        super("selectElementWizardPage");
        this.setTitle(Messages.SelectElementsWizardPage_0);
        this.setDescription(Messages.SelectElementsWizardPage_1);
        this.setMessage(Messages.SelectElementsWizardPage_2, 1);
        this.initSession(selection);
        this.initialSelection = selection;
    }

    protected void initSession(ISelection selection) {
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Object obj = ssel.getFirstElement();
            if (obj instanceof EObject) {
                this.session = SessionManager.INSTANCE.getSession((EObject)obj);
            } else if (obj instanceof IFile && CapellaResourceHelper.isAirdResource((IResource)((IFile)obj), (boolean)false)) {
                this.session = SessionHelper.getSession((IFile)((IFile)obj));
            }
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        this.createSelectElementsGroup(container);
        this.createConfigurationGroup(container);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    protected void createSelectElementsGroup(Composite container) {
        Group grpSelectElements = new Group(container, 0);
        grpSelectElements.setText(Messages.SelectElementsWizardPage_3);
        grpSelectElements.setLayout((Layout)new GridLayout(2, false));
        grpSelectElements.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createSelectElementsViewers(grpSelectElements);
    }

    protected void createConfigurationGroup(Composite container) {
        Group grpConfiguration = new Group(container, 0);
        grpConfiguration.setLayout((Layout)new GridLayout(3, false));
        grpConfiguration.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        grpConfiguration.setText(Messages.SelectElementsWizardPage_4);
        this.fileText = new Text((Composite)grpConfiguration, 2048);
        this.fileText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.buttonLoad = new Button((Composite)grpConfiguration, 0);
        this.buttonLoad.setLayoutData((Object)new GridData(0x1000000, 4, false, false, 1, 1));
        this.buttonLoad.setImage(Activator.getImageDescriptor("icons/full/ctool16/load-16x16.gif").createImage());
        this.buttonLoad.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(SelectElementsWizardPage.this.getShell());
                fileDialog.setFilterExtensions(new String[]{Messages.SelectElementsWizardPage_6});
                fileDialog.setOverwrite(true);
                fileDialog.setText(Messages.SelectElementsWizardPage_7);
                String selectedFile = fileDialog.open();
                if (selectedFile != null) {
                    SelectElementsWizardPage.this.fileText.setText(selectedFile);
                    SelectElementsWizardPage.this.loadConfigurationFile(selectedFile);
                    SelectElementsWizardPage.this.dialogChanged();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.buttonSave = new Button((Composite)grpConfiguration, 0);
        this.buttonSave.setLayoutData((Object)new GridData(0x1000000, 4, false, false, 1, 1));
        this.buttonSave.setImage(Activator.getImageDescriptor("icons/full/ctool16/save-16x16.gif").createImage());
        this.buttonSave.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(SelectElementsWizardPage.this.getShell(), 8192);
                fileDialog.setFilterExtensions(new String[]{Messages.SelectElementsWizardPage_6});
                if (SelectElementsWizardPage.this.fileText.getText() != null && SelectElementsWizardPage.this.fileText.getText() != "") {
                    fileDialog.setFileName(SelectElementsWizardPage.this.fileText.getText());
                } else {
                    fileDialog.setFileName(Messages.SelectElementsWizardPage_10);
                }
                fileDialog.setOverwrite(true);
                fileDialog.setText(Messages.SelectElementsWizardPage_11);
                String selectedDirectory = fileDialog.open();
                if (selectedDirectory != null) {
                    if (!selectedDirectory.endsWith(Messages.SelectElementsWizardPage_16)) {
                        selectedDirectory = String.valueOf(selectedDirectory) + Messages.SelectElementsWizardPage_16;
                    }
                    SelectElementsWizardPage.this.fileText.setText(selectedDirectory);
                    SelectElementsWizardPage.this.saveConfigurationFile(selectedDirectory);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void checkRightOnLeftSelection() {
        Object[] objectArray = this.leftTreeViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Widget[] findItems;
            Object checkedElement = objectArray[n2];
            if (checkedElement instanceof DRepresentationDescriptor) {
                checkedElement = ((DRepresentationDescriptor)checkedElement).getRepresentation();
            }
            Widget[] widgetArray = findItems = this.rightTreeViewer.testFindItems(checkedElement);
            int n3 = findItems.length;
            int n4 = 0;
            while (n4 < n3) {
                Widget widget = widgetArray[n4];
                if (widget instanceof TreeItem) {
                    if (widget.getData() instanceof DRepresentationElement) {
                        ((TreeItem)widget).setChecked(true);
                    } else if (((TreeItem)widget).getParentItem() != null && !(((TreeItem)widget).getParentItem().getData() instanceof EObjectWrapper)) {
                        ((TreeItem)widget).setChecked(true);
                        this.rightTreeViewer.doCheckStateChanged((Widget)((TreeItem)widget));
                    } else if (((TreeItem)widget).getParentItem() != null && ((TreeItem)widget).getParentItem().getData() instanceof EObjectWrapper && this.allChidrenCheckedinLeftViewer(((TreeItem)widget).getParentItem())) {
                        ((TreeItem)widget).getParentItem().setChecked(true);
                        this.rightTreeViewer.doCheckStateChanged((Widget)((TreeItem)widget).getParentItem());
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private boolean allChidrenCheckedinLeftViewer(TreeItem item) {
        TreeItem[] treeItemArray = item.getParentItem().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            if (!this.leftTreeViewer.getChecked(child.getData())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void createSelectElementsViewers(Group grpSelectElements) {
        CommonViewer viewer;
        IViewPart viewPart;
        IWorkbenchPage activePage;
        this.leftTreeViewer = (GenerationContainerCheckedTreeViewer)this.createFilteredCheckBoxTreeViewer(grpSelectElements);
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null && (activePage = workbenchWindow.getActivePage()) != null && (viewPart = activePage.findView("capella.project.explorer")) instanceof CommonNavigator && (viewer = ((CommonNavigator)viewPart).getCommonViewer()) != null) {
            ViewerFilter[] filters = viewer.getFilters();
            ViewerFilter[] previousFilters = this.leftTreeViewer.getFilters();
            this.leftTreeViewer.setFilters(filters);
            int i = 0;
            while (i < previousFilters.length) {
                this.leftTreeViewer.addFilter(previousFilters[i]);
                ++i;
            }
        }
        this.leftTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty() && !((TreeSelection)event.getSelection()).getFirstElement().equals(SelectElementsWizardPage.this.rightTreeViewer.getInput())) {
                    SelectElementsWizardPage.this.rightTreeViewer.setInput(SelectElementsWizardPage.this.leftTreeViewer.getInput());
                    SelectElementsWizardPage.this.rightTreeViewer.setSubtreeChecked(SelectElementsWizardPage.this.leftTreeViewer.getInput(), false);
                    SelectElementsWizardPage.this.rightTreeViewer.setInput(((IStructuredSelection)event.getSelection()).getFirstElement());
                    SelectElementsWizardPage.this.checkRightOnLeftSelection();
                }
            }
        });
        this.leftTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                SelectElementsWizardPage.this.rightTreeViewer.setInput(SelectElementsWizardPage.this.leftTreeViewer.getInput());
                SelectElementsWizardPage.this.rightTreeViewer.setSubtreeChecked(SelectElementsWizardPage.this.leftTreeViewer.getInput(), false);
                SelectElementsWizardPage.this.rightTreeViewer.setInput(element);
                Object[] objectArray = SelectElementsWizardPage.this.leftTreeViewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object checkedObject = objectArray[n2];
                    SelectElementsWizardPage.this.checkElementLeftToRight(checkedObject, true);
                    ++n2;
                }
                SelectElementsWizardPage.this.checkChildrenElementLeftToRight(element, event.getChecked());
                SelectElementsWizardPage.this.checkParentElementLeftToRight(element, event.getChecked());
                SelectElementsWizardPage.this.dialogChanged();
            }
        });
        this.rightTreeViewer = (GenerationContainerCheckedTreeViewer)this.createRightFilteredCheckBoxTreeViewer(grpSelectElements);
        this.rightTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof EObjectWrapper) {
                    TreeItem lastClickedItem = null;
                    Optional itemOption = ReflectionHelper.getFieldValueWithoutException((Object)((Object)SelectElementsWizardPage.this.rightTreeViewer), (String)"lastClickedItem");
                    if (itemOption.isPresent()) {
                        lastClickedItem = (TreeItem)itemOption.get();
                        while (lastClickedItem.getParentItem() != null && lastClickedItem.getParentItem().getData() instanceof EObjectWrapper) {
                            lastClickedItem = lastClickedItem.getParentItem();
                            element = lastClickedItem.getData();
                        }
                    }
                }
                SelectElementsWizardPage.this.checkChildrenElementRightToLeft(element, event.getChecked());
                SelectElementsWizardPage.this.checkParentElementRightToLeft(element, event.getChecked());
                SelectElementsWizardPage.this.dialogChanged();
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    protected void checkParentElementRightToLeft(Object element, boolean checked) {
        if (element instanceof DRepresentationDescriptor) {
            element = ((DRepresentationDescriptor)element).getRepresentation();
        }
        var7_4 = findItems = this.rightTreeViewer.testFindItems(element);
        var6_5 = findItems.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block5: {
                findItem = var7_4[var5_6];
                if (!(findItem instanceof TreeItem)) break block5;
                if (!checked) ** GOTO lbl19
                while (((TreeItem)findItem).getParentItem() != null && (((TreeItem)findItem).getParentItem().getData() instanceof EObjectWrapper || ((TreeItem)findItem).getParentItem().getData() instanceof DRepresentationElement)) {
                    this.checkElementRightToLeft(((TreeItem)findItem).getParentItem().getData(), checked);
                    findItem = ((TreeItem)findItem).getParentItem();
                }
                break block5;
lbl-1000:
                // 1 sources

                {
                    this.leftTreeViewer.setChecked(((DRepresentationElement)((TreeItem)findItem).getParentItem().getData()).getTarget(), checked);
                    findItem = ((TreeItem)findItem).getParentItem();
lbl19:
                    // 2 sources

                    ** while (((TreeItem)findItem).getParentItem() != null && ((TreeItem)findItem).getParentItem().getData() instanceof DRepresentationElement && !((TreeItem)findItem).getParentItem().getChecked())
                }
lbl20:
                // 2 sources

                while (((TreeItem)findItem).getParentItem() != null && ((TreeItem)findItem).getParentItem().getChecked() && ((TreeItem)findItem).getParentItem().getData() instanceof EObjectWrapper) {
                    this.checkElementRightToLeft(((TreeItem)findItem).getParentItem().getData(), checked);
                    findItem = ((TreeItem)findItem).getParentItem();
                }
            }
            ++var5_6;
        }
    }

    protected void checkChildrenElementRightToLeft(Object element, boolean checked) {
        Widget[] findItems;
        Widget[] widgetArray = findItems = this.checkElementRightToLeft(element, checked);
        int n = findItems.length;
        int n2 = 0;
        while (n2 < n) {
            Widget findItem = widgetArray[n2];
            if (!(findItem.getData() instanceof EObjectWrapper)) {
                TreeItem[] children = ((TreeItem)findItem).getItems();
                if (children.length > 0 && children[0].getData() == null) {
                    this.rightTreeViewer.createChildren(findItem);
                }
                if (findItem instanceof TreeItem) {
                    TreeItem[] treeItemArray = ((TreeItem)findItem).getItems();
                    int n3 = treeItemArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeItem child = treeItemArray[n4];
                        if (child.getData() != null) {
                            if (findItem instanceof TreeItem && !((TreeItem)findItem).getChecked()) {
                                this.rightTreeViewer.setChecked(((TreeItem)findItem).getData(), checked);
                            }
                            this.checkElementRightToLeft(child.getData(), checked);
                            this.checkChildrenElementRightToLeft(child.getData(), checked);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    protected Widget[] checkElementRightToLeft(Object element, boolean checked) {
        Widget[] findItems;
        Widget[] widgetArray = findItems = this.rightTreeViewer.testFindItems(element);
        int n = findItems.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            if (widget instanceof TreeItem) {
                ((TreeItem)widget).setChecked(checked);
                if (!checked || !(element instanceof DRepresentationElement)) {
                    this.rightTreeViewer.doCheckStateChanged((Widget)((TreeItem)widget));
                }
            }
            ++n2;
        }
        if (element instanceof EObjectWrapper) {
            element = ((EObjectWrapper)element).getElement();
        }
        if (element instanceof DRepresentationElement) {
            element = ((DRepresentationElement)element).getTarget();
        }
        if (!(element instanceof BrowserElementWrapper)) {
            this.leftTreeViewer.setChecked(element, checked);
        }
        return findItems;
    }

    protected CheckboxTreeViewer createRightFilteredCheckBoxTreeViewer(Group grpSelectElements) {
        this.rightPatternFilter = new CapellaCommonNavigatorPatternFilter();
        CapellaFilteredTree _filteredTree = new CapellaFilteredTree((Composite)grpSelectElements, 770, this.rightPatternFilter, -1);
        _filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new DetailsLabelProvider());
        _filteredTree.getViewer().setContentProvider((IContentProvider)new DetailsContentProvider(this.session));
        _filteredTree.getViewer().setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof CategoryWrapper && this.isRepresentationCategory((CategoryWrapper)e1)) {
                    return 1;
                }
                if (e2 instanceof CategoryWrapper && this.isRepresentationCategory((CategoryWrapper)e2)) {
                    return -1;
                }
                return super.compare(viewer, e1, e2);
            }

            private boolean isRepresentationCategory(CategoryWrapper categoryWrapper) {
                CategoryImpl category = categoryWrapper.getElement();
                String categoryName = category.getName();
                return categoryName.equals("All Related Diagrams") || categoryName.equals("All Related Tables");
            }
        });
        _filteredTree.getViewer().setAutoExpandLevel(-1);
        return (CheckboxTreeViewer)_filteredTree.getViewer();
    }

    protected CheckboxTreeViewer createFilteredCheckBoxTreeViewer(Group grpSelectElements) {
        this.leftPatternFilter = new CapellaCommonNavigatorPatternFilter();
        CapellaFilteredTree filteredTree = new CapellaFilteredTree((Composite)grpSelectElements, 770, this.leftPatternFilter, 2);
        filteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new CapellaElementLabelProviderWithColors());
        filteredTree.getViewer().setContentProvider((IContentProvider)new SessionContentProvider(this.session));
        filteredTree.getViewer().setAutoExpandLevel(2);
        return (CheckboxTreeViewer)filteredTree.getViewer();
    }

    protected void initialize() {
        if (this.session != null) {
            this.leftTreeViewer.setInput(this.session);
            this.rightTreeViewer.setInput(this.session);
            if (this.initialSelection != null) {
                this.leftTreeViewer.setSelection(this.initialSelection, true);
                TreeSelection selectionInTree = (TreeSelection)this.leftTreeViewer.getSelection();
                TreePath[] treePathArray = selectionInTree.getPaths();
                int n = treePathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath path = treePathArray[n2];
                    this.leftTreeViewer.setChecked(path.getLastSegment(), true);
                    ++n2;
                }
                this.checkRightOnLeftSelection();
                this.dialogChanged();
            } else {
                this.leftTreeViewer.setSelection((ISelection)new StructuredSelection((Object)this.leftTreeViewer.getTree().getTopItem()));
            }
        }
    }

    public Collection<EObject> getSelectedElements() {
        HashSet<EObject> result = new HashSet<EObject>();
        List<Object> asList = Arrays.asList(this.leftTreeViewer.getCheckedElements());
        result.addAll(asList);
        return result;
    }

    protected void dialogChanged() {
        if (this.leftTreeViewer.getCheckedElements().length > 0) {
            this.updateStatus(null);
        } else if (ConfigurationUtils.getInstance().getMessage() != "" && ConfigurationUtils.getInstance().getMessage() != null) {
            this.updateStatus(String.valueOf(Messages.SelectElementsWizardPage_12) + " " + ConfigurationUtils.getInstance().getMessage());
        } else {
            this.updateStatus(Messages.SelectElementsWizardPage_12);
        }
    }

    protected void updateStatus(String message) {
        this.setErrorMessage(message);
        this.displayInformationMessageForGreyedElements();
        this.setPageComplete(message == null);
    }

    private void displayInformationMessageForGreyedElements() {
        ArrayList<Object> allCheckedElements = new ArrayList<Object>();
        allCheckedElements.addAll(Arrays.asList(this.leftTreeViewer.getCheckedElements()));
        allCheckedElements.addAll(Arrays.asList(this.rightTreeViewer.getCheckedElements()));
        ArrayList greyedCheckedElements = new ArrayList();
        for (Object e : allCheckedElements) {
            if (ConfigurationUtils.getInstance().canGenerateHtmlDocumentationFor(e)) continue;
            greyedCheckedElements.add(e);
        }
        if (!greyedCheckedElements.isEmpty()) {
            this.setMessage(Messages.SelectElementsWizardPage_17, 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void checkParentElementLeftToRight(Object element, boolean checked) {
        block2: {
            findItem = this.leftTreeViewer.testFindItem(element);
            if (!(findItem instanceof TreeItem)) break block2;
            if (!checked) ** GOTO lbl11
            while (((TreeItem)findItem).getParentItem() != null && ((TreeItem)findItem).getParentItem().getData() != null) {
                this.checkElementLeftToRight(((TreeItem)findItem).getParentItem().getData(), checked);
                findItem = ((TreeItem)findItem).getParentItem();
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                this.checkElementLeftToRight(((TreeItem)findItem).getParentItem().getData(), checked);
                findItem = ((TreeItem)findItem).getParentItem();
lbl11:
                // 2 sources

                ** while (((TreeItem)findItem).getParentItem() != null && ((TreeItem)findItem).getParentItem().getChecked() && ((TreeItem)findItem).getParentItem().getData() != null)
            }
        }
    }

    protected void checkChildrenElementLeftToRight(Object element, boolean checked) {
        if (element instanceof DRepresentationDescriptor) {
            element = ((DRepresentationDescriptor)element).getRepresentation();
        }
        this.checkElementLeftToRight(element, checked);
        Widget findItem = this.leftTreeViewer.testFindItem(element);
        if (findItem instanceof TreeItem && !((TreeItem)findItem).getChecked()) {
            this.leftTreeViewer.setChecked(((TreeItem)findItem).getData(), checked);
        }
        if (element instanceof DRepresentation) {
            this.leftTreeViewer.setChecked(((TreeItem)findItem).getData(), checked);
        }
        if (findItem instanceof TreeItem) {
            TreeItem[] children = ((TreeItem)findItem).getItems();
            if (children.length > 0 && children[0].getData() == null) {
                this.leftTreeViewer.createChildren(findItem);
            }
            TreeItem[] treeItemArray = ((TreeItem)findItem).getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                if (child.getData() != null) {
                    this.checkElementLeftToRight(child.getData(), checked);
                    this.checkChildrenElementLeftToRight(child.getData(), checked);
                }
                ++n2;
            }
        }
    }

    protected void checkElementLeftToRight(Object element, boolean checked) {
        Widget[] findItems;
        if (element instanceof DRepresentationDescriptor) {
            element = ((DRepresentationDescriptor)element).getRepresentation();
        }
        if ((findItems = this.rightTreeViewer.testFindItems(element)).length > 0 && findItems[0] instanceof TreeItem && checked) {
            this.leftTreeViewer.setChecked(this.rightTreeViewer.getInput(), checked);
        }
        Widget[] widgetArray = findItems;
        int n = findItems.length;
        int n2 = 0;
        while (n2 < n) {
            Widget widget = widgetArray[n2];
            if (widget instanceof TreeItem) {
                if (((TreeItem)widget).getData() instanceof DRepresentationElement) {
                    ((TreeItem)widget).setChecked(checked);
                } else if (((TreeItem)widget).getParentItem() != null && !(((TreeItem)widget).getParentItem().getData() instanceof EObjectWrapper)) {
                    ((TreeItem)widget).setChecked(checked);
                    this.rightTreeViewer.doCheckStateChanged((Widget)((TreeItem)widget));
                } else if (((TreeItem)widget).getParentItem() != null && ((TreeItem)widget).getParentItem().getData() instanceof EObjectWrapper) {
                    ((TreeItem)widget).getParentItem().setChecked(checked);
                    this.rightTreeViewer.doCheckStateChanged((Widget)((TreeItem)widget).getParentItem());
                }
            }
            ++n2;
        }
    }

    public void loadConfigurationFile(final String fileName) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.SelectElementsWizardPage_13, 3);
                    final List<EObject> configurationElements = ConfigurationUtils.getInstance().getElementsFromConfigurationFile(fileName, SelectElementsWizardPage.this.session, monitor);
                    monitor.worked(2);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).SelectElementsWizardPage.this.leftTreeViewer.getTree().getItemCount() > 0) {
                                (this).SelectElementsWizardPage.this.leftTreeViewer.setSubtreeChecked((this).SelectElementsWizardPage.this.leftTreeViewer.getTree().getItem(0).getData(), false);
                                if (!((this).SelectElementsWizardPage.this.rightTreeViewer.getInput() instanceof Session)) {
                                    (this).SelectElementsWizardPage.this.rightTreeViewer.setInput((this).SelectElementsWizardPage.this.leftTreeViewer.getInput());
                                    (this).SelectElementsWizardPage.this.rightTreeViewer.setAllChecked(false);
                                }
                            }
                            if (!configurationElements.isEmpty()) {
                                for (EObject element : configurationElements) {
                                    Widget findItem = (this).SelectElementsWizardPage.this.leftTreeViewer.testFindItem(element);
                                    if (findItem == null) {
                                        EObject parent = element.eContainer();
                                        ArrayList<EObject> toCalculateEObject = new ArrayList<EObject>();
                                        while (parent != null && (this).SelectElementsWizardPage.this.leftTreeViewer.testFindItem(parent) == null) {
                                            toCalculateEObject.add(0, parent);
                                            parent = parent.eContainer();
                                        }
                                        Widget parentWidget = (this).SelectElementsWizardPage.this.leftTreeViewer.testFindItem(parent);
                                        if (parentWidget != null) {
                                            (this).SelectElementsWizardPage.this.leftTreeViewer.createChildren(parentWidget);
                                            for (EObject eObject : toCalculateEObject) {
                                                (this).SelectElementsWizardPage.this.leftTreeViewer.createChildren((this).SelectElementsWizardPage.this.leftTreeViewer.testFindItem(eObject));
                                            }
                                        }
                                    }
                                    if (!(findItem instanceof TreeItem) || ((TreeItem)findItem).getItemCount() != 0) continue;
                                    (this).SelectElementsWizardPage.this.leftTreeViewer.setChecked(element, true);
                                }
                                SelectElementsWizardPage.this.checkRightOnLeftSelection();
                            }
                        }
                    });
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen.configuration.ui", e1.getMessage()));
        }
        catch (InterruptedException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen.configuration.ui", e1.getMessage()));
            Thread.currentThread().interrupt();
        }
    }

    public void saveConfigurationFile(final String fileName) {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.SelectElementsWizardPage_14, 2);
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ConfigurationUtils.getInstance().createConfigurationResource(fileName, SelectElementsWizardPage.this.getSelectedElements());
                        }
                    });
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen.configuration.ui", e1.getMessage()));
        }
        catch (InterruptedException e1) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.docgen.configuration.ui", e1.getMessage()));
            Thread.currentThread().interrupt();
        }
    }

    public void dispose() {
        this.buttonLoad.getImage().dispose();
        this.buttonSave.getImage().dispose();
        super.dispose();
    }

    private static final class CapellaElementLabelProviderWithColors
    extends CapellaNavigatorLabelProvider {
        private CapellaElementLabelProviderWithColors() {
        }

        public Color getBackground(Object object) {
            return super.getBackground(object);
        }

        public Color getForeground(Object object) {
            if (!ConfigurationUtils.getInstance().canGenerateHtmlDocumentationFor(object)) {
                return ConfigurationUtils.COLOR_ELEMENT_WITH_NO_HTML_DOCUMENTATION;
            }
            return super.getForeground(object);
        }
    }
}

