/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.ftask.internal.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.model.EGFFtaskPlugin;
import org.eclipse.egf.model.ftask.Task;
import org.eclipse.egf.model.ftask.internal.registry.TaskNatureProxy;
import org.eclipse.egf.model.ftask.l10n.EGFFtaskMessages;
import org.eclipse.egf.model.ftask.task.ITaskNature;
import org.eclipse.egf.model.ftask.task.ITaskNatureRegistry;
import org.eclipse.osgi.util.NLS;

public final class TaskNatureRegistry
implements ITaskNatureRegistry,
IRegistryEventListener {
    private Map<String, TaskNatureProxy> _proxies;
    public static final String EXTENSION_ID = "org.eclipse.egf.model.ftask.task";
    public static final String INVOKER_ATT_KIND = "kind";
    public static final String INVOKER_ATT_CLASS = "class";

    @Override
    public List<String> getKinds() {
        return new ArrayList<String>(this._proxies.keySet());
    }

    @Override
    public ITaskNature getTaskNature(Task task) throws InvocationException {
        if (task == null) {
            throw new InvocationException(EGFFtaskMessages.missing_task_message);
        }
        if (task.getKindValue() == null || task.getKindValue().trim().length() == 0) {
            throw new InvocationException(NLS.bind((String)EGFFtaskMessages.missing_kind_message, (Object)EMFHelper.getText((Object)task)));
        }
        String kind = task.getKindValue().trim();
        TaskNatureProxy taskNatureProxy = this._proxies.get(kind);
        ITaskNature taskNature = null;
        if (taskNatureProxy != null) {
            try {
                taskNature = taskNatureProxy.getTaskNature();
            }
            catch (CoreException ce) {
                throw new InvocationException(NLS.bind((String)EGFFtaskMessages.unable_to_create_nature_message, (Object)kind), (Throwable)ce);
            }
        }
        if (taskNature == null) {
            throw new InvocationException(NLS.bind((String)EGFFtaskMessages.missing_nature_message, (Object)kind));
        }
        return taskNature;
    }

    public TaskNatureRegistry() {
        this.initialize();
        RegistryFactory.getRegistry().addListener((IRegistryEventListener)this, EXTENSION_ID);
    }

    private void initialize() {
        if (this._proxies != null) {
            return;
        }
        this._proxies = new HashMap<String, TaskNatureProxy>();
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_ID);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    this.register(element);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void register(IConfigurationElement element) {
        if (element == null) {
            return;
        }
        TaskNatureProxy proxy = TaskNatureProxy.createProxy(element);
        if (proxy != null) {
            if (this._proxies.get(proxy.getKind()) != null) {
                EGFFtaskPlugin.getPlugin().logError(NLS.bind((String)EGFCommonMessages.Duplicate_Element_Message, (Object)proxy.getKind()));
                EGFFtaskPlugin.getPlugin().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)element.getContributor().getName()), 1);
                EGFFtaskPlugin.getPlugin().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)element.getName()), 1);
            }
            this._proxies.put(proxy.getKind(), proxy);
        }
    }

    public void added(IExtension[] extensions) {
        if (extensions == null) {
            return;
        }
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                this.register(element);
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            Iterator<TaskNatureProxy> it = this._proxies.values().iterator();
            while (it.hasNext()) {
                TaskNatureProxy proxy = it.next();
                if (!proxy.originatesFrom(extensions[i])) continue;
                it.remove();
            }
            ++i;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    public void dispose() {
        RegistryFactory.getRegistry().removeListener((IRegistryEventListener)this);
        this._proxies = null;
    }
}

