/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.generic.metadatamodel;

import org.eclipse.capra.core.adapters.IMetadataAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.generic.metadatamodel.ArtifactMetadata;
import org.eclipse.capra.generic.metadatamodel.MetadataContainer;
import org.eclipse.capra.generic.metadatamodel.MetadatamodelFactory;
import org.eclipse.capra.generic.metadatamodel.MetadatamodelPackage;
import org.eclipse.capra.generic.metadatamodel.TraceMetadata;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class GenericMetadataAdapter
implements IMetadataAdapter {
    private MetadataContainer getContainer(EObject container) {
        if (container.eClass().equals(MetadatamodelPackage.eINSTANCE.getMetadataContainer())) {
            return (MetadataContainer)container;
        }
        throw new IllegalArgumentException("The provider metadata container is not of the correct type");
    }

    public EObject createModel() {
        return MetadatamodelFactory.eINSTANCE.createMetadataContainer();
    }

    public EObject getMetadataForTrace(EObject trace, EObject metadataContainer) {
        MetadataContainer container = this.getContainer(metadataContainer);
        for (TraceMetadata metaData : container.getTraceMetadata()) {
            if (!EcoreUtil.equals((EObject)trace, (EObject)metaData.getTrace())) continue;
            return metaData;
        }
        TraceMetadata metadata = MetadatamodelFactory.eINSTANCE.createTraceMetadata();
        metadata.setTrace(trace);
        this.addInTransaction(container.getTraceMetadata(), metadata);
        return metadata;
    }

    public void setMetadataForTrace(EObject trace, EObject metaData, EObject metadataContainer) {
        EObject existingMetadata = this.getMetadataForTrace(trace, metadataContainer);
        if (metaData.equals(existingMetadata)) {
            return;
        }
        this.updateObjectInTransaction(metaData, existingMetadata);
    }

    public void removeMetadata(EObject object, EObject metadataContainer) {
        final MetadataContainer container = this.getContainer(metadataContainer);
        for (Object metaData : container.getTraceMetadata()) {
            if (!EcoreUtil.equals((EObject)object, (EObject)metaData.getTrace())) continue;
            TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain, "Remove trace metadata", (TraceMetadata)metaData){
                private final /* synthetic */ TraceMetadata val$metaData;
                {
                    this.val$metaData = traceMetadata;
                    super($anonymous0, $anonymous1);
                }

                protected void doExecute() {
                    container.getTraceMetadata().remove((Object)this.val$metaData);
                }
            };
            try {
                ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
            }
            catch (RollbackException e) {
                throw new IllegalStateException("Removing trace links was rolled back.", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Removing trace links was interrupted.", e);
            }
            return;
        }
        for (Object metaData : container.getArtifactMetadata()) {
            if (!EcoreUtil.equals((EObject)object, (EObject)metaData.getArtifact())) continue;
            TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
            RecordingCommand cmd = new RecordingCommand(editingDomain, "Remove artifact metadata", (ArtifactMetadata)metaData){
                private final /* synthetic */ ArtifactMetadata val$metaData;
                {
                    this.val$metaData = artifactMetadata;
                    super($anonymous0, $anonymous1);
                }

                protected void doExecute() {
                    container.getArtifactMetadata().remove((Object)this.val$metaData);
                }
            };
            try {
                ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
            }
            catch (RollbackException e) {
                throw new IllegalStateException("Removing trace links was rolled back.", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Removing trace links was interrupted.", e);
            }
            return;
        }
    }

    public EObject getMetadataForArtifact(EObject wrapper, EObject metadataContainer) {
        MetadataContainer container = this.getContainer(metadataContainer);
        for (ArtifactMetadata metaData : container.getArtifactMetadata()) {
            if (!EcoreUtil.equals((EObject)wrapper, (EObject)metaData.getArtifact())) continue;
            return metaData;
        }
        ArtifactMetadata metadata = MetadatamodelFactory.eINSTANCE.createArtifactMetadata();
        metadata.setArtifact(wrapper);
        this.addInTransaction(container.getArtifactMetadata(), metadata);
        return metadata;
    }

    public void setMetadataForArtifact(EObject wrapper, EObject metaData, EObject metadataContainer) {
        ArtifactMetadata existingMetadata = (ArtifactMetadata)this.getMetadataForArtifact(wrapper, metadataContainer);
        if (metaData.equals(existingMetadata)) {
            return;
        }
        this.updateObjectInTransaction(metaData, existingMetadata);
    }

    private <T> void addInTransaction(final EList<T> list, final T object) {
        TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain, "Add trace"){

            protected void doExecute() {
                list.add(object);
            }
        };
        try {
            ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
        }
        catch (RollbackException e) {
            throw new IllegalStateException("Adding to the list was rolled back.", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Adding to the list was interrupted.", e);
        }
    }

    private void updateObjectInTransaction(final EObject updatedObject, final EObject existingObject) {
        TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain, "Update Trace Model"){

            protected void doExecute() {
                for (EStructuralFeature feature : updatedObject.eClass().getEStructuralFeatures()) {
                    try {
                        existingObject.eSet(feature, updatedObject.eGet(feature));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        };
        try {
            ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
        }
        catch (RollbackException e) {
            throw new IllegalStateException("Updating trace metadata was rolled back.", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Updating trace metadata was interrupted.", e);
        }
    }
}

