/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.handler.asciidoc;

import de.jcup.asciidoctoreditor.outline.Item;
import de.jcup.asciidoctoreditor.outline.ItemType;
import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IArtifactMetaModelAdapter;
import org.eclipse.capra.core.handlers.AbstractArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactStatus;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.asciidoc.AsciiDocArtifact;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciiDocHandler
extends AbstractArtifactHandler<AsciiDocArtifact> {
    private static final Logger LOG = LoggerFactory.getLogger(AsciiDocHandler.class);

    public EObject createWrapper(AsciiDocArtifact artifact, EObject artifactModel) {
        IArtifactMetaModelAdapter adapter = (IArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();
        String internalResolver = "";
        internalResolver = artifact.getItem().getItemType() == ItemType.INLINE_ANCHOR ? artifact.getItem().getId() : String.valueOf(artifact.getItem().getOffset());
        return adapter.createArtifact(artifactModel, ((Object)((Object)this)).getClass().getName(), artifact.getUri(), internalResolver, artifact.getItem().getName());
    }

    public AsciiDocArtifact resolveWrapper(EObject wrapper) {
        IArtifactMetaModelAdapter adapter = (IArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();
        String uri = adapter.getArtifactUri(wrapper);
        Item item = new Item();
        try {
            String internalResolver = adapter.getArtifactInternalResolver(wrapper);
            if (AsciiDocHandler.isNumeric(internalResolver)) {
                int offset = Integer.parseInt(adapter.getArtifactInternalResolver(wrapper));
                Field offsetField = item.getClass().getDeclaredField("offset");
                offsetField.setAccessible(true);
                offsetField.set(item, offset);
            } else {
                Field itemType = item.getClass().getDeclaredField("type");
                itemType.setAccessible(true);
                itemType.set(item, ItemType.INLINE_ANCHOR);
                Field id = item.getClass().getDeclaredField("id");
                id.setAccessible(true);
                id.set(item, internalResolver);
            }
            Field nameField = item.getClass().getDeclaredField("name");
            nameField.setAccessible(true);
            nameField.set(item, adapter.getArtifactName(wrapper));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOG.error("Could not access fields of item", (Throwable)e);
        }
        return new AsciiDocArtifact(uri, item);
    }

    public boolean doesArtifactExist(EObject wrapper) {
        AsciiDocArtifact asciiDocArtifact = this.resolveWrapper(wrapper);
        return asciiDocArtifact != null && asciiDocArtifact.exists();
    }

    public ArtifactStatus getArtifactStatus(EObject wrapper) {
        AsciiDocArtifact asciiDocArtifact = this.resolveWrapper(wrapper);
        return asciiDocArtifact.getStatus();
    }

    public String getDisplayName(AsciiDocArtifact artifact) {
        return artifact.getItem().getName();
    }

    public String generateMarkerMessage(IResourceDelta delta, String wrapperUri) {
        return null;
    }

    public List<Connection> getInternalLinks(EObject investigatedElement, List<String> selectedRelationshipTypes, boolean reverseDirection) {
        return null;
    }

    public boolean isThereAnInternalTraceBetween(EObject first, EObject second) {
        return false;
    }

    private static boolean isNumeric(String input) {
        if (input == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

