/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.handler.emf.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.notification.CapraNotificationHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModelChangeListener
extends EContentAdapter {
    List<Integer> eventsToProcess = Arrays.asList(1, 3, 4);

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (!this.eventsToProcess.contains(notification.getEventType()) || !(notifier instanceof EObject)) {
            return;
        }
        Resource changedResource = ((EObject)notifier).eResource();
        if (changedResource != null) {
            this.compareTracedItems(changedResource);
        }
    }

    private void compareTracedItems(Resource changedResource) {
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        EObject traceModel = persistenceAdapter.getTraceModel(EditingDomainHelper.getResourceSet());
        if (traceModel != null && !traceModel.eContents().isEmpty()) {
            Path path = new Path(EcoreUtil.getURI((EObject)traceModel).toPlatformString(false));
            IFile traceContainer = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            ITraceabilityInformationModelAdapter traceMetamodelAdapter = (ITraceabilityInformationModelAdapter)ExtensionPointHelper.getTraceabilityInformationModelAdapter().orElseThrow();
            List connections = traceMetamodelAdapter.getAllTraceLinks(persistenceAdapter.getTraceModel(EditingDomainHelper.getResourceSet()));
            if (!connections.isEmpty()) {
                for (Connection c : connections) {
                    ArrayList tempList = new ArrayList();
                    tempList.addAll(c.getOrigins());
                    tempList.addAll(c.getTargets());
                    for (EObject tracedItem : tempList) {
                        Resource oldResource = tracedItem.eResource();
                        if (oldResource == null) {
                            oldResource = EditingDomainHelper.getResourceSet().getResource(EcoreUtil.getURI((EObject)tracedItem).trimFragment(), true);
                            continue;
                        }
                        if (!CapraNotificationHelper.getFileUri((Resource)oldResource).equals(CapraNotificationHelper.getFileUri((Resource)changedResource))) continue;
                        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)changedResource, (Notifier)oldResource, null);
                        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
                        for (Match match : comparison.getMatches()) {
                            this.resolveMatch(tracedItem, match, null, traceContainer);
                        }
                    }
                }
            }
        }
    }

    private void resolveMatch(EObject tracedItem, Match match, DifferenceKind diffKind, IFile traceContainer) {
        EObject oldObject;
        EList differences = match.getDifferences();
        if (!differences.isEmpty()) {
            diffKind = ((Diff)differences.get(0)).getKind();
        }
        for (Match subMatch : match.getSubmatches()) {
            this.resolveMatch(tracedItem, subMatch, diffKind, traceContainer);
        }
        EObject newObject = match.getLeft();
        if (newObject != null) {
            URI oldUri = CapraNotificationHelper.getFileUri((EObject)tracedItem);
            if (CapraNotificationHelper.getFileUri((EObject)newObject).equals(oldUri)) {
                CapraNotificationHelper.deleteCapraMarker((String)oldUri.toString(), null, (IFile)traceContainer);
            }
        }
        if (diffKind != null && (oldObject = match.getRight()) != null && oldObject.equals(tracedItem)) {
            CapraNotificationHelper.IssueType issueType = null;
            if (diffKind.equals((Object)DifferenceKind.DELETE)) {
                issueType = CapraNotificationHelper.IssueType.DELETED;
            } else if (diffKind.equals((Object)DifferenceKind.MOVE)) {
                issueType = CapraNotificationHelper.IssueType.MOVED;
            } else if (diffKind.equals((Object)DifferenceKind.ADD)) {
                issueType = CapraNotificationHelper.IssueType.ADDED;
            } else if (diffKind.equals((Object)DifferenceKind.CHANGE)) {
                issueType = CapraNotificationHelper.IssueType.RENAMED;
            }
            if (issueType != null) {
                this.createCapraMarker(tracedItem, match, issueType, traceContainer);
            }
        }
    }

    private void createCapraMarker(EObject tracedItem, Match match, CapraNotificationHelper.IssueType issueType, IFile file) {
        String oldUri = CapraNotificationHelper.getFileUri((EObject)tracedItem).toString();
        String oldName = (String)tracedItem.eGet(tracedItem.eClass().getEStructuralFeature("name"));
        EObject changedObject = match.getLeft();
        String newUri = "";
        String newName = "";
        if (changedObject != null) {
            newUri = CapraNotificationHelper.getFileUri((EObject)changedObject).toString();
            newName = (String)changedObject.eGet(changedObject.eClass().getEStructuralFeature("name"));
        }
        String message = "";
        switch (issueType) {
            case DELETED: {
                if (changedObject != null) break;
                message = String.valueOf(oldUri) + " has been deleted.";
                break;
            }
            case MOVED: {
                if (oldUri.equals(newUri)) break;
                message = String.valueOf(oldName) + " has been moved to " + newUri + ".";
                break;
            }
            case RENAMED: {
                if (!newName.equals(oldName)) {
                    message = String.valueOf(oldUri) + " has been renamed to " + newName + ".";
                    break;
                }
                message = "An ancestor of " + oldName + " has been renamed." + " The new URI of the element is " + newUri;
                break;
            }
            case ADDED: {
                break;
            }
        }
        if (issueType != null) {
            HashMap<String, String> markerInfo = new HashMap<String, String>();
            markerInfo.put("issueType", issueType.getValue());
            markerInfo.put("message", message);
            markerInfo.put("oldArtifactUri", oldUri);
            markerInfo.put("newArtifactUri", newUri);
            markerInfo.put("newArtifactName", newName);
            CapraNotificationHelper.createCapraMarker(markerInfo, (IResource)file);
        }
    }
}

