/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.notification;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.ArtifactStatus;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.notification.CapraNotificationHelper;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CheckArtifactExistenceHandler
extends AbstractHandler {
    private final ITraceabilityInformationModelAdapter traceAdapter = (ITraceabilityInformationModelAdapter)ExtensionPointHelper.getTraceabilityInformationModelAdapter().get();
    private IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().get();
    private ResourceSet resourceSet = EditingDomainHelper.getResourceSet();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Job job = new Job("Check if linked artifacts exist"){

            protected IStatus run(IProgressMonitor monitor) {
                HashSet artifacts = new HashSet();
                EObject traceModel = CheckArtifactExistenceHandler.this.persistenceAdapter.getTraceModel(CheckArtifactExistenceHandler.this.resourceSet);
                EObject artifactModel = CheckArtifactExistenceHandler.this.persistenceAdapter.getArtifactWrappers(CheckArtifactExistenceHandler.this.resourceSet);
                Path path = new Path(EcoreUtil.getURI((EObject)artifactModel).toPlatformString(false));
                IFile wrapperContainer = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                List connections = CheckArtifactExistenceHandler.this.traceAdapter.getAllTraceLinks(traceModel);
                for (Connection connection : connections) {
                    artifacts.addAll(connection.getOrigins());
                    artifacts.addAll(connection.getTargets());
                    for (EObject obj : artifacts) {
                        HashMap<String, String> markerInfo;
                        ArtifactHelper artifactHelper = new ArtifactHelper(CheckArtifactExistenceHandler.this.persistenceAdapter.getArtifactWrappers(CheckArtifactExistenceHandler.this.resourceSet));
                        Optional handler = artifactHelper.getHandler(artifactHelper.unwrapWrapper((Object)obj));
                        if (!handler.isPresent()) continue;
                        ArtifactStatus artifactStatus = ((IArtifactHandler)handler.get()).getArtifactStatus(obj);
                        if (artifactStatus.getStatus() == ArtifactStatus.Status.REMOVED) {
                            markerInfo = new HashMap<String, String>();
                            markerInfo.put("issueType", CapraNotificationHelper.IssueType.DELETED.getValue());
                            markerInfo.put("message", "Linked artifact " + artifactHelper.getArtifactLabel(obj) + " does not exist anymore");
                            markerInfo.put("oldArtifactUri", artifactHelper.getArtifactLocation(obj));
                            markerInfo.put("newArtifactUri", "");
                            markerInfo.put("newArtifactName", "");
                            CapraNotificationHelper.createCapraMarker(markerInfo, (IResource)wrapperContainer);
                            continue;
                        }
                        if (artifactStatus.getStatus() != ArtifactStatus.Status.RENAMED) continue;
                        markerInfo = new HashMap();
                        markerInfo.put("issueType", CapraNotificationHelper.IssueType.RENAMED.getValue());
                        markerInfo.put("message", "Linked artifact \"" + artifactStatus.getOldName() + "\" has been renamed to \"" + artifactStatus.getNewName() + "\"");
                        markerInfo.put("oldArtifactUri", artifactHelper.getArtifactLocation(obj));
                        markerInfo.put("oldArtifactName", artifactHelper.getArtifactLabel(obj));
                        markerInfo.put("newArtifactUri", CapraNotificationHelper.getFileUri(obj).toPlatformString(false));
                        markerInfo.put("newArtifactName", artifactStatus.getNewName());
                        CapraNotificationHelper.createCapraMarker(markerInfo, (IResource)wrapperContainer);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(40);
        job.setUser(true);
        job.schedule();
        return null;
    }
}

