/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.table;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.capra.ui.office.model.CapraOfficeObject;
import org.eclipse.capra.ui.office.table.OfficeTableDataProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.swt.graphics.Rectangle;

public class OfficeSelectionProvider
implements ISelectionProvider,
ILayerListener {
    private Set<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();
    private SelectionLayer selectionLayer;
    private CapraOfficeObject selectedObject;
    private OfficeTableDataProvider dataProvider;
    private ISelection previousSelection;

    public OfficeSelectionProvider(SelectionLayer selectionLayer, OfficeTableDataProvider dataProvider) {
        this.updateProvider(selectionLayer, dataProvider);
    }

    public void handleLayerEvent(ILayerEvent event) {
        ISelection selection;
        if ((event instanceof CellSelectionEvent || event instanceof RowSelectionEvent || event instanceof ColumnSelectionEvent) && (selection = this.getSelection()) != null && !selection.equals(this.previousSelection)) {
            try {
                for (ISelectionChangedListener listener : this.listeners) {
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
                }
            }
            finally {
                this.previousSelection = selection;
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public ISelection getSelection() {
        if (this.selectionLayer.getFullySelectedRowPositions().length > 0) {
            CapraOfficeObject selectedObject = this.dataProvider.getRowHighlight(this.selectionLayer.getFullySelectedRowPositions()[0] + 1);
            if (selectedObject != null) {
                this.selectedObject = selectedObject;
                return new StructuredSelection((Object)selectedObject);
            }
        } else if (this.selectionLayer.getSelectedCellPositions().length > 0) {
            Rectangle row = new Rectangle(0, this.selectionLayer.getSelectedCellPositions()[0].rowPosition, Integer.MAX_VALUE, 1);
            this.selectionLayer.addSelection(row);
            CapraOfficeObject selectedObject = this.dataProvider.getRowHighlight(this.selectionLayer.getFullySelectedRowPositions()[0]);
            if (selectedObject != null) {
                this.selectedObject = selectedObject;
                return new StructuredSelection((Object)selectedObject);
            }
        }
        return null;
    }

    public CapraOfficeObject returnSelectedItem() {
        this.getSelection();
        return this.selectedObject;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void updateProvider(SelectionLayer selectionLayer, OfficeTableDataProvider dataProvider) {
        this.selectionLayer = selectionLayer;
        this.dataProvider = dataProvider;
        this.selectionLayer.addLayerListener((ILayerListener)this);
    }
}

