/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.cloudfoundry.client.lib.domain.CloudRoute;
import org.eclipse.cft.server.core.AbstractCloudFoundryUrl;
import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CloudApplicationURL;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudUtil;
import org.eclipse.cft.server.core.internal.client.CloudFoundryClientFactory;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.DeploymentInfoWorkingCopy;
import org.eclipse.cft.server.core.internal.spaces.CloudOrgsAndSpaces;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.CloudServerUIUtil;
import org.eclipse.cft.server.ui.internal.HostnameValidator;
import org.eclipse.cft.server.ui.internal.ICoreRunnable;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.HostnameValidationResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class CFUiUtil {
    public static final String SERVERS_VIEW_ID = "org.eclipse.wst.server.ui.ServersView";
    public static String ATTR_USER_DEFINED_URLS = "org.eclipse.cft.server.user.defined.urls";

    public static IStatus runForked(final ICoreRunnable coreRunner, IWizard wizard) {
        try {
            IRunnableWithProgress runner = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            coreRunner.run(monitor);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            wizard.getContainer().run(true, false, runner);
        }
        catch (InvocationTargetException e) {
            Status status = e.getCause() instanceof CoreException ? new Status(4, "org.eclipse.cft.server.ui", NLS.bind((String)Messages.CloudUiUtil_ERROR_FORK_OP_FAILED, (Object)e.getCause().getMessage()), (Throwable)e) : new Status(4, "org.eclipse.cft.server.ui", NLS.bind((String)Messages.CloudUiUtil_ERROR_FORK_UNEXPECTED, (Object)e.getMessage()), (Throwable)e);
            CloudFoundryServerUiPlugin.getDefault().getLog().log((IStatus)status);
            IWizardPage page = wizard.getContainer().getCurrentPage();
            if (page instanceof DialogPage) {
                ((DialogPage)page).setErrorMessage(status.getMessage());
            }
            return status;
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private static CloudFoundryBrandingExtensionPoint.CloudServerURL convertAbstractCloudFoundryUrlToCloudServerURL(AbstractCloudFoundryUrl abstractUrl) {
        CloudFoundryBrandingExtensionPoint.CloudServerURL cloudUrl = null;
        if (abstractUrl != null) {
            cloudUrl = abstractUrl instanceof CloudFoundryBrandingExtensionPoint.CloudServerURL ? (CloudFoundryBrandingExtensionPoint.CloudServerURL)abstractUrl : new CloudFoundryBrandingExtensionPoint.CloudServerURL(abstractUrl.getName(), abstractUrl.getUrl(), abstractUrl.getUserDefined(), abstractUrl.getSignUpUrl(), abstractUrl.getSelfSigned());
        }
        return cloudUrl;
    }

    private static List<CloudFoundryBrandingExtensionPoint.CloudServerURL> convertAbstractCloudFoundryUrlListToCloudServerURLList(List<AbstractCloudFoundryUrl> abstractUrls) {
        if (abstractUrls == null) {
            return null;
        }
        ArrayList<CloudFoundryBrandingExtensionPoint.CloudServerURL> urls = new ArrayList<CloudFoundryBrandingExtensionPoint.CloudServerURL>();
        for (AbstractCloudFoundryUrl abstractUrl : abstractUrls) {
            if (abstractUrl == null) continue;
            urls.add(CFUiUtil.convertAbstractCloudFoundryUrlToCloudServerURL(abstractUrl));
        }
        return urls;
    }

    public static List<CloudFoundryBrandingExtensionPoint.CloudServerURL> getAllUrls(String serverTypeId) {
        try {
            return CFUiUtil.convertAbstractCloudFoundryUrlListToCloudServerURLList(CloudServerUIUtil.getAllUrls(serverTypeId, null, false));
        }
        catch (CoreException ex) {
            CloudFoundryServerUiPlugin.logError(ex);
            return new ArrayList<CloudFoundryBrandingExtensionPoint.CloudServerURL>();
        }
    }

    public static CloudFoundryBrandingExtensionPoint.CloudServerURL getDefaultUrl(String serverTypeId) {
        CloudFoundryBrandingExtensionPoint.CloudServerURL url = null;
        try {
            AbstractCloudFoundryUrl abstractUrl = CloudServerUIUtil.getDefaultUrl(serverTypeId, null, true);
            if (abstractUrl != null) {
                url = CFUiUtil.convertAbstractCloudFoundryUrlToCloudServerURL(abstractUrl);
            }
        }
        catch (CoreException ex) {
            CloudFoundryServerUiPlugin.logError(ex);
        }
        return url;
    }

    public static List<CloudFoundryBrandingExtensionPoint.CloudServerURL> getUrls(String serverTypeId) {
        try {
            return CFUiUtil.convertAbstractCloudFoundryUrlListToCloudServerURLList(CloudServerUIUtil.getUrls(serverTypeId, null, true));
        }
        catch (CoreException ex) {
            CloudFoundryServerUiPlugin.logError(ex);
            return new ArrayList<CloudFoundryBrandingExtensionPoint.CloudServerURL>();
        }
    }

    public static List<CloudFoundryBrandingExtensionPoint.CloudServerURL> getUserDefinedUrls(String serverTypeId) {
        return CFUiUtil.convertAbstractCloudFoundryUrlListToCloudServerURLList(CloudServerUIUtil.getUserDefinedUrls(serverTypeId));
    }

    public static void storeUserDefinedUrls(String serverTypeId, List<CloudFoundryBrandingExtensionPoint.CloudServerURL> urls) {
        if (urls == null) {
            return;
        }
        ArrayList<AbstractCloudFoundryUrl> abstractUrls = new ArrayList<AbstractCloudFoundryUrl>();
        for (CloudFoundryBrandingExtensionPoint.CloudServerURL cloudUrl : urls) {
            abstractUrls.add((AbstractCloudFoundryUrl)cloudUrl);
        }
        CloudServerUIUtil.storeUserDefinedUrls(serverTypeId, abstractUrls);
    }

    public static void validateCredentials(final CloudFoundryServer cfServer, final String userName, final String password, final String urlText, final boolean displayURL, final boolean selfSigned, IRunnableContext context) throws CoreException, OperationCanceledException {
        try {
            ICoreRunnable coreRunner = new ICoreRunnable(){

                @Override
                public void run(IProgressMonitor monitor) throws CoreException {
                    String url = urlText;
                    if (displayURL) {
                        url = CFUiUtil.getUrlFromDisplayText(urlText);
                    }
                    CloudFoundryServerBehaviour.validate((CloudFoundryServer)cfServer, (String)url, (String)userName, (String)password, (boolean)selfSigned, (boolean)false, null, null, (IProgressMonitor)monitor);
                }
            };
            if (context != null) {
                CFUiUtil.runForked(coreRunner, context);
            } else {
                CFUiUtil.runForked(coreRunner);
            }
        }
        catch (CoreException ce) {
            throw CloudErrorUtil.checkSSLPeerUnverifiedException((CoreException)ce);
        }
    }

    public static void validateSsoCredentials(final CloudFoundryServer cfServer, final String urlText, final boolean displayURL, final boolean selfSigned, IRunnableContext context, final String passcode, final String tokenValue) throws CoreException, OperationCanceledException {
        try {
            ICoreRunnable coreRunner = new ICoreRunnable(){

                @Override
                public void run(IProgressMonitor monitor) throws CoreException {
                    String url = urlText;
                    if (displayURL) {
                        url = CFUiUtil.getUrlFromDisplayText(urlText);
                    }
                    CloudFoundryServerBehaviour.validate((CloudFoundryServer)cfServer, (String)url, null, null, (boolean)selfSigned, (boolean)true, (String)passcode, (String)tokenValue, (IProgressMonitor)monitor);
                }
            };
            if (context != null) {
                CFUiUtil.runForked(coreRunner, context);
            } else {
                CFUiUtil.runForked(coreRunner);
            }
        }
        catch (CoreException ce) {
            throw CloudErrorUtil.checkSSLPeerUnverifiedException((CoreException)ce);
        }
    }

    public static CloudOrgsAndSpaces getCloudSpaces(final CloudFoundryServer cfServer, final String userName, final String password, final String urlText, final boolean displayURL, final boolean selfSigned, IRunnableContext context, final boolean sso, final String passcode, final String tokenValue) throws CoreException {
        try {
            final CloudOrgsAndSpaces[] supportsSpaces = new CloudOrgsAndSpaces[1];
            ICoreRunnable coreRunner = new ICoreRunnable(){

                @Override
                public void run(IProgressMonitor monitor) throws CoreException {
                    String url = urlText;
                    if (displayURL) {
                        url = CFUiUtil.getUrlFromDisplayText(urlText);
                    }
                    if (sso) {
                        CloudCredentials credentials = CloudUtil.createSsoCredentials((String)passcode, (String)tokenValue);
                        if (credentials == null) {
                            credentials = new CloudCredentials(passcode);
                        }
                        supportsSpaces[0] = CloudFoundryServerBehaviour.getCloudSpacesExternalClient((CloudFoundryServer)cfServer, (CloudCredentials)credentials, (String)url, (boolean)selfSigned, (boolean)sso, (String)passcode, (String)tokenValue, (IProgressMonitor)monitor);
                    } else {
                        supportsSpaces[0] = CloudFoundryServerBehaviour.getCloudSpacesExternalClient((CloudFoundryServer)cfServer, (CloudCredentials)new CloudCredentials(userName, password), (String)url, (boolean)selfSigned, (IProgressMonitor)monitor);
                    }
                }
            };
            if (context != null) {
                CFUiUtil.runForked(coreRunner, context);
            } else {
                CFUiUtil.runForked(coreRunner);
            }
            return supportsSpaces[0];
        }
        catch (OperationCanceledException e) {
            throw new CoreException(CloudFoundryPlugin.getErrorStatus((Throwable)e));
        }
    }

    public static String getUrlFromDisplayText(String displayText) {
        int pos;
        String url = displayText;
        if (url != null && (pos = url.lastIndexOf(" - ")) >= 0) {
            return url.substring(pos + 3);
        }
        return url;
    }

    public static String getDisplayTextFromUrl(String url, String serverTypeId) {
        try {
            List<AbstractCloudFoundryUrl> cloudUrls = CloudServerUIUtil.getAllUrls(serverTypeId, null, true);
            for (AbstractCloudFoundryUrl cloudUrl : cloudUrls) {
                if (!cloudUrl.getUrl().equals(url)) continue;
                return String.valueOf(cloudUrl.getName()) + " - " + url;
            }
        }
        catch (CoreException ex) {
            CloudFoundryServerUiPlugin.logError(ex);
        }
        return url;
    }

    public static void runForked(ICoreRunnable coreRunner) throws OperationCanceledException, CoreException {
        CFUiUtil.runForked(coreRunner, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public static void runForked(final ICoreRunnable coreRunner, IRunnableContext progressService) throws OperationCanceledException, CoreException {
        try {
            IRunnableWithProgress runner = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", -1);
                    try {
                        try {
                            coreRunner.run(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            progressService.run(true, true, runner);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            CloudFoundryServerUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cft.server.ui", "Unexpected exception", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    public static void openUrl(String location) {
        CFUiUtil.openUrl(location, WebBrowserPreference.getBrowserChoice());
    }

    public static void openUrl(String location, int browserChoice) {
        try {
            URL url = null;
            if (location != null) {
                url = new URL(location);
            }
            if (browserChoice == 1) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    support.getExternalBrowser().openURL(url);
                }
                catch (Exception exception) {}
            } else {
                int flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? 38 : 134;
                String generatedId = "org.eclipse.mylyn.web.browser-" + Calendar.getInstance().getTimeInMillis();
                IWebBrowser browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.CloudUiUtil_ERROR_OPEN_BROWSER_FAIL_TITLE, (String)Messages.CloudUiUtil_ERROR_OPEN_BROWSER_BODY);
        }
        catch (MalformedURLException malformedURLException) {
            if (location == null || location.trim().equals("")) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.CloudUiUtil_ERROR_OPEN_BROWSER_FAIL_TITLE, (String)NLS.bind((String)Messages.CloudUiUtil_ERROR_EMPTY_URL_BODY, (Object)location));
            }
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.CloudUiUtil_ERROR_OPEN_BROWSER_FAIL_TITLE, (String)NLS.bind((String)Messages.CloudUiUtil_ERROR_MALFORM_URL_BODY, (Object)location));
        }
    }

    public static CloudFoundryBrandingExtensionPoint.CloudServerURL getWildcardUrl(CloudFoundryBrandingExtensionPoint.CloudServerURL cloudUrl, List<CloudFoundryBrandingExtensionPoint.CloudServerURL> allCloudUrls, Shell shell) {
        AbstractCloudFoundryUrl returnUrl;
        ArrayList<AbstractCloudFoundryUrl> allCloudFoundryUrls = new ArrayList<AbstractCloudFoundryUrl>();
        if (allCloudUrls != null) {
            for (CloudFoundryBrandingExtensionPoint.CloudServerURL _cloudUrl : allCloudUrls) {
                allCloudFoundryUrls.add((AbstractCloudFoundryUrl)_cloudUrl);
            }
        }
        if ((returnUrl = CloudServerUIUtil.getWildcardUrl((AbstractCloudFoundryUrl)cloudUrl, allCloudFoundryUrls, shell)) != null) {
            return new CloudFoundryBrandingExtensionPoint.CloudServerURL(returnUrl.getName(), returnUrl.getUrl(), true, returnUrl.getSelfSigned());
        }
        return null;
    }

    public static IStructuredSelection getServersViewSelection() {
        IViewReference[] references;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow;
        String serversViewID;
        IViewRegistry registry = PlatformUI.getWorkbench().getViewRegistry();
        IViewDescriptor serversViewDescriptor = registry.find(serversViewID = SERVERS_VIEW_ID);
        if (serversViewDescriptor != null && (activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (references = activePage.getViewReferences()) != null) {
            ISelection selection;
            ISelectionProvider selectionProvider;
            IViewSite viewSite;
            IViewPart serversViewPart = null;
            IViewReference[] iViewReferenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference reference = iViewReferenceArray[n2];
                if (serversViewID.equals(reference.getId())) {
                    serversViewPart = reference.getView(true);
                    break;
                }
                ++n2;
            }
            if (serversViewPart != null && (viewSite = serversViewPart.getViewSite()) != null && (selectionProvider = viewSite.getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof IStructuredSelection) {
                return (IStructuredSelection)selection;
            }
        }
        return null;
    }

    public static Shell getShell() {
        return PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
    }

    public static UniqueSubdomain getUniqueSubdomain(String url, CloudFoundryServer server, IProgressMonitor monitor) throws CoreException {
        if (url == null) {
            return null;
        }
        ApplicationUrlLookupService lookup = ApplicationUrlLookupService.getCurrentLookup((CloudFoundryServer)server);
        CloudApplicationURL cloudUrl = null;
        boolean isUniqueURL = true;
        int intSuffix = -1;
        UniqueSubdomain result = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        List routes = null;
        String userName = server.getUsername();
        String orgName = server.getCloudFoundrySpace().getOrgName();
        String spaceName = server.getCloudFoundrySpace().getSpaceName();
        int suffixHash = userName != null ? (String.valueOf(userName) + orgName + spaceName).hashCode() : (String.valueOf(orgName) + spaceName).hashCode();
        String hashString = String.valueOf(suffixHash).substring(0, 6);
        do {
            int length;
            int beginning;
            try {
                cloudUrl = lookup.getCloudApplicationURL(url);
            }
            catch (CoreException coreException) {
                break;
            }
            if (cloudUrl == null) break;
            if (routes == null) {
                routes = server.getBehaviour().getRoutes(cloudUrl.getDomain(), monitor);
            }
            boolean isFound = false;
            boolean isRouteReservedAndUnused = false;
            boolean isRouteCreated = false;
            for (CloudRoute cr : routes) {
                if (!cr.getHost().equalsIgnoreCase(cloudUrl.getSubdomain())) continue;
                isFound = true;
                isRouteCreated = false;
                if (!cr.inUse()) {
                    isRouteReservedAndUnused = true;
                    break;
                }
                isRouteReservedAndUnused = false;
                break;
            }
            if (!isFound) {
                isRouteCreated = isRouteReservedAndUnused = server.getBehaviour().reserveRouteIfAvailable(cloudUrl.getSubdomain(), cloudUrl.getDomain(), monitor);
            }
            if (isRouteReservedAndUnused) {
                result = new UniqueSubdomain();
                result.setRouteCreated(isRouteCreated);
                result.setCloudUrl(cloudUrl);
                isUniqueURL = true;
                continue;
            }
            isUniqueURL = false;
            StringBuilder sb = new StringBuilder(url);
            String subdomain = cloudUrl.getSubdomain();
            if (++intSuffix == 0) {
                sb = new StringBuilder(url);
                subdomain = cloudUrl.getSubdomain();
                url = sb.insert(sb.indexOf(subdomain) + subdomain.length(), "-" + hashString).toString();
                continue;
            }
            if (intSuffix == 1) {
                beginning = subdomain.indexOf(hashString) - 1;
                length = hashString.length() + 1;
                url = sb.replace(beginning, beginning + length, "-" + hashString + "-1").toString();
                continue;
            }
            beginning = subdomain.indexOf(hashString) - 1;
            length = hashString.length() + 2 + String.valueOf(intSuffix - 1).length();
            url = sb.replace(beginning, beginning + length, "-" + hashString + "-" + intSuffix).toString();
        } while (!isUniqueURL && intSuffix < 0x7FFFFFFE && !monitor.isCanceled());
        return result;
    }

    public static HostnameValidationResult validateHostname(CloudApplicationURL appUrl, CloudFoundryServer server, IWizardContainer container) {
        return CFUiUtil.validateHostname(appUrl, server, container, null);
    }

    public static HostnameValidationResult validateHostname(CloudApplicationURL appUrl, CloudFoundryServer server, IWizardContainer container, String message) {
        HostnameValidator val = message == null ? new HostnameValidator(appUrl, server) : new HostnameValidator(appUrl, server, message);
        try {
            container.run(true, true, (IRunnableWithProgress)val);
        }
        catch (Exception e) {
            CloudFoundryPlugin.logWarning((String)("Hostname taken validation was not completed. " + e.getMessage()));
            Status status = new Status(4, "org.eclipse.cft.server.ui", Messages.CloudApplicationUrlPart_ERROR_UNABLE_TO_CHECK_HOSTNAME);
            return new HostnameValidationResult((IStatus)status, val.isRouteCreated());
        }
        return new HostnameValidationResult(val.getStatus(), val.isRouteCreated());
    }

    public static void cleanupReservedRoutes(IWizard wizard, CloudFoundryServer server, List<CloudApplicationURL> reservedUrls, String urlToKeep) {
        for (CloudApplicationURL cloudURL : reservedUrls) {
            if (urlToKeep != null && urlToKeep.equals(cloudURL.getUrl())) continue;
            CFUiUtil.deleteRoute(wizard, server, cloudURL);
        }
        reservedUrls.clear();
    }

    public static void cleanupReservedRoutesIfNotNeeded(DeploymentInfoWorkingCopy workingCopy, IWizard wizard, CloudFoundryServer server, List<CloudApplicationURL> reservedUrls) {
        ArrayList urls = workingCopy.getUris();
        if (urls == null) {
            urls = new ArrayList();
        }
        for (CloudApplicationURL cloudURL : reservedUrls) {
            boolean isNeeded = false;
            for (String url : urls) {
                if (!url.equals(cloudURL.getUrl())) continue;
                isNeeded = true;
                break;
            }
            if (isNeeded) continue;
            CFUiUtil.deleteRoute(wizard, server, cloudURL);
        }
        reservedUrls.clear();
    }

    private static void deleteRoute(IWizard wizard, final CloudFoundryServer server, final CloudApplicationURL fCloudURL) {
        try {
            wizard.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            server.getBehaviour().deleteRoute(fCloudURL.getSubdomain(), fCloudURL.getDomain(), monitor);
                        }
                        catch (CoreException e) {
                            CloudFoundryPlugin.logError((Throwable)e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            CloudFoundryPlugin.logWarning((String)("The following route was not deleted: " + fCloudURL.getUrl()));
        }
        catch (InvocationTargetException invocationTargetException) {
            CloudFoundryPlugin.logWarning((String)("The following route was not deleted: " + fCloudURL.getUrl()));
        }
    }

    public static String getPromptText(CloudFoundryServer cfServer) {
        String ssoUrl = "";
        String href = null;
        if (cfServer.getUrl() != null && !cfServer.getUrl().isEmpty()) {
            try {
                href = CloudFoundryClientFactory.getSsoUrl((String)cfServer.getUrl(), (boolean)cfServer.isSelfSigned());
                ssoUrl = href != null && !href.isEmpty() ? Messages.bind((String)Messages.PASSCODE_PROMPT2, (Object)href) : Messages.PASSCODE_IS_NOT_SUPPORTED;
            }
            catch (Exception e1) {
                CloudFoundryServerUiPlugin.logError(e1);
            }
        }
        return ssoUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnUIThreadUntilTimeout(final String taskName, final Runnable r) {
        final AtomicBoolean threadStarted = new AtomicBoolean(false);
        final Thread runnableThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AtomicBoolean atomicBoolean = threadStarted;
                synchronized (atomicBoolean) {
                    threadStarted.set(true);
                }
                r.run();
            }
        });
        runnableThread.setDaemon(true);
        runnableThread.setName(r.getClass().getName());
        runnableThread.start();
        try {
            runnableThread.join(1000L);
            boolean switchToDialog = false;
            AtomicBoolean atomicBoolean = threadStarted;
            synchronized (atomicBoolean) {
                if (!threadStarted.get() || runnableThread.isAlive()) {
                    switchToDialog = true;
                }
            }
            if (switchToDialog) {
                ProgressMonitorDialog monitorDlg = new ProgressMonitorDialog(CFUiUtil.getShell());
                monitorDlg.run(true, true, new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.setTaskName(taskName);
                        boolean continueRunning = true;
                        while (continueRunning && !monitor.isCanceled()) {
                            AtomicBoolean atomicBoolean = threadStarted;
                            synchronized (atomicBoolean) {
                                if (threadStarted.get() && !runnableThread.isAlive()) {
                                    continueRunning = false;
                                }
                            }
                            if (!continueRunning) continue;
                            Thread.sleep(100L);
                        }
                    }
                });
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static class UniqueSubdomain {
        private CloudApplicationURL cloudUrl = null;
        private boolean routeCreated = false;

        public CloudApplicationURL getCloudUrl() {
            return this.cloudUrl;
        }

        public boolean isRouteCreated() {
            return this.routeCreated;
        }

        public void setCloudUrl(CloudApplicationURL cloudUrl) {
            this.cloudUrl = cloudUrl;
        }

        public void setRouteCreated(boolean routeCreated) {
            this.routeCreated = routeCreated;
        }
    }
}

