/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.List;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.spaces.CloudFoundrySpace;
import org.eclipse.cft.server.ui.internal.CloudFoundryCredentialsPart;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.CloudServerSpacesDelegate;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.ValidationEventHandler;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundrySpacesWizardFragment;
import org.eclipse.cft.server.ui.internal.wizards.CredentialsWizardValidator;
import org.eclipse.cft.server.ui.internal.wizards.WizardFragmentStatusHandler;
import org.eclipse.cft.server.ui.internal.wizards.WizardHandleContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.util.ServerLifecycleAdapter;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class CloudFoundryServerWizardFragment
extends WizardFragment {
    private CloudFoundryServer cloudServer;
    private CloudFoundryCredentialsPart credentialsPart;
    private CloudFoundrySpacesWizardFragment spacesFragment;
    private ValidationEventHandler validationHandler;
    private WizardFragmentStatusHandler statusHandler;
    private IRunnableContext context;

    public Composite createComposite(Composite parent, IWizardHandle wizardHandle) {
        this.initServer();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.context = wizardHandle != null ? new WizardHandleContext(wizardHandle).getRunnableContext() : null;
        this.validationHandler = new ValidationEventHandler();
        this.statusHandler = new WizardFragmentStatusHandler(wizardHandle);
        this.credentialsPart = new CloudFoundryCredentialsPart(this.cloudServer, new WizardHandleContext(wizardHandle));
        this.credentialsPart.addPartChangeListener(this.validationHandler);
        this.validationHandler.addValidationListener(this.credentialsPart);
        this.validationHandler.addStatusHandler(this.statusHandler);
        this.credentialsPart.createPart(composite);
        return composite;
    }

    public void enter() {
        this.initServer();
        CredentialsWizardValidator validator = new CredentialsWizardValidator(this.cloudServer, new CloudServerSpacesDelegate(this.cloudServer));
        if (this.validationHandler != null) {
            this.validationHandler.updateValidator(validator);
        }
        this.spacesFragment = new CloudFoundrySpacesWizardFragment(this.cloudServer, validator.getSpaceDelegate(), this.validationHandler);
        this.credentialsPart.setServer(this.cloudServer);
    }

    public void exit() {
        if (this.validationHandler != null) {
            this.validationHandler.validate(this.context);
        }
    }

    public boolean hasComposite() {
        return true;
    }

    public boolean isComplete() {
        return this.validationHandler.isOK();
    }

    protected void createChildFragments(List<WizardFragment> list) {
        if (this.spacesFragment != null) {
            list.add(this.spacesFragment);
        }
        super.createChildFragments(list);
    }

    protected void dispose() {
        this.spacesFragment = null;
    }

    public void performCancel(IProgressMonitor monitor) throws CoreException {
        super.performCancel(monitor);
        this.dispose();
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        if (!this.validationHandler.isOK()) {
            IStatus status = this.validationHandler.getNextNonOKEvent();
            if (status == null) {
                status = CloudFoundryPlugin.getErrorStatus((String)Messages.ERROR_UNKNOWN_SERVER_CREATION_ERROR);
            }
            throw new CoreException(status);
        }
        ServerLifecycleAdapter listener = new ServerLifecycleAdapter(){

            public void serverAdded(IServer server) {
                ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this);
                ConnectJob job = new ConnectJob(CloudFoundryServerWizardFragment.this.cloudServer, server);
                job.schedule(500L);
            }
        };
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)listener);
        this.dispose();
    }

    private void initServer() {
        ServerWorkingCopy server = (ServerWorkingCopy)this.getTaskModel().getObject("server");
        this.cloudServer = (CloudFoundryServer)server.loadAdapter(CloudFoundryServer.class, null);
        if (this.cloudServer == null) {
            CloudFoundryPlugin.logError((String)("Cloud Foundry Server Framework Error: Failed to create a Cloud Foundry server working copy for: " + server.getId() + ". Please check if the plugin has been installed correctly."));
        }
    }

    private static class ConnectJob
    extends Job {
        private final CloudFoundryServer originalServer;
        private final IServer server;

        public ConnectJob(CloudFoundryServer originalServer, IServer server) {
            super(Messages.CloudFoundryServerWizardFragment_TEXT_CONNECT_ACCOUNT);
            this.originalServer = originalServer;
            this.server = server;
        }

        protected IStatus run(IProgressMonitor monitor) {
            CloudFoundryServer cf = (CloudFoundryServer)this.server.loadAdapter(CloudFoundryServer.class, monitor);
            if (cf.getPassword() == null) {
                return Status.CANCEL_STATUS;
            }
            if (cf != null && cf.getUsername().equals(this.originalServer.getUsername()) && cf.getPassword().equals(this.originalServer.getPassword()) && cf.getUrl().equals(this.originalServer.getUrl())) {
                CloudFoundryServerBehaviour behaviour;
                boolean connect = false;
                if (cf.hasCloudSpace() && this.originalServer.hasCloudSpace()) {
                    CloudFoundrySpace originalSpace = this.originalServer.getCloudFoundrySpace();
                    CloudFoundrySpace space = cf.getCloudFoundrySpace();
                    boolean bl = connect = space.getOrgName().equals(originalSpace.getOrgName()) && space.getSpaceName().equals(originalSpace.getSpaceName());
                }
                if (connect && (behaviour = cf.getBehaviour()) != null) {
                    try {
                        behaviour.connect(monitor);
                    }
                    catch (CoreException e) {
                        CloudFoundryServerUiPlugin.getDefault().getLog().log(e.getStatus());
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }
}

