/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core;

import java.util.List;

public abstract class AbstractCloudFoundryUrl {
    protected String name;
    protected String url;
    protected String signUpUrl;

    public AbstractCloudFoundryUrl(String name, String url, List<Wildcard> wildcards, String signUpUrl) {
        this.name = name;
        this.url = url;
        this.signUpUrl = signUpUrl;
        if (wildcards != null) {
            for (Wildcard wildcard : wildcards) {
                String wildcardName = wildcard.getName();
                if (wildcardName == null || wildcardName.isEmpty()) continue;
                this.url = this.url.replaceAll(wildcardName, "{" + wildcardName + "}");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSignUpUrl() {
        return this.signUpUrl;
    }

    public boolean getUserDefined() {
        return false;
    }

    public boolean getSelfSigned() {
        return false;
    }

    public static class Wildcard {
        private String name;

        public Wildcard(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

