/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ui.util.FileOpener;
import org.eclipse.xtext.ui.wizard.template.AbstractFileTemplate;
import org.eclipse.xtext.ui.wizard.template.IFileTemplateProvider;
import org.eclipse.xtext.ui.wizard.template.Messages;
import org.eclipse.xtext.ui.wizard.template.NewFileWizardPrimaryPage;
import org.eclipse.xtext.ui.wizard.template.TemplateFileInfo;
import org.eclipse.xtext.ui.wizard.template.TemplateLabelProvider;
import org.eclipse.xtext.ui.wizard.template.TemplateParameterPage;
import org.eclipse.xtext.ui.wizard.template.TemplateVariable;
import org.eclipse.xtext.ui.wizard.template.WorkspaceFileGenerator;

@Beta
public class TemplateNewFileWizard
extends Wizard
implements INewWizard {
    private static final String FILE_TEMPLATE_PROVIDER_EXTENSION_POINT_ID = "org.eclipse.xtext.ui.fileTemplate";
    private static final String FILE_TEMPLATE_PROVIDER_ID = "fileTemplateProvider";
    private static final String FILE_TEMPLATE_PROVIDER_GRAMMAR_NAME_ATTRIBUTE = "grammarName";
    private static final String FILE_TEMPLATE_PROVIDER_GRAMMAR_CLASS_ATTRIBUTE = "class";
    private static final Logger logger = Logger.getLogger(TemplateNewFileWizard.class);
    protected IStructuredSelection selection;
    protected NewFileWizardPrimaryPage mainPage;
    protected TemplateParameterPage templateParameterPage;
    @Inject
    private TemplateLabelProvider labelProvider;
    @Inject
    private FileOpener fileOpener;
    @Inject
    private IGrammarAccess grammarAccess;
    private IWorkbench workbench;
    private AbstractFileTemplate[] templates;

    public TemplateNewFileWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.TemplateNewFileWizard_title);
    }

    public void addPages() {
        this.templates = this.loadTemplatesFromExtensionPoint();
        this.mainPage = this.createMainPage("basicNewFilePage");
        this.addPage((IWizardPage)this.mainPage);
        this.setForcePreviousAndNextButtons(this.hasMoreThenOneTemplate());
    }

    public AbstractFileTemplate[] getTemplates() {
        return this.templates;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public TemplateLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected NewFileWizardPrimaryPage createMainPage(String pageName) {
        return new NewFileWizardPrimaryPage(pageName, this.templates, this.selection, this.labelProvider);
    }

    protected String getGrammarName() {
        return this.grammarAccess.getGrammar().getName();
    }

    protected TemplateFileInfo getFileInfo() {
        return this.mainPage.getFileInfo();
    }

    public boolean performFinish() {
        final TemplateFileInfo info = this.getFileInfo();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        TemplateNewFileWizard.this.doFinish(info, monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    protected void doFinish(TemplateFileInfo info, IProgressMonitor monitor) {
        try {
            AbstractFileTemplate fileTemplate = info.getFileTemplate();
            WorkspaceFileGenerator fileGenerator = this.createWorkspaceFileGenerator();
            fileTemplate.setTemplateInfo(info);
            fileTemplate.generateFiles(fileGenerator);
            fileGenerator.run(monitor);
            this.fileOpener.selectAndReveal(fileGenerator.getResult());
            this.fileOpener.openFileToEdit(this.getShell(), fileGenerator.getResult());
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    protected WorkspaceFileGenerator createWorkspaceFileGenerator() {
        return new WorkspaceFileGenerator();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof NewFileWizardPrimaryPage && this.hasMoreThenOneTemplate()) {
            AbstractFileTemplate selectedTemplate = this.mainPage.getSelectedTemplate();
            List<TemplateVariable> variables = selectedTemplate.getVariables();
            if (variables.isEmpty()) {
                return null;
            }
            selectedTemplate.setTemplateInfo(this.getFileInfo());
            TemplateParameterPage parameterPage = new TemplateParameterPage(selectedTemplate);
            parameterPage.setWizard((IWizard)this);
            this.templateParameterPage = parameterPage;
            parameterPage.setTitle(page.getTitle());
            parameterPage.setDescription(page.getDescription());
            return parameterPage;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page instanceof TemplateParameterPage) {
            this.templateParameterPage = null;
            return this.mainPage;
        }
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        return super.canFinish() && (this.templateParameterPage == null || this.templateParameterPage.isPageComplete());
    }

    private boolean hasMoreThenOneTemplate() {
        return this.templates.length > 1;
    }

    private AbstractFileTemplate[] loadTemplatesFromExtensionPoint() {
        ArrayList<AbstractFileTemplate> result = new ArrayList<AbstractFileTemplate>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(FILE_TEMPLATE_PROVIDER_EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (FILE_TEMPLATE_PROVIDER_ID.equals(element.getName()) && this.getGrammarName().equals(element.getAttribute(FILE_TEMPLATE_PROVIDER_GRAMMAR_NAME_ATTRIBUTE))) {
                try {
                    IFileTemplateProvider provider = (IFileTemplateProvider)element.createExecutableExtension(FILE_TEMPLATE_PROVIDER_GRAMMAR_CLASS_ATTRIBUTE);
                    result.addAll(Arrays.asList(provider.getFileTemplates()));
                }
                catch (CoreException e) {
                    logger.error((Object)("Can not instantiate '" + element.getAttribute(FILE_TEMPLATE_PROVIDER_GRAMMAR_CLASS_ATTRIBUTE) + "'"), (Throwable)e);
                }
            }
            ++n2;
        }
        return result.toArray(new AbstractFileTemplate[0]);
    }
}

