/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.petrinet.EnvConfig;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.generatortasks.GeneratorTask;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.project.AdapterInterfacePairs;
import org.eclipse.comma.project.project.ComponentReference;
import org.eclipse.comma.project.project.ExecutableSource;
import org.eclipse.comma.project.project.TestApplicationGenerationTask;
import org.eclipse.comma.python.PythonInterpreter;
import org.eclipse.comma.testapplication.TestApplicationGenerator;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TestApplicationGeneratorTask
extends GeneratorTask {
    protected final TestApplicationGenerationTask task;
    protected final IScopeProvider scopeProvider;
    protected final IFileSystemAccess2 fsa;
    protected CommaFileSystemAccess libFileSystemAccess;

    public TestApplicationGeneratorTask(TestApplicationGenerationTask task, IScopeProvider scopeProvider, OutputLocator outputLocator, IFileSystemAccess2 fsa) {
        super(task, scopeProvider, outputLocator, fsa);
        this.task = task;
        this.scopeProvider = scopeProvider;
        this.fsa = fsa;
    }

    @Override
    protected void doGenerate() {
        try {
            boolean _tripleNotEquals;
            List<Parameters> parameters = new ArrayList();
            EList<String> _params = this.task.getParams();
            boolean bl = _tripleNotEquals = _params != null;
            if (_tripleNotEquals) {
                Functions.Function1 _function = p -> {
                    EObject _head = (EObject)IterableExtensions.head((Iterable)EcoreUtil2.getResource((Resource)this.task.eResource(), (String)p).getContents());
                    return (Parameters)_head;
                };
                parameters = ListExtensions.map(this.task.getParams(), (Functions.Function1)_function);
                Functions.Function1 _function_1 = p -> EcoreUtil2.getResource((Resource)this.task.eResource(), (String)p);
                this.expandParams(ListExtensions.map(this.task.getParams(), (Functions.Function1)_function_1));
            }
            String testApplication = null;
            ExecutableSource target = this.task.getTarget();
            if (target instanceof ComponentReference) {
                List<EnvConfig> environment = ProjectUtility.getComponentEnvironmentConfig(this.task, ((ComponentReference)target).getComponent(), this.task.getEnvComponents(), parameters, this.scopeProvider);
                String adapterPaths = this.getAdapterPaths(this.task, (EObject)((ComponentReference)target).getComponent());
                String interfaces = this.getInterfaces(this.task, (EObject)((ComponentReference)target).getComponent());
                testApplication = TestApplicationGenerator.generateForComponent((Component)((ComponentReference)target).getComponent(), environment, (String)adapterPaths, (String)interfaces, (double)this.task.getNoEventsTimeout(), (double)this.task.getDefaultTimeout(), (boolean)this.task.isCommandLine(), (IScopeProvider)this.scopeProvider);
            } else {
                Parameters _xifexpression = null;
                boolean _isEmpty = parameters.isEmpty();
                boolean _not = !_isEmpty;
                _xifexpression = _not ? parameters.get(0) : null;
                Parameters parameter = _xifexpression;
                String adapterPaths_1 = this.getAdapterPaths(this.task, (EObject)this.getInterface(target));
                String interfaces_1 = this.getInterfaces(this.task, (EObject)this.getInterface(target));
                testApplication = TestApplicationGenerator.generateForInterface((Interface)this.getInterface(target), (Parameters)parameter, (String)adapterPaths_1, (String)interfaces_1, (double)this.task.getNoEventsTimeout(), (double)this.task.getDefaultTimeout(), (boolean)this.task.isCommandLine(), (IScopeProvider)this.scopeProvider);
            }
            String _name = this.task.getName();
            String _plus = "testapplication/" + _name;
            String path = String.valueOf(_plus) + "/";
            String filePath = String.valueOf(path) + "testapplication.py";
            this.fsa.generateFile(filePath, (CharSequence)testApplication);
            File file = ProjectUtility.uriToFile(this.fsa.getURI(filePath));
            PythonInterpreter.createStartScript((File)file, (String)"start");
            GeneratorTask.refreshWorkspaceProjects();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String _getAdapterPaths(TestApplicationGenerationTask task, Component comp) {
        boolean _not;
        String adapterPaths = "";
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)task.getAdapterPath());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _plus_1;
            String _expandURIs = this.expandURIs(task.getAdapterPath());
            String _plus = "{'default' : '" + _expandURIs;
            adapterPaths = _plus_1 = String.valueOf(_plus) + "'}";
        } else {
            adapterPaths = this.getAdapterPathsForPairs(task);
        }
        return adapterPaths;
    }

    protected String _getAdapterPaths(TestApplicationGenerationTask task, Interface intf) {
        boolean _not;
        String adapterPaths = "";
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)task.getAdapterPath());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _plus_1;
            String _expandURIs = this.expandURIs(task.getAdapterPath());
            String _plus = "{'default' : '" + _expandURIs;
            adapterPaths = _plus_1 = String.valueOf(_plus) + "'}";
        } else {
            adapterPaths = this.getAdapterPathsForPairs(task);
        }
        return adapterPaths;
    }

    public String getAdapterPathsForPairs(TestApplicationGenerationTask task) {
        String _plus_5;
        String adapterPaths = "";
        HashSet<String> list = new HashSet<String>();
        EList<AdapterInterfacePairs> _adapterInterfacePairs = task.getAdapterInterfacePairs();
        for (AdapterInterfacePairs p : _adapterInterfacePairs) {
            EList<Interface> _interfaces = p.getInterfaces();
            for (Interface i : _interfaces) {
                String _name = i.getName();
                String _plus = "'" + _name;
                String _plus_1 = String.valueOf(_plus) + "' : '";
                String _expandURIs = this.expandURIs(p.getAdapterPath());
                String _plus_2 = String.valueOf(_plus_1) + _expandURIs;
                String _plus_3 = String.valueOf(_plus_2) + "'";
                list.add(_plus_3);
            }
        }
        String _join = IterableExtensions.join(list, (CharSequence)",");
        String _plus_4 = "{" + _join;
        adapterPaths = _plus_5 = String.valueOf(_plus_4) + "}";
        return adapterPaths;
    }

    protected String _getInterfaces(TestApplicationGenerationTask task, Component component) {
        boolean _not;
        String interfaces = "";
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)task.getAdapterPath());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _plus_3;
            HashSet<String> list = new HashSet<String>();
            EList _ports = component.getPorts();
            for (Port p : _ports) {
                String _name = p.getInterface().getName();
                String _plus = "'" + _name;
                String _plus_1 = String.valueOf(_plus) + "' : 'default'";
                list.add(_plus_1);
            }
            String _join = IterableExtensions.join(list, (CharSequence)",");
            String _plus_2 = "{" + _join;
            interfaces = _plus_3 = String.valueOf(_plus_2) + "}";
        } else {
            interfaces = this.getInterfacesForPairs(task);
        }
        return interfaces;
    }

    protected String _getInterfaces(TestApplicationGenerationTask task, Interface intf) {
        boolean _not;
        String interfaces = "";
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)task.getAdapterPath());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            String _plus_1;
            String _name = intf.getName();
            String _plus = "{'" + _name;
            interfaces = _plus_1 = String.valueOf(_plus) + "' : 'default'}";
        } else {
            interfaces = this.getInterfacesForPairs(task);
        }
        return interfaces;
    }

    public String getInterfacesForPairs(TestApplicationGenerationTask task) {
        String _plus_5;
        String interfaces = "";
        HashSet<String> list = new HashSet<String>();
        EList<AdapterInterfacePairs> _adapterInterfacePairs = task.getAdapterInterfacePairs();
        for (AdapterInterfacePairs p : _adapterInterfacePairs) {
            EList<Interface> _interfaces = p.getInterfaces();
            for (Interface i : _interfaces) {
                String _name = i.getName();
                String _plus = "'" + _name;
                String _plus_1 = String.valueOf(_plus) + "' : '";
                String _name_1 = i.getName();
                String _plus_2 = String.valueOf(_plus_1) + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + "'";
                list.add(_plus_3);
            }
        }
        String _join = IterableExtensions.join(list, (CharSequence)",");
        String _plus_4 = "{" + _join;
        interfaces = _plus_5 = String.valueOf(_plus_4) + "}";
        return interfaces;
    }

    public String expandURIs(String adapterPath) {
        String[] space = adapterPath.split(" ");
        int i = 0;
        while (i < ((List)Conversions.doWrapArray((Object)space)).size()) {
            String[] semicolon = space[i].split(";");
            int j = 0;
            while (j < ((List)Conversions.doWrapArray((Object)semicolon)).size()) {
                block5: {
                    try {
                        boolean _not;
                        String str = semicolon[j];
                        URI uri = URI.createPlatformResourceURI((String)str, (boolean)true);
                        String absPath = CommonPlugin.resolve((URI)uri).toFileString();
                        boolean _contains = absPath.contains("platform:");
                        boolean bl = _not = !_contains;
                        if (_not) {
                            semicolon[j] = absPath = absPath.replaceAll("\\\\", "/");
                        }
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) break block5;
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                ++j;
            }
            String[] _converted_semicolon = semicolon;
            space[i] = IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_semicolon)), (CharSequence)";");
            ++i;
        }
        String[] _converted_space = space;
        return IterableExtensions.join((Iterable)((Iterable)Conversions.doWrapArray((Object)_converted_space)), (CharSequence)" ");
    }

    public String getAdapterPaths(TestApplicationGenerationTask task, EObject comp) {
        if (comp instanceof Component) {
            return this._getAdapterPaths(task, (Component)comp);
        }
        if (comp instanceof Interface) {
            return this._getAdapterPaths(task, (Interface)comp);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(task, comp).toString());
    }

    public String getInterfaces(TestApplicationGenerationTask task, EObject component) {
        if (component instanceof Component) {
            return this._getInterfaces(task, (Component)component);
        }
        if (component instanceof Interface) {
            return this._getInterfaces(task, (Interface)component);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(task, component).toString());
    }
}

