/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.TargetCompletionProposal;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.TargetDefinitionContentAssist;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.DelegateProcessor;

public class AttributeNameCompletionProcessor
extends DelegateProcessor {
    private String searchTerm;
    private String acKey;
    private int offset;
    private String text;
    private static final String ATTRIBUTE_NAME_FIND = "(?:\\s*(\\w*)\\s*=\\s*\".*?\")";
    private static final Pattern ATT_NAME_PATTERN = Pattern.compile("(?:\\s*(\\w*)\\s*=\\s*\".*?\")");
    private String[] target = new String[]{"name", "sequenceNumber"};
    private String[] locations = new String[0];
    private String[] location = new String[]{"includeAllPlatforms", "includeConfigurePhase", "includeMode", "includeSource", "type"};
    private String[] unit = new String[]{"id", "version"};
    private String[] repository = new String[]{"location"};
    private String[] targetJRE = new String[]{"path"};
    private Map<String, String[]> completionMap = new HashMap<String, String[]>();

    public AttributeNameCompletionProcessor(String searchTerm, String acKey, int offset, String text) {
        this.searchTerm = searchTerm;
        this.acKey = acKey;
        this.offset = offset;
        this.text = text;
        this.init();
    }

    private void init() {
        this.completionMap.put("target", this.target);
        this.completionMap.put("locations", this.locations);
        this.completionMap.put("location", this.location);
        this.completionMap.put("unit", this.unit);
        this.completionMap.put("repository", this.repository);
        this.completionMap.put("targetJRE", this.targetJRE);
    }

    @Override
    public ICompletionProposal[] getCompletionProposals() {
        ArrayList<TargetCompletionProposal> proposals = new ArrayList<TargetCompletionProposal>();
        Object[] strings = this.completionMap.get(this.acKey);
        if (strings != null) {
            Arrays.sort(strings);
            List<String> attributeStrings = this.getSibblingAttributeNames();
            Object[] objectArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                Object string = objectArray[n2];
                StyledString displayString = TargetDefinitionContentAssist.getFilteredStyledString((String)string, this.searchTerm);
                if (displayString != null && displayString.length() != 0 && !attributeStrings.contains(string)) {
                    String proposal = String.valueOf(string) + "=\"\"";
                    proposals.add(new TargetCompletionProposal(proposal, proposal.length(), this.offset - this.searchTerm.length(), this.searchTerm.length(), displayString));
                }
                ++n2;
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private List<String> getSibblingAttributeNames() {
        int offsetOfStart = this.text.lastIndexOf(60, this.offset);
        int offsetOfEnd = this.text.indexOf(62, this.offset);
        String tagText = this.text.substring(offsetOfStart, offsetOfEnd == -1 ? this.text.length() : offsetOfEnd);
        ArrayList<String> attributeStrings = new ArrayList<String>();
        Matcher searchTermMatcher = ATT_NAME_PATTERN.matcher(tagText);
        while (searchTermMatcher.find()) {
            attributeStrings.add(searchTermMatcher.group(1));
        }
        return attributeStrings;
    }
}

