/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple;

import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.ua.core.cheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.ua.ui.PDEUserAssistanceUIPlugin;
import org.eclipse.pde.internal.ua.ui.editor.cheatsheet.simple.SimpleCSDefinitionPage;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;

public class SimpleCSFormOutlinePage
extends FormOutlinePage {
    public SimpleCSFormOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    protected String getObjectText(ISimpleCSObject obj) {
        int limit = 50;
        if (obj.getType() == 0) {
            limit = 30;
        } else if (obj.getType() == 6) {
            limit = 26;
        } else if (obj.getType() == 5) {
            limit = 26;
        } else if (obj.getType() == 10) {
            limit = 22;
        }
        return PDETextHelper.truncateAndTrailOffText((String)PDETextHelper.translateReadText((String)obj.getName()), (int)limit);
    }

    protected Object[] getChildren(Object parent) {
        List list;
        if (parent instanceof SimpleCSDefinitionPage) {
            ISimpleCSModel cheatsheet = (ISimpleCSModel)this.fEditor.getAggregateModel();
            if (cheatsheet != null && cheatsheet.isLoaded()) {
                Object[] list2 = new Object[]{cheatsheet.getSimpleCS()};
                return list2;
            }
        } else if (parent instanceof ISimpleCSObject && (list = ((ISimpleCSObject)parent).getChildren()).size() > 0) {
            return list.toArray();
        }
        return super.getChildren(parent);
    }

    public ILabelProvider createLabelProvider() {
        return new SimpleCSLabelProvider((ILabelProvider)PDEUserAssistanceUIPlugin.getDefault().getLabelProvider());
    }

    protected String getParentPageId(Object item) {
        return "simpleCSPage";
    }

    public class SimpleCSLabelProvider
    extends FormOutlinePage.BasicLabelProvider {
        public SimpleCSLabelProvider(ILabelProvider ilp) {
            super(ilp);
        }

        public String getText(Object obj) {
            if (obj instanceof ISimpleCSObject) {
                return SimpleCSFormOutlinePage.this.getObjectText((ISimpleCSObject)obj);
            }
            return super.getText(obj);
        }
    }
}

