/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.map.ComputedObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.identity.IdentitySet;

public class SetDetailValueObservableMap<M, E>
extends ComputedObservableMap<M, E>
implements IObserving {
    private IObservableFactory<? super M, IObservableValue<E>> observableValueFactory;
    private Map<M, IObservableValue<E>> detailObservableValueMap = new HashMap<M, IObservableValue<E>>();
    private IdentitySet<IObservableValue<?>> staleDetailObservables = new IdentitySet();
    private IStaleListener detailStaleListener = staleEvent -> this.addStaleDetailObservable((IObservableValue)staleEvent.getObservable());

    public SetDetailValueObservableMap(IObservableSet<M> masterKeySet, IObservableFactory<? super M, IObservableValue<E>> observableValueFactory, Object detailValueType) {
        super(masterKeySet, detailValueType);
        this.observableValueFactory = observableValueFactory;
    }

    @Override
    protected void hookListener(M addedKey) {
        IObservableValue<E> detailValue = this.getDetailObservableValue(addedKey);
        detailValue.addValueChangeListener(event -> {
            if (!event.getObservableValue().isStale()) {
                this.staleDetailObservables.remove(detailValue);
            }
            this.fireSingleChange(addedKey, event.diff.getOldValue(), event.diff.getNewValue());
        });
        detailValue.addStaleListener(this.detailStaleListener);
    }

    @Override
    protected void unhookListener(Object removedKey) {
        if (this.isDisposed()) {
            return;
        }
        IObservableValue<E> detailValue = this.detailObservableValueMap.remove(removedKey);
        this.staleDetailObservables.remove(detailValue);
        detailValue.dispose();
    }

    private IObservableValue<E> getDetailObservableValue(M masterKey) {
        IObservableValue<E> detailValue = this.detailObservableValueMap.get(masterKey);
        if (detailValue == null) {
            ObservableTracker.setIgnore(true);
            try {
                detailValue = this.observableValueFactory.createObservable(masterKey);
            }
            finally {
                ObservableTracker.setIgnore(false);
            }
            this.detailObservableValueMap.put(masterKey, detailValue);
            if (detailValue.isStale()) {
                this.addStaleDetailObservable(detailValue);
            }
        }
        return detailValue;
    }

    private void addStaleDetailObservable(IObservableValue<?> detailObservable) {
        boolean wasStale = this.isStale();
        this.staleDetailObservables.add(detailObservable);
        if (!wasStale) {
            this.fireStale();
        }
    }

    @Override
    protected E doGet(M key) {
        IObservableValue<E> detailValue = this.getDetailObservableValue(key);
        return detailValue.getValue();
    }

    @Override
    protected E doPut(M key, E value) {
        IObservableValue<E> detailValue = this.getDetailObservableValue(key);
        E oldValue = detailValue.getValue();
        detailValue.setValue(value);
        return oldValue;
    }

    @Override
    public boolean containsKey(Object key) {
        this.getterCalled();
        return this.keySet().contains(key);
    }

    @Override
    public E remove(Object key) {
        this.checkRealm();
        if (!this.containsKey(key)) {
            return null;
        }
        IObservableValue<E> detailValue = this.getDetailObservableValue(key);
        E oldValue = detailValue.getValue();
        this.keySet().remove(key);
        return oldValue;
    }

    @Override
    public int size() {
        this.getterCalled();
        return this.keySet().size();
    }

    @Override
    public boolean isStale() {
        return super.isStale() || this.staleDetailObservables != null && !this.staleDetailObservables.isEmpty();
    }

    @Override
    public Object getObserved() {
        return this.keySet();
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.observableValueFactory = null;
        this.detailObservableValueMap = null;
        this.detailStaleListener = null;
        this.staleDetailObservables = null;
    }

    private void getterCalled() {
        ObservableTracker.getterCalled(this);
    }
}

