/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecReturn;
import org.eclipse.core.runtime.CoreException;

public class ExecBuiltin
implements ICPPExecution {
    public static final short BUILTIN_FFS = 0;
    public static final short BUILTIN_FFSL = 1;
    public static final short BUILTIN_FFSLL = 2;
    public static final short BUILTIN_CTZ = 3;
    public static final short BUILTIN_CTZL = 4;
    public static final short BUILTIN_CTZLL = 5;
    public static final short BUILTIN_POPCOUNT = 6;
    public static final short BUILTIN_POPCOUNTL = 7;
    public static final short BUILTIN_POPCOUNTLL = 8;
    public static final short BUILTIN_PARITY = 9;
    public static final short BUILTIN_PARITYL = 10;
    public static final short BUILTIN_PARITYLL = 11;
    public static final short BUILTIN_ABS = 12;
    public static final short BUILTIN_LABS = 13;
    public static final short BUILTIN_LLABS = 14;
    private static IType intType = new CPPBasicType(IBasicType.Kind.eInt, 0);
    private static IType longType = new CPPBasicType(IBasicType.Kind.eInt, 1);
    private static IType longlongType = new CPPBasicType(IBasicType.Kind.eInt, 64);
    private short funcId;

    public ExecBuiltin(short funcId) {
        this.funcId = funcId;
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        return this;
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        switch (this.funcId) {
            case 0: 
            case 1: 
            case 2: {
                return this.executeBuiltinFfs(record, context);
            }
            case 3: 
            case 4: 
            case 5: {
                return this.executeBuiltinCtz(record, context);
            }
            case 6: 
            case 7: 
            case 8: {
                return this.executeBuiltinPopcount(record, context);
            }
            case 9: 
            case 10: 
            case 11: {
                return this.executeBuiltinParity(record, context);
            }
            case 12: 
            case 13: 
            case 14: {
                return this.executeBuiltinAbs(record, context);
            }
        }
        return null;
    }

    private ICPPExecution executeBuiltinFfsCtz(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, boolean isCtz) {
        ICPPEvaluation arg0 = record.getVariable(new CPPBuiltinParameter(null, 0));
        IValue argValue = arg0.getValue();
        if (!(argValue instanceof IntegralValue)) {
            return null;
        }
        long arg = argValue.numberValue().longValue();
        if (arg == 0L) {
            if (isCtz) {
                return null;
            }
            return new ExecReturn(new EvalFixed(intType, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(0L)));
        }
        int count = 0;
        while ((arg & 1L) == 0L) {
            arg >>= 1;
            ++count;
        }
        int increment = isCtz ? 0 : 1;
        return new ExecReturn(new EvalFixed(intType, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(count + increment)));
    }

    private ICPPExecution executeBuiltinFfs(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        return this.executeBuiltinFfsCtz(record, context, false);
    }

    private ICPPExecution executeBuiltinCtz(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        return this.executeBuiltinFfsCtz(record, context, true);
    }

    private ICPPExecution executeBuiltinPopcountParity(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, boolean isParity) {
        ICPPEvaluation arg0 = record.getVariable(new CPPBuiltinParameter(null, 0));
        IValue argValue = arg0.getValue();
        if (!(argValue instanceof IntegralValue)) {
            return null;
        }
        long arg = argValue.numberValue().longValue();
        int count = 0;
        while (arg != 0L) {
            if ((arg & 1L) != 0L) {
                ++count;
            }
            arg >>>= 1;
        }
        if (isParity) {
            count &= 1;
        }
        return new ExecReturn(new EvalFixed(intType, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(count)));
    }

    private ICPPExecution executeBuiltinPopcount(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        return this.executeBuiltinPopcountParity(record, context, false);
    }

    private ICPPExecution executeBuiltinParity(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        return this.executeBuiltinPopcountParity(record, context, true);
    }

    private ICPPExecution executeBuiltinAbs(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation arg0 = record.getVariable(new CPPBuiltinParameter(null, 0));
        IValue argValue = arg0.getValue();
        if (!(argValue instanceof IntegralValue)) {
            return null;
        }
        long arg = argValue.numberValue().longValue();
        long result = Math.abs(arg);
        IType resultType = null;
        switch (this.funcId) {
            case 12: {
                resultType = intType;
                break;
            }
            case 13: {
                resultType = longType;
                break;
            }
            case 14: {
                resultType = longlongType;
            }
        }
        return new ExecReturn(new EvalFixed(resultType, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(result)));
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)19);
        buffer.putShort(this.funcId);
    }

    public static ICPPExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        short funcId = buffer.getShort();
        return new ExecBuiltin(funcId);
    }
}

