/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Collection;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.BusyCursorJobRunner;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.refactoring.includes.IElementSelector;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeCreator;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.undo.DocumentUndoManagerRegistry;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class AddIncludeAction
extends TextEditorAction {
    private IElementSelector fAmbiguityResolver;

    public AddIncludeAction(ITextEditor editor) {
        super(CEditorMessages.getBundleForConstructedKeys(), "AddInclude.", editor);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.cdt.ui.add_includes_on_selection_action_context");
        final Shell shell = editor.getEditorSite().getShell();
        this.fAmbiguityResolver = new IElementSelector(){

            @Override
            public <T> T selectElement(Collection<T> elements) {
                Object[] result = new Object[1];
                AddIncludeAction.runInUIThread(() -> {
                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new LabelProvider());
                    dialog.setElements(elements.toArray());
                    dialog.setTitle(CEditorMessages.AddInclude_label);
                    dialog.setMessage(CEditorMessages.AddInclude_description);
                    if (dialog.open() == 0) {
                        objectArray[0] = dialog.getFirstResult();
                    }
                });
                return (T)result[0];
            }
        };
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        final ITranslationUnit tu = AddIncludeAction.getTranslationUnit(editor);
        if (tu == null) {
            return;
        }
        final ISelection selection = this.getTextEditor().getSelectionProvider().getSelection();
        if (selection.isEmpty() || !(selection instanceof ITextSelection)) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        final MultiTextEdit[] holder = new MultiTextEdit[1];
        Job job = new Job(CEditorMessages.AddInclude_action){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public IStatus run(IProgressMonitor monitor) {
                try {
                    IIndex index = CCorePlugin.getIndexManager().getIndex(tu.getCProject(), 33);
                    try {
                        index.acquireReadLock();
                        IASTTranslationUnit ast = tu.getAST(index, ASTCache.PARSE_MODE);
                        if (ast == null) {
                            Status status = CUIPlugin.createErrorStatus(NLS.bind((String)CEditorMessages.AddInclude_ast_not_available, (Object)tu.getPath().toOSString()));
                            return status;
                        }
                        IncludeCreator creator = new IncludeCreator(tu, index, AddIncludeAction.this.fAmbiguityResolver);
                        holder[0] = creator.createInclude(ast, (ITextSelection)selection);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (InterruptedException e) {
                        IStatus iStatus2 = Status.CANCEL_STATUS;
                        return iStatus2;
                    }
                    finally {
                        index.releaseReadLock();
                    }
                }
                catch (CoreException e2) {
                    return e2.getStatus();
                }
            }
        };
        IStatus status = BusyCursorJobRunner.execute(job);
        if (status.isOK()) {
            MultiTextEdit edit = holder[0];
            if (edit.hasChildren()) {
                IEditorInput editorInput = editor.getEditorInput();
                IDocument document = editor.getDocumentProvider().getDocument((Object)editorInput);
                IDocumentUndoManager manager = DocumentUndoManagerRegistry.getDocumentUndoManager((IDocument)document);
                manager.beginCompoundChange();
                try {
                    edit.apply(document);
                }
                catch (BadLocationException | MalformedTreeException e) {
                    CUIPlugin.log(e);
                }
                manager.endCompoundChange();
            }
        } else if (status.matches(4)) {
            ErrorDialog.openError((Shell)editor.getEditorSite().getShell(), (String)CEditorMessages.AddInclude_error_title, (String)CEditorMessages.AddInclude_insertion_failed, (IStatus)status);
        }
    }

    private static void runInUIThread(Runnable runnable) {
        if (Display.getCurrent() != null) {
            runnable.run();
        } else {
            Display.getDefault().syncExec(runnable);
        }
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        this.setEnabled(editor != null && AddIncludeAction.getTranslationUnit(editor) != null);
    }

    private static ITranslationUnit getTranslationUnit(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editor.getEditorInput());
    }

    public void setAmbiguityResolver(IElementSelector fAmbiguityResolver) {
        this.fAmbiguityResolver = fAmbiguityResolver;
    }
}

