/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.gmf;

import java.util.Collection;
import org.eclipse.emf.diffmerge.ui.gmf.Messages;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;

public class GMFDiffMergeLabelProvider
extends DiffMergeLabelProvider {
    private static GMFDiffMergeLabelProvider __instance = null;

    public static GMFDiffMergeLabelProvider getInstance() {
        if (__instance == null) {
            __instance = new GMFDiffMergeLabelProvider();
        }
        return __instance;
    }

    protected String formatTechnicalName(String string_p) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        char lastChar = ' ';
        char[] cArray = string_p.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char aChar = cArray[n2];
            if (first) {
                builder.append(Character.toUpperCase(aChar));
                first = false;
            } else {
                if (Character.isUpperCase(aChar) && Character.isLowerCase(lastChar)) {
                    builder.append(' ');
                }
                builder.append(aChar);
            }
            lastChar = aChar;
            ++n2;
        }
        return builder.toString();
    }

    protected String getContainmentText(EObject element_p) {
        String result = null;
        EReference containment = element_p.eContainmentFeature();
        if (containment != null && this.isSignificant(containment.getName())) {
            result = this.formatTechnicalName(containment.getName());
        }
        return result;
    }

    protected String getExplicitlyTypedElementText(Object element_p, Object type_p) {
        String innerLabel;
        StringBuilder builder = new StringBuilder();
        boolean elementLabelOK = false;
        if (element_p != null && this.isSignificant(innerLabel = this.getText(element_p))) {
            builder.append(innerLabel);
            elementLabelOK = true;
        }
        if (!elementLabelOK) {
            builder.append('(');
            builder.append(Messages.GMFDiffMergeLabelProvider_Unnamed);
            builder.append(')');
        }
        return builder.toString();
    }

    protected String getLayoutText(EObject element_p) {
        return Messages.GMFDiffMergeLabelProvider_Layout;
    }

    protected String getManyQualifiedElementText(EObject element_p, Object ... qualifiers_p) {
        StringBuilder builder = new StringBuilder();
        if (element_p != null) {
            builder.append(this.formatTechnicalName(element_p.eClass().getName()));
            if (qualifiers_p.length > 0) {
                builder.append(' ');
            }
        }
        if (qualifiers_p.length > 0) {
            builder.append('[');
            boolean firstIteration = true;
            Object[] objectArray = qualifiers_p;
            int n = qualifiers_p.length;
            int n2 = 0;
            while (n2 < n) {
                Object qualifier = objectArray[n2];
                if (firstIteration) {
                    firstIteration = false;
                } else {
                    builder.append(", ");
                }
                String innerLabel = this.getText(qualifier);
                builder.append(innerLabel);
                ++n2;
            }
            builder.append(']');
        }
        return builder.toString();
    }

    protected String getQualifiedElementText(EObject element_p, Object qualifier_p) {
        return this.getManyQualifiedElementText(element_p, qualifier_p);
    }

    protected String getRelativeBendpointText(RelativeBendpoint bendpoint_p) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        builder.append(bendpoint_p.getSourceX());
        builder.append(',');
        builder.append(' ');
        builder.append(bendpoint_p.getSourceY());
        builder.append(')');
        builder.append("->");
        builder.append('(');
        builder.append(bendpoint_p.getTargetX());
        builder.append(',');
        builder.append(' ');
        builder.append(bendpoint_p.getTargetY());
        builder.append(')');
        return builder.toString();
    }

    protected String getStyleText(EObject element_p) {
        return this.formatTechnicalName(element_p.eClass().getName());
    }

    public String getText(Object element_p) {
        Diagram diagram;
        String diagramName;
        String result = element_p instanceof Diagram ? (this.isSignificant(diagramName = (diagram = (Diagram)element_p).getName()) ? String.valueOf(diagram.eClass().getName()) + " " + diagramName : this.getViewText((View)diagram)) : (element_p instanceof View ? this.getViewText((View)element_p) : (this.isLayout(element_p) ? this.getLayoutText((EObject)element_p) : (element_p instanceof Style ? this.getStyleText((EObject)element_p) : (element_p instanceof Anchor ? NotationPackage.eINSTANCE.getAnchor().getName() : (element_p instanceof RelativeBendpoint ? this.getRelativeBendpointText((RelativeBendpoint)element_p) : (element_p instanceof Collection && !((Collection)element_p).isEmpty() && ((Collection)element_p).iterator().next() instanceof RelativeBendpoint ? this.getManyQualifiedElementText(null, ((Collection)element_p).toArray()) : (element_p instanceof String ? (String)element_p : super.getText(element_p))))))));
        return result;
    }

    protected String getViewText(View view_p) {
        EObject represented = null;
        if (view_p.eIsSet((EStructuralFeature)NotationPackage.eINSTANCE.getView_Element())) {
            represented = view_p.getElement();
        }
        String result = this.getExplicitlyTypedElementText(represented, view_p.eClass().getName());
        return result;
    }

    protected boolean isLayout(Object element_p) {
        boolean result = false;
        if (element_p instanceof EObject) {
            EReference containment = ((EObject)element_p).eContainmentFeature();
            result = containment == NotationPackage.eINSTANCE.getNode_LayoutConstraint() || containment == NotationPackage.eINSTANCE.getEdge_Bendpoints();
        }
        return result;
    }

    protected boolean isSignificant(String string_p) {
        return string_p != null && string_p.length() > 0;
    }
}

