/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.scopes.IRawDataScope;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.util.DiffLabelDecorator;
import org.eclipse.emf.diffmerge.ui.util.DifferenceKind;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class GitLikeDiffLabelDecorator
extends DiffLabelDecorator {
    private static GitLikeDiffLabelDecorator __instance = null;

    @Override
    public Font getFont(Object object_p, Font base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        Font result = super.getFont(object_p, base_p, diffKind_p, side_p, node_p);
        if (result != null && diffKind_p == DifferenceKind.COUNTED) {
            result = UIUtil.getItalic(result);
        }
        return result;
    }

    @Override
    public Color getForeground(Object object_p, Color base_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        Color result = !(object_p instanceof IRawDataScope) && (diffKind_p == DifferenceKind.COUNTED || diffKind_p == DifferenceKind.NONE) ? UIUtil.getColor(16) : super.getForeground(object_p, base_p, diffKind_p, side_p, node_p);
        return result;
    }

    @Override
    protected EMFDiffMergeUIPlugin.ImageID getImageOverlay(Object object_p, DifferenceKind diffKind_p, Role side_p, EMFDiffNode node_p) {
        EMFDiffMergeUIPlugin.ImageID result = null;
        if (diffKind_p != null) {
            switch (diffKind_p) {
                case FROM_LEFT: 
                case FROM_RIGHT: 
                case FROM_BOTH: 
                case MODIFIED: {
                    result = EMFDiffMergeUIPlugin.ImageID.GIT_DIRTY;
                    break;
                }
                case FROM_LEFT_ADD: 
                case FROM_RIGHT_ADD: {
                    result = EMFDiffMergeUIPlugin.ImageID.GIT_ADDED;
                    break;
                }
                case FROM_LEFT_DEL: 
                case FROM_RIGHT_DEL: {
                    result = EMFDiffMergeUIPlugin.ImageID.GIT_REMOVED;
                    break;
                }
                case CONFLICT: {
                    result = EMFDiffMergeUIPlugin.ImageID.CONFLICT_STAT;
                    break;
                }
            }
        }
        return result;
    }

    public static GitLikeDiffLabelDecorator getInstance() {
        if (__instance == null) {
            __instance = new GitLikeDiffLabelDecorator();
        }
        return __instance;
    }
}

