/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IFragmentedModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.AbstractEditableModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.DynamicUniqueListIterator;
import org.eclipse.emf.diffmerge.impl.scopes.MultiResourceTreeIterator;
import org.eclipse.emf.diffmerge.util.ModelImplUtil;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.diffmerge.util.structures.HashBinaryRelation;
import org.eclipse.emf.diffmerge.util.structures.IBinaryRelation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentedModelScope
extends AbstractEditableModelScope
implements IFragmentedModelScope.Editable {
    private final boolean _isReadOnly;
    protected EditingDomain _editingDomain;
    protected final ResourceSet _resourceSet;
    protected final EList<Resource> _resources;
    protected final List<Resource> _rootResources;
    protected final Set<Resource> _initiallyPresentResources;
    protected final Set<Resource> _loadedResources;
    protected final IBinaryRelation.Editable<Resource, Resource> _includedResources;
    protected final IBinaryRelation.Editable<Resource, Resource> _referencedResources;
    protected ScopeState _state = ScopeState.INITIALIZED;

    public FragmentedModelScope(Resource resource_p, boolean readOnly_p) {
        this(resource_p.getURI(), resource_p.getResourceSet(), readOnly_p);
    }

    public FragmentedModelScope(URI uri_p, EditingDomain editingDomain_p, boolean readOnly_p) {
        this(Collections.singleton(uri_p), editingDomain_p, readOnly_p);
    }

    public FragmentedModelScope(URI uri_p, ResourceSet resourceSet_p, boolean readOnly_p) {
        this(Collections.singleton(uri_p), resourceSet_p, readOnly_p);
    }

    public FragmentedModelScope(Collection<URI> uris_p, EditingDomain editingDomain_p, boolean readOnly_p) {
        this(uris_p, editingDomain_p.getResourceSet(), readOnly_p);
        this._editingDomain = editingDomain_p;
    }

    public FragmentedModelScope(Collection<URI> uris_p, ResourceSet resourceSet_p, boolean readOnly_p) {
        this(resourceSet_p, readOnly_p);
        for (URI uri : uris_p) {
            Resource rootResource = this._resourceSet.getResource(uri, false);
            if (rootResource == null) {
                rootResource = this._resourceSet.createResource(uri);
            }
            this._rootResources.add(rootResource);
            this.addNewResource(rootResource);
        }
    }

    protected FragmentedModelScope(ResourceSet resourceSet_p, boolean readOnly_p) {
        this._isReadOnly = readOnly_p;
        this._resourceSet = resourceSet_p;
        this._resources = new BasicEList();
        this._rootResources = new ArrayList<Resource>();
        this._includedResources = new HashBinaryRelation<Resource, Resource>();
        this._referencedResources = new HashBinaryRelation<Resource, Resource>();
        this._initiallyPresentResources = new HashSet<Resource>();
        this._initiallyPresentResources.addAll((Collection<Resource>)this._resourceSet.getResources());
        this._loadedResources = new HashSet<Resource>();
        if (this._resourceSet instanceof IEditingDomainProvider) {
            this._editingDomain = ((IEditingDomainProvider)this._resourceSet).getEditingDomain();
        }
    }

    @Override
    public boolean add(EObject element_p) {
        boolean result = false;
        Resource defaultResource = this.getResourceForNewRoot(element_p);
        if (defaultResource != null) {
            defaultResource.getContents().add((Object)element_p);
            result = true;
        }
        return result;
    }

    @Override
    public boolean add(EObject source_p, EReference reference_p, EObject value_p) {
        Resource oldResource = value_p.eResource();
        boolean wasRoot = oldResource != null && oldResource.getContents().contains((Object)value_p);
        Object formerId = this.getExtrinsicID(value_p);
        boolean result = super.add(source_p, reference_p, value_p);
        if (wasRoot && reference_p.isContainment()) {
            oldResource.getContents().remove((Object)value_p);
        }
        if (formerId != null) {
            this.setExtrinsicID(value_p, formerId);
        }
        return result;
    }

    protected void addNewResource(Resource resource_p) {
        this._resources.add((Object)resource_p);
    }

    protected boolean containsUnnecessaryProxies(Collection<EObject> collection_p, EObject source_p) {
        for (EObject current : collection_p) {
            if (!current.eIsProxy() || current == ModelImplUtil.resolveIfLoaded(current, source_p)) continue;
            return true;
        }
        return false;
    }

    protected void explorationFinished() {
        AdapterFactoryEditingDomain afEditingDomain;
        Map readOnlyMap;
        this._state = ScopeState.FULLY_EXPLORED;
        this._loadedResources.addAll((Collection<Resource>)this._resourceSet.getResources());
        this._loadedResources.removeAll(this._initiallyPresentResources);
        this._initiallyPresentResources.clear();
        if (this.isReadOnly() && this._editingDomain instanceof AdapterFactoryEditingDomain && (readOnlyMap = (afEditingDomain = (AdapterFactoryEditingDomain)this._editingDomain).getResourceToReadOnlyMap()) != null) {
            for (Resource loadedResource : this._loadedResources) {
                readOnlyMap.put(loadedResource, Boolean.TRUE);
            }
        }
    }

    @Override
    public List<EObject> get(EObject source_p, EReference reference_p) {
        List<EObject> result = super.get(source_p, reference_p);
        boolean requiresResolution = this.containsUnnecessaryProxies(result, source_p);
        if (requiresResolution) {
            result = this.get(source_p, reference_p, true);
        }
        return result;
    }

    @Override
    public TreeIterator<EObject> getAllContents() {
        return new ExpandingMultiResourceTreeIterator();
    }

    @Override
    public List<EObject> getContents() {
        FArrayList result = new FArrayList();
        for (Resource resource : this._rootResources) {
            result.addAll(resource.getContents());
        }
        return Collections.unmodifiableList(result);
    }

    protected Collection<EReference> getCrossReferencesInScope(EObject element_p) {
        return new ArrayList<EReference>();
    }

    @Override
    public Object getExtrinsicID(EObject element_p) {
        return super.getExtrinsicID(element_p);
    }

    @Override
    public Resource getHoldingResource() {
        return this._rootResources.isEmpty() ? null : this._rootResources.get(0);
    }

    public List<Resource> getIncludedResources(Resource resource_p) {
        return this._includedResources.get(resource_p);
    }

    protected Map<Object, Object> getLoadOptions(Resource resource_p) {
        return new HashMap<Object, Object>();
    }

    @Override
    public Object getOriginator() {
        return this.getHoldingResource();
    }

    public List<Resource> getReferencedResources(Resource resource_p) {
        return this._referencedResources.get(resource_p);
    }

    public List<Resource> getRootResources() {
        return Collections.unmodifiableList(this._rootResources);
    }

    protected List<Resource> getRelevantReferencedResources(EObject element_p) {
        FOrderedSet<Resource> result = new FOrderedSet<Resource>();
        Collection<EReference> refsInScope = this.getCrossReferencesInScope(element_p);
        for (EReference ref : refsInScope) {
            if (ref.isContainment() || ref.isContainer() || !element_p.eIsSet((EStructuralFeature)ref)) continue;
            List<EObject> values = this.get(element_p, ref, true);
            for (EObject value : values) {
                Resource valueResource = value.eResource();
                if (valueResource == null) continue;
                result.add(valueResource);
            }
        }
        return result;
    }

    protected Resource getResourceForNewRoot(EObject newRoot_p) {
        for (Resource resource : this._resources) {
            if (!this.isSuitableFor(resource, newRoot_p)) continue;
            return resource;
        }
        return null;
    }

    public List<Resource> getResources() {
        return Collections.unmodifiableList(this._resources);
    }

    public boolean isFullyExplored() {
        return this._state == ScopeState.FULLY_EXPLORED;
    }

    @Override
    public boolean isLoaded() {
        return this._state != ScopeState.INITIALIZED && this._state != ScopeState.UNLOADED;
    }

    @Override
    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    protected boolean isSuitableFor(Resource resource_p, EObject root_p) {
        return true;
    }

    @Override
    public boolean load() throws Exception {
        boolean result = false;
        if (this._state == ScopeState.INITIALIZED || this._state == ScopeState.LOADED) {
            for (Resource rootResource : this._rootResources) {
                Map<Object, Object> options = this.getLoadOptions(rootResource);
                rootResource.load(options);
            }
            this._state = ScopeState.LOADED;
            result = true;
        }
        return result;
    }

    protected final void notifyInclusion(Resource resource_p, EObject element_p) {
        Resource containerResource;
        EObject container;
        if (!this._resources.contains((Object)resource_p)) {
            this.addNewResource(resource_p);
        }
        if ((container = this.getContainer(element_p)) != null && (containerResource = container.eResource()) != null && containerResource != resource_p) {
            this._includedResources.add(containerResource, resource_p);
            this._rootResources.remove(resource_p);
            this._referencedResources.remove(containerResource, resource_p);
            this._resources.move(0, (Object)resource_p);
        }
    }

    protected final void notifyReference(Resource source_p, Resource target_p) {
        if (!this._resources.contains((Object)target_p)) {
            this.addNewResource(target_p);
            this._rootResources.add(target_p);
            this._referencedResources.add(source_p, target_p);
        }
    }

    @Override
    public boolean save() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        for (Resource resource : this.getResources()) {
            resource.save(options);
        }
        return true;
    }

    @Override
    public boolean setExtrinsicID(EObject element_p, Object id_p) {
        return super.setExtrinsicID(element_p, id_p);
    }

    @Override
    public List<Resource> unload() {
        for (Resource loadedResource : this._loadedResources) {
            for (Adapter adapter : new ArrayList(loadedResource.eAdapters())) {
                if (!(adapter instanceof ECrossReferenceAdapter)) continue;
                loadedResource.eAdapters().remove((Object)adapter);
            }
        }
        for (Resource loadedResource : this._loadedResources) {
            this.unloadResource(loadedResource);
        }
        ArrayList<Resource> result = new ArrayList<Resource>(this._loadedResources);
        this._loadedResources.clear();
        if (!result.isEmpty()) {
            this._state = ScopeState.UNLOADED;
        }
        return result;
    }

    protected void unloadResource(Resource resource_p) {
        try {
            if (resource_p.isLoaded()) {
                resource_p.unload();
            }
            this._resourceSet.getResources().remove((Object)resource_p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class ExpandingMultiResourceTreeIterator
    extends MultiResourceTreeIterator {
        public ExpandingMultiResourceTreeIterator() {
            super(new DynamicUniqueListIterator<Resource>((List<Resource>)FragmentedModelScope.this._resources));
        }

        public EObject next() {
            EObject result = super.next();
            if (FragmentedModelScope.this._state != ScopeState.FULLY_EXPLORED) {
                Resource resource = result.eResource();
                if (resource != null) {
                    FragmentedModelScope.this.notifyInclusion(resource, result);
                    for (Resource additionalResource : FragmentedModelScope.this.getRelevantReferencedResources(result)) {
                        FragmentedModelScope.this.notifyReference(resource, additionalResource);
                    }
                }
                if (!this.hasNext()) {
                    FragmentedModelScope.this.explorationFinished();
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ScopeState {
        INITIALIZED,
        LOADED,
        FULLY_EXPLORED,
        UNLOADED;

    }
}

