/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import javax.mail.Session;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.bridge.DirigibleBridge;
import org.eclipse.dirigible.ide.bridge.IInjector;
import org.eclipse.dirigible.ide.bridge.InitParametersInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailInjector
implements IInjector {
    public static final String DEFAULT_MAIL_SESSION = "MailSession";
    private static final Logger logger = LoggerFactory.getLogger(MailInjector.class);

    @Override
    public void injectOnRequest(ServletConfig servletConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Session session = (Session)req.getSession().getAttribute(DEFAULT_MAIL_SESSION);
        if (session == null) {
            try {
                session = this.lookupMailSession();
                if (session != null) {
                    req.getSession().setAttribute(DEFAULT_MAIL_SESSION, (Object)session);
                } else {
                    logger.warn("jndiMailSession not present");
                }
            }
            catch (Exception e) {
                logger.error(DirigibleBridge.class.getCanonicalName(), (Throwable)e);
            }
        }
    }

    @Override
    public void injectOnStart(ServletConfig servletConfig) throws ServletException, IOException {
        Session session = (Session)System.getProperties().get(DEFAULT_MAIL_SESSION);
        if (session == null) {
            try {
                session = this.lookupMailSession();
                if (session != null) {
                    System.getProperties().put(DEFAULT_MAIL_SESSION, session);
                } else {
                    logger.warn("jndiMailSession not present");
                }
            }
            catch (Exception e) {
                logger.error(DirigibleBridge.class.getCanonicalName(), (Throwable)e);
            }
        }
    }

    private Session lookupMailSession() throws NamingException {
        InitialContext ctx = new InitialContext();
        String key = InitParametersInjector.get("jndiMailSession");
        if (key != null) {
            return (Session)ctx.lookup(key);
        }
        return null;
    }
}

