/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.wizards.rename;

import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.workspace.ui.wizards.rename.Messages;
import org.eclipse.dirigible.ide.workspace.ui.wizards.rename.RenameWizardModel;
import org.eclipse.dirigible.ide.workspace.ui.wizards.rename.RenameWizardNamingPage;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class RenameWizard
extends Wizard {
    private static final String CHECK_LOGS_FOR_MORE_INFO = Messages.RenameWizard_CHECK_LOGS_FOR_MORE_INFO;
    private static final String COULD_NOT_COMPLETE_WIZARD_DUE_TO_THE_FOLLOWING_ERROR = Messages.RenameWizard_COULD_NOT_COMPLETE_WIZARD_DUE_TO_THE_FOLLOWING_ERROR;
    private static final String OPERATION_ERROR = Messages.RenameWizard_OPERATION_ERROR;
    private static final String COULD_NOT_COMPLETE_RESOURCE_RENAME = Messages.RenameWizard_COULD_NOT_COMPLETE_RESOURCE_RENAME;
    private static final Logger logger = Logger.getLogger(RenameWizard.class);
    private static final String RENAME_WIZARD_TITLE = Messages.RenameWizard_RENAME_WIZARD_TITLE;
    private final RenameWizardModel model;
    private final RenameWizardNamingPage namingPage;

    public RenameWizard(IResource resource) {
        this.setWindowTitle(RENAME_WIZARD_TITLE);
        this.model = new RenameWizardModel(resource);
        this.namingPage = new RenameWizardNamingPage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.namingPage);
    }

    public boolean performFinish() {
        return this.onFinish();
    }

    public void showErrorDialog(String title, String message) {
        logger.error(message);
        MessageDialog.openError(null, (String)title, (String)message);
    }

    public String getText() {
        if (this.namingPage != null) {
            return this.namingPage.getText();
        }
        return null;
    }

    public boolean onFinish() {
        try {
            this.model.persist();
            return true;
        }
        catch (IOException ex) {
            logger.error(COULD_NOT_COMPLETE_RESOURCE_RENAME, (Throwable)ex);
            this.showErrorDialog(OPERATION_ERROR, String.valueOf(COULD_NOT_COMPLETE_WIZARD_DUE_TO_THE_FOLLOWING_ERROR) + ex.getMessage() + ". " + CHECK_LOGS_FOR_MORE_INFO);
            return false;
        }
    }
}

