/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.supplemental.fileupload.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.service.ServiceManager;
import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadHandler;
import org.eclipse.rap.rwt.supplemental.fileupload.internal.FileUploadHandlerStore;
import org.eclipse.rap.rwt.supplemental.fileupload.internal.FileUploadProcessor;
import org.eclipse.rap.rwt.supplemental.fileupload.internal.Messages;

public final class FileUploadServiceHandler
implements ServiceHandler {
    private static final String CONTENT_MUST_BE_IN_MULTIPART_TYPE = Messages.FileUploadServiceHandler_CONTENT_MUST_BE_IN_MULTIPART_TYPE;
    private static final String INVALID_OR_MISSING_TOKEN = Messages.FileUploadServiceHandler_INVALID_OR_MISSING_TOKEN;
    private static final String ONLY_POST_REQUESTS_ALLOWED = Messages.FileUploadServiceHandler_ONLY_POST_REQUESTS_ALLOWED;
    private static final String PARAMETER_TOKEN = "token";
    static final String SERVICE_HANDLER_ID = "org.eclipse.rap.rwt.supplemental.fileupload.internal.FileUploadServiceHandler";

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean hasSession;
        boolean bl = hasSession = request.getSession(false) != null;
        if (hasSession) {
            String token = request.getParameter(PARAMETER_TOKEN);
            FileUploadHandler registeredHandler = FileUploadHandlerStore.getInstance().getHandler(token);
            if (registeredHandler == null) {
                String message = INVALID_OR_MISSING_TOKEN;
                response.sendError(403, message);
            } else if (!"POST".equals(request.getMethod().toUpperCase())) {
                String message = ONLY_POST_REQUESTS_ALLOWED;
                response.sendError(405, message);
            } else if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                String message = CONTENT_MUST_BE_IN_MULTIPART_TYPE;
                response.sendError(415, message);
            } else {
                FileUploadProcessor processor = new FileUploadProcessor(registeredHandler);
                processor.handleFileUpload(request, response);
            }
        }
    }

    public static String getUrl(String token) {
        ServiceManager manager = RWT.getServiceManager();
        String rootURL = manager.getServiceHandlerUrl(SERVICE_HANDLER_ID);
        StringBuffer url = new StringBuffer();
        url.append(rootURL);
        url.append("&");
        url.append(PARAMETER_TOKEN).append("=").append(token);
        int relativeIndex = url.lastIndexOf("/");
        if (relativeIndex > -1) {
            url.delete(0, relativeIndex + 1);
        }
        return RWT.getResponse().encodeURL(url.toString());
    }
}

