/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db.dialect;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.dirigible.repository.ext.db.dialect.IDialectSpecifier;

public class MySQLDBSpecifier
implements IDialectSpecifier {
    private static final String LIMIT_D_D = "LIMIT %d, %d";
    private static final String MYSQLDB_TIMESTAMP = "TIMESTAMP";
    private static final String MYSQL_FLOAT = "DOUBLE";
    private static final String MYSQL_BLOB = "LONGBLOB";
    private static final String MYSQL_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    private static final String MYSQL_KEY_VARCHAR = "VARCHAR(255)";
    private static final String MYSQL_BIG_VARCHAR = "TEXT";
    private static final String MYSQL_CLOB = "TEXT";

    @Override
    public String specify(String sql) {
        sql = sql.replace("$CURRENT_TIMESTAMP$", MYSQL_CURRENT_TIMESTAMP);
        sql = sql.replace("$TIMESTAMP$", MYSQLDB_TIMESTAMP);
        sql = sql.replace("$BLOB$", MYSQL_BLOB);
        sql = sql.replace("$KEY_VARCHAR$", MYSQL_KEY_VARCHAR);
        sql = sql.replace("$BIG_VARCHAR$", "TEXT");
        sql = sql.replace("$CLOB$", "TEXT");
        return sql;
    }

    @Override
    public String getSpecificType(String commonType) {
        if ("FLOAT".equals(commonType)) {
            return MYSQL_FLOAT;
        }
        if ("BLOB".equals(commonType)) {
            return MYSQL_BLOB;
        }
        if ("CLOB".equals(commonType)) {
            return "TEXT";
        }
        return commonType;
    }

    @Override
    public String createLimitAndOffset(int limit, int offset) {
        return String.format(LIMIT_D_D, offset, limit);
    }

    @Override
    public String createTopAndStart(int limit, int offset) {
        return "";
    }

    @Override
    public boolean isSchemaFilterSupported() {
        return false;
    }

    @Override
    public String getSchemaFilterScript() {
        return null;
    }

    @Override
    public String getAlterAddOpen() {
        return " ADD ";
    }

    @Override
    public String getAlterAddClose() {
        return "";
    }

    @Override
    public InputStream getBinaryStream(ResultSet resultSet, String columnName) throws SQLException {
        Blob data = resultSet.getBlob(columnName);
        return data.getBinaryStream();
    }

    @Override
    public boolean isCatalogForSchema() {
        return true;
    }

    @Override
    public String getAlterAddOpenEach() {
        return "";
    }

    @Override
    public String getAlterAddCloseEach() {
        return "";
    }
}

