/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.rcp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;

public class FileUtils {
    public static void saveFile(String workspacePath, byte[] content) throws FileNotFoundException, IOException {
        FileUtils.createFoldersIfNecessary(workspacePath);
        Path path = FileSystems.getDefault().getPath(workspacePath, new String[0]);
        Files.write(path, content, new OpenOption[0]);
    }

    public static byte[] loadFile(String workspacePath) throws FileNotFoundException, IOException {
        Path path = FileSystems.getDefault().getPath(workspacePath, new String[0]);
        return Files.readAllBytes(path);
    }

    public static void moveFile(String workspacePathOld, String workspacePathNew) throws FileNotFoundException, IOException {
        FileUtils.createFoldersIfNecessary(workspacePathNew);
        Path pathOld = FileSystems.getDefault().getPath(workspacePathOld, new String[0]);
        Path pathNew = FileSystems.getDefault().getPath(workspacePathNew, new String[0]);
        Files.move(pathOld, pathNew, new CopyOption[0]);
    }

    public static void removeFile(String workspacePath) throws FileNotFoundException, IOException {
        Path path = FileSystems.getDefault().getPath(workspacePath, new String[0]);
        Files.delete(path);
    }

    public static boolean createFolder(String workspacePath) {
        File folder = new File(workspacePath);
        if (!folder.exists()) {
            return folder.mkdirs();
        }
        return true;
    }

    public static boolean createFile(String workspacePath) throws IOException {
        FileUtils.createFoldersIfNecessary(workspacePath);
        File file = new File(workspacePath);
        if (!file.exists()) {
            return file.createNewFile();
        }
        return true;
    }

    public static String getExtension(String workspacePath) throws IOException {
        File f = new File(workspacePath);
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getOwner(String workspacePath) throws IOException {
        String convertedPath = FileUtils.convertToWorkspacePath(workspacePath);
        Path path = FileSystems.getDefault().getPath(convertedPath, new String[0]);
        if (new File(convertedPath).exists()) {
            return Files.getOwner(path, new LinkOption[0]).getName();
        }
        return "none";
    }

    public static Date getModifiedAt(String workspacePath) throws IOException {
        String convertedPath = FileUtils.convertToWorkspacePath(workspacePath);
        Path path = FileSystems.getDefault().getPath(convertedPath, new String[0]);
        if (new File(convertedPath).exists()) {
            return new Date(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
        }
        return new Date();
    }

    public static void createFoldersIfNecessary(String workspacePath) {
        int lastIndexOf = workspacePath.lastIndexOf(File.separator);
        if (lastIndexOf > 0) {
            String directory = workspacePath.substring(0, lastIndexOf);
            FileUtils.createFolder(directory);
        }
    }

    private static String convertToWorkspacePath(String path) {
        String workspacePath = null;
        workspacePath = path.startsWith("/") ? path.substring("/".length()) : path;
        workspacePath = workspacePath.replace("/", File.separator);
        return workspacePath;
    }

    public static boolean exists(String repositoryName) {
        Path path;
        if (repositoryName == null || "".equals(repositoryName)) {
            return false;
        }
        try {
            path = FileSystems.getDefault().getPath(repositoryName, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            return false;
        }
        return Files.exists(path, new LinkOption[0]);
    }
}

