/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.preferences;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DatabaseDriverPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final long serialVersionUID = -877187045002896492L;
    private static final Logger logger = Logger.getLogger(DatabaseDriverPreferencePage.class);

    public DatabaseDriverPreferencePage() {
        super(1);
    }

    protected void createFieldEditors() {
        Text text = null;
        DataSource dataSource = DataSourceFacade.getInstance().getDataSource(CommonParameters.getRequest());
        Connection connection = null;
        try {
            try {
                connection = dataSource.getConnection();
                DatabaseMetaData dmd = connection.getMetaData();
                StringFieldEditor databaseDriverNameField = new StringFieldEditor("DATABASE_DRIVER_NAME", "&Driver Name:", this.getFieldEditorParent());
                text = databaseDriverNameField.getTextControl(this.getFieldEditorParent());
                text.setEditable(false);
                String driverName = dmd.getDriverName();
                text.setText(driverName != null ? driverName : "n/a");
                this.addField((FieldEditor)databaseDriverNameField);
                StringFieldEditor databaseMinorVersionField = new StringFieldEditor("DATABASE_DRIVER_MINOR_VERSION", "&Minor Version:", this.getFieldEditorParent());
                text = databaseMinorVersionField.getTextControl(this.getFieldEditorParent());
                text.setEditable(false);
                String driverMinor = String.valueOf(dmd.getDriverMinorVersion());
                text.setText(driverMinor);
                this.addField((FieldEditor)databaseMinorVersionField);
                StringFieldEditor databaseMajorVersionField = new StringFieldEditor("DATABASE_DRIVER_MAJOR_VERSION", "&Major Version:", this.getFieldEditorParent());
                text = databaseMajorVersionField.getTextControl(this.getFieldEditorParent());
                text.setEditable(false);
                String driverMajor = String.valueOf(dmd.getDriverMajorVersion());
                text.setText(driverMajor);
                this.addField((FieldEditor)databaseMajorVersionField);
                StringFieldEditor databaseConnectionClassNameField = new StringFieldEditor("DATABASE_CONNECTION_CLASS_NAME", "&Connection Class Name:", this.getFieldEditorParent());
                text = databaseConnectionClassNameField.getTextControl(this.getFieldEditorParent());
                text.setEditable(false);
                String driverClass = connection.getClass().getCanonicalName();
                text.setText(driverClass != null ? driverClass : "n/a");
                this.addField((FieldEditor)databaseConnectionClassNameField);
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void init(IWorkbench workbench) {
        super.initialize();
    }
}

