/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.ui.rap.entry;

import java.net.URL;
import java.util.Dictionary;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dirigible.ide.ui.rap.entry.Messages;
import org.eclipse.dirigible.repository.api.RepositoryActivator;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.osgi.framework.Bundle;

public class DirigibleActionBarAdvisor
extends ActionBarAdvisor {
    private static final String HELP = Messages.DirigibleActionBarAdvisor_HELP;
    private static final String WINDOW = Messages.DirigibleActionBarAdvisor_WINDOW;
    private static final String RUNNING_ON_RAP_VERSION = Messages.DirigibleActionBarAdvisor_RUNNING_ON_RAP_VERSION;
    private static final String WORKBENCH = Messages.DirigibleActionBarAdvisor_WORKBENCH;
    private static final String HTTP_DIRIGIBLE_HOME = "http://www.dirigible.io";
    private static final String HTTP_DIRIGIBLE_HELP = "http://help.dirigible.io";
    private static final String HTTP_DIRIGIBLE_SAMPLES = "http://samples.dirigible.io";
    private static final String HTTP_DIRIGIBLE_FORUM = "http://forum.dirigible.io";
    private static final String HTTP_DIRIGIBLE_BUG = "https://bugs.eclipse.org/bugs/enter_bug.cgi?product=Dirigible";
    private static final String ABOUT = Messages.DirigibleActionBarAdvisor_ABOUT;
    private static final String DIRIGIBLE_HOME = Messages.DirigibleActionBarAdvisor_DIRIGIBLE_HOME;
    private static final String DIRIGIBLE_HELP = Messages.DirigibleActionBarAdvisor_DIRIGIBLE_HELP;
    private static final String DIRIGIBLE_SAMPLES = Messages.DirigibleActionBarAdvisor_DIRIGIBLE_SAMPLES;
    private static final String DIRIGIBLE_FORUM = Messages.DirigibleActionBarAdvisor_DIRIGIBLE_FORUM;
    private static final String DIRIGIBLE_BUG = Messages.DirigibleActionBarAdvisor_DIRIGIBLE_BUG;
    private static final String SHOW_VIEW = Messages.DirigibleActionBarAdvisor_SHOW_VIEW;
    private static final String SHOW_PERSPECTIVE = Messages.DirigibleActionBarAdvisor_SHOW_PERSPECTIVE;
    private static final Logger logger = Logger.getLogger(DirigibleActionBarAdvisor.class);
    private static final String WEB_PAGE_ERROR = Messages.DirigibleActionBarAdvisor_WEB_PAGE_ERROR;
    private static final String COULD_NOT_OPEN_WEB_PAGE = Messages.DirigibleActionBarAdvisor_COULD_NOT_OPEN_WEB_PAGE;
    private ActionFactory.IWorkbenchAction newAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private ActionFactory.IWorkbenchAction importAction;
    private ActionFactory.IWorkbenchAction exportAction;
    private ActionFactory.IWorkbenchAction exitAction;
    private Action dirigibleHomeAction;
    private Action dirigibleHelpAction;
    private Action dirigibleSamplesAction;
    private Action dirigibleForumAction;
    private Action dirigibleBugAction;
    private Action aboutAction;
    private MenuManager showPerspectiveMenuMgr;
    private MenuManager showViewMenuMgr;
    private ActionFactory.IWorkbenchAction preferencesAction;

    public DirigibleActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(final IWorkbenchWindow window) {
        this.newAction = ActionFactory.NEW.create(window);
        this.register((IAction)this.newAction);
        this.saveAction = ActionFactory.SAVE.create(window);
        this.register((IAction)this.saveAction);
        this.saveAllAction = ActionFactory.SAVE_ALL.create(window);
        this.register((IAction)this.saveAllAction);
        this.importAction = ActionFactory.IMPORT.create(window);
        this.register((IAction)this.importAction);
        this.exportAction = ActionFactory.EXPORT.create(window);
        this.register((IAction)this.exportAction);
        this.exitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.exitAction);
        this.showPerspectiveMenuMgr = new MenuManager(SHOW_PERSPECTIVE, "showPerspective");
        this.showViewMenuMgr = new MenuManager(SHOW_VIEW, "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        this.showViewMenuMgr.add(showViewMenu);
        this.preferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.preferencesAction);
        this.dirigibleHomeAction = new Action(){
            private static final long serialVersionUID = 7112545561507879756L;

            public void run() {
                DirigibleActionBarAdvisor.this.onWebPageAction(window.getWorkbench(), DirigibleActionBarAdvisor.this.dirigibleHomeAction, DirigibleActionBarAdvisor.HTTP_DIRIGIBLE_HOME);
            }
        };
        this.dirigibleHomeAction.setText(DIRIGIBLE_HOME);
        this.dirigibleHomeAction.setId("org.eclipse.dirigible.ide.home");
        this.register((IAction)this.dirigibleHomeAction);
        this.dirigibleHelpAction = new Action(){
            private static final long serialVersionUID = 7112545561507879756L;

            public void run() {
                DirigibleActionBarAdvisor.this.onWebPageAction(window.getWorkbench(), DirigibleActionBarAdvisor.this.dirigibleHelpAction, DirigibleActionBarAdvisor.HTTP_DIRIGIBLE_HELP);
            }
        };
        this.dirigibleHelpAction.setText(DIRIGIBLE_HELP);
        this.dirigibleHelpAction.setId("org.eclipse.dirigible.ide.help");
        this.register((IAction)this.dirigibleHelpAction);
        this.dirigibleSamplesAction = new Action(){
            private static final long serialVersionUID = 7112545561507879756L;

            public void run() {
                DirigibleActionBarAdvisor.this.onWebPageAction(window.getWorkbench(), DirigibleActionBarAdvisor.this.dirigibleSamplesAction, DirigibleActionBarAdvisor.HTTP_DIRIGIBLE_SAMPLES);
            }
        };
        this.dirigibleSamplesAction.setText(DIRIGIBLE_SAMPLES);
        this.dirigibleSamplesAction.setId("org.eclipse.dirigible.ide.samples");
        this.register((IAction)this.dirigibleSamplesAction);
        this.dirigibleForumAction = new Action(){
            private static final long serialVersionUID = 7112545561507879756L;

            public void run() {
                DirigibleActionBarAdvisor.this.onWebPageAction(window.getWorkbench(), DirigibleActionBarAdvisor.this.dirigibleForumAction, DirigibleActionBarAdvisor.HTTP_DIRIGIBLE_FORUM);
            }
        };
        this.dirigibleForumAction.setText(DIRIGIBLE_FORUM);
        this.dirigibleForumAction.setId("org.eclipse.dirigible.ide.forum");
        this.register((IAction)this.dirigibleForumAction);
        this.dirigibleBugAction = new Action(){
            private static final long serialVersionUID = 7112545561507879756L;

            public void run() {
                DirigibleActionBarAdvisor.this.onWebPageAction(window.getWorkbench(), DirigibleActionBarAdvisor.this.dirigibleBugAction, DirigibleActionBarAdvisor.HTTP_DIRIGIBLE_BUG);
            }
        };
        this.dirigibleBugAction.setText(DIRIGIBLE_BUG);
        this.dirigibleBugAction.setId("org.eclipse.dirigible.ide.bug");
        this.register((IAction)this.dirigibleBugAction);
        this.aboutAction = new Action(){
            private static final long serialVersionUID = 8477239924815783883L;

            public void run() {
                DirigibleActionBarAdvisor.this.onAboutAction(window.getShell());
            }
        };
        this.aboutAction.setText(ABOUT);
        this.aboutAction.setId("org.eclipse.dirigible.ide.about");
        this.register((IAction)this.aboutAction);
    }

    private void onWebPageAction(IWorkbench workbench, Action action, String url) {
        IWorkbenchBrowserSupport browserSupport = workbench.getBrowserSupport();
        int style = 128;
        try {
            IWebBrowser browser = browserSupport.createBrowser(style, action.getId(), "", "");
            browser.openURL(new URL(url));
        }
        catch (Exception e) {
            logger.error(COULD_NOT_OPEN_WEB_PAGE, (Throwable)e);
            MessageDialog.openError(null, (String)WEB_PAGE_ERROR, (String)COULD_NOT_OPEN_WEB_PAGE);
        }
    }

    private void onAboutAction(Shell shell) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.rap.ui");
        Dictionary headers = bundle.getHeaders();
        Object version = headers.get("Bundle-Version");
        MessageDialog.openInformation((Shell)shell, (String)("Eclipse Dirigible" + WORKBENCH), (String)("Eclipse Dirigible\n Version: " + RepositoryActivator.DIRIGIBLE_PRODUCT_VERSION + "\n" + RUNNING_ON_RAP_VERSION + version + "\n" + "License: Eclipse Public License v1.0"));
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager fileMenu = new MenuManager(Messages.DirigibleActionBarAdvisor_FILE, "id.file");
        fileMenu.add((IContributionItem)new Separator("additions"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.saveAction);
        fileMenu.add((IAction)this.saveAllAction);
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add((IAction)this.exitAction);
        menuBar.add((IContributionItem)fileMenu);
        MenuManager windowMenu = new MenuManager(WINDOW, "window");
        windowMenu.add((IContributionItem)this.showPerspectiveMenuMgr);
        windowMenu.add((IContributionItem)this.showViewMenuMgr);
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)this.preferencesAction);
        menuBar.add((IContributionItem)windowMenu);
        MenuManager helpMenu = new MenuManager(HELP, "help");
        helpMenu.add((IAction)this.dirigibleHelpAction);
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)this.dirigibleHomeAction);
        helpMenu.add((IAction)this.dirigibleSamplesAction);
        helpMenu.add((IAction)this.dirigibleForumAction);
        helpMenu.add((IAction)this.dirigibleBugAction);
        helpMenu.add((IContributionItem)new Separator("about"));
        helpMenu.add((IAction)this.aboutAction);
        menuBar.add((IContributionItem)helpMenu);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager toolbar = new ToolBarManager(0x820000);
        toolbar.add((IAction)this.saveAction);
        toolbar.add((IAction)this.saveAllAction);
        toolbar.add((IContributionItem)new Separator("control"));
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "main"));
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        statusLine.add((IAction)this.dirigibleBugAction);
    }
}

