/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.ui.rap.entry;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.common.io.ProxyUtils;
import org.eclipse.dirigible.ide.ui.rap.api.DirigibleWorkbenchInitializersManager;
import org.eclipse.dirigible.ide.ui.rap.api.IDirigibleWorkbenchInitializer;
import org.eclipse.dirigible.ide.ui.rap.entry.DirigibleWorkbenchAdvisor;
import org.eclipse.dirigible.ide.ui.rap.entry.Messages;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.rap.rwt.application.AbstractEntryPoint;
import org.eclipse.rap.rwt.client.service.ExitConfirmation;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class DirigibleWorkbench
extends AbstractEntryPoint {
    private static final String ARE_YOU_SURE_YOU_WANT_TO_QUIT = Messages.DirigibleWorkbench_ARE_YOU_SURE_YOU_WANT_TO_QUIT;
    private static final Logger logger = Logger.getLogger(DirigibleWorkbench.class);

    public int createUI() {
        Display display = PlatformUI.createDisplay();
        this.createContents((Composite)display.getActiveShell());
        ExitConfirmation service = (ExitConfirmation)CommonParameters.getService(ExitConfirmation.class);
        service.setMessage(String.format(ARE_YOU_SURE_YOU_WANT_TO_QUIT, "Eclipse Dirigible"));
        try {
            ProxyUtils.setProxySettings();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new DirigibleWorkbenchAdvisor());
    }

    protected void createContents(Composite parent) {
        Collection paramaters = this.getParameterNames();
        for (String parameter : paramaters) {
            CommonParameters.set((String)parameter, (String)this.getParameter(parameter));
        }
        List<IDirigibleWorkbenchInitializer> initializersList = DirigibleWorkbenchInitializersManager.getInitializers();
        for (IDirigibleWorkbenchInitializer initializer : initializersList) {
            initializer.doInitialization();
        }
    }
}

