/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.Lozenge;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractNotSelectableShapeNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramBorderNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.FixedLayoutEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.figure.AirStyleDefaultSizeNodeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.LozengeFigure;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.LabelStyle;

public class LozengeEditPart
extends AbstractNotSelectableShapeNodeEditPart
implements IStyleEditPart {
    public static final int VISUAL_ID = 3017;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.resolveSemanticElement() instanceof Lozenge) {
            Lozenge lozenge = (Lozenge)this.resolveSemanticElement();
            int borderSize = 0;
            if (lozenge.getBorderSize() != null) {
                borderSize = lozenge.getBorderSize();
            }
            this.getPrimaryShape().setLineWidth(borderSize);
            DiagramNodeEditPartOperation.refreshFigure(this);
            DiagramElementEditPartOperation.refreshLabelAlignment(((GraphicalEditPart)this.getParent()).getContentPane(), (LabelStyle)lozenge);
        }
    }

    protected void refreshBackgroundColor() {
        Lozenge lozenge;
        if (this.getMetamodelType().isInstance(this.resolveSemanticElement()) && (lozenge = (Lozenge)this.resolveSemanticElement()).getColor() != null) {
            this.getPrimaryShape().setBackgroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(lozenge.getColor()));
        }
    }

    protected void refreshForegroundColor() {
        Lozenge lozenge;
        if (this.getMetamodelType().isInstance(this.resolveSemanticElement()) && (lozenge = (Lozenge)this.resolveSemanticElement()).getBorderColor() != null) {
            this.getPrimaryShape().setForegroundColor(VisualBindingManager.getDefault().getColorFromRGBValues(lozenge.getBorderColor()));
        }
    }

    public LozengeEditPart(View view) {
        super(view);
    }

    public DragTracker getDragTracker(Request request) {
        return this.getParent().getDragTracker(request);
    }

    protected void createDefaultEditPolicies() {
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        return new FixedLayoutEditPolicy();
    }

    protected IFigure createNodeShape() {
        LozengeFigure lozenge = new LozengeFigure();
        EditPart parent = this.getParent();
        if (parent instanceof IDiagramBorderNodeEditPart) {
            DiagramBorderNodeEditPartOperation.updateTransparencyMode((IDiagramBorderNodeEditPart)parent, lozenge);
        }
        this.primaryShape = lozenge;
        return this.primaryShape;
    }

    public LozengeFigure getPrimaryShape() {
        return (LozengeFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        AirStyleDefaultSizeNodeFigure result = new AirStyleDefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40));
        return result;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        EditPolicy result = super.getPrimaryDragEditPolicy();
        if (result instanceof ResizableEditPolicy) {
            ResizableEditPolicy ep = (ResizableEditPolicy)result;
            ep.setResizeDirections(0);
        }
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected Class<?> getMetamodelType() {
        return Lozenge.class;
    }
}

