/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.palette;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.palette.PaletteToolEntry;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPlugin;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.helper.layers.LayerService;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.RequestDescription;
import org.eclipse.sirius.diagram.description.tool.ToolGroup;
import org.eclipse.sirius.diagram.description.tool.ToolGroupExtension;
import org.eclipse.sirius.diagram.description.tool.ToolSection;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.palette.PaletteManager;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.palette.ToolFilter;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.ConnectionCreationTool;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.CreationToolPaletteFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.PaletteImageProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.PaletteToolFilterDescriptionListenersManager;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.SectionPaletteDrawer;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.SiriusDiagramPaletteFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.ToolFilterFromDescription;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.ToolGroupPaletteStack;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.Environment;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolEntry;
import org.eclipse.sirius.viewpoint.description.tool.ToolFilterDescription;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class PaletteManagerImpl
implements PaletteManager {
    private static PaletteImageProvider paletteImageProvider = new PaletteImageProvider();
    private EditDomain editDomain;
    private PaletteRoot paletteRoot;
    private Set<ToolFilter> filters = new LinkedHashSet<ToolFilter>();
    private PaletteToolFilterDescriptionListenersManager listenersManager;
    private boolean isDisposed;

    public PaletteManagerImpl(EditDomain editDomain) {
        this.editDomain = editDomain;
        this.listenersManager = new PaletteToolFilterDescriptionListenersManager(this);
    }

    @Override
    public void dispose() {
        this.listenersManager.dispose();
        this.listenersManager = null;
        this.filters.clear();
        this.isDisposed = true;
    }

    @Override
    public void addToolFilter(ToolFilter toolFilter) {
        this.filters.add(toolFilter);
    }

    @Override
    public void removeToolFilter(ToolFilter toolFilter) {
        this.filters.remove(toolFilter);
    }

    private boolean isFiltered(DDiagram diagram, AbstractToolDescription toolDescription) {
        for (ToolFilter filter : this.filters) {
            if (!filter.filter(diagram, toolDescription)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update(Diagram diagram) {
        this.update(diagram, false);
    }

    @Override
    public void update(final Diagram diagram, final boolean clean) {
        if (diagram != null) {
            this.initPaletteRoot();
            if (Display.getCurrent() != null) {
                this.updatePalette(diagram, clean);
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PaletteManagerImpl.this.updatePalette(diagram, clean);
                    }
                });
            }
        }
    }

    private void updatePalette(Diagram diagram, boolean clean) {
        this.initPaletteRoot();
        if (this.paletteRoot != null) {
            this.clearFilters(diagram);
            if (clean && !this.paletteRoot.getChildren().isEmpty()) {
                PaletteContainer defaultTools = this.paletteRoot.getDefaultEntry().getParent();
                for (PaletteEntry child : Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.paletteRoot.getChildren(), PaletteEntry.class))) {
                    if (child == defaultTools) continue;
                    this.paletteRoot.remove(child);
                }
            }
        }
        this.updatePalette(diagram);
        this.paletteRoot = null;
    }

    private void initPaletteRoot() {
        PaletteViewer viewer = this.editDomain.getPaletteViewer();
        this.paletteRoot = viewer != null ? viewer.getPaletteRoot() : (PaletteRoot)ReflectionHelper.getFieldValueWithoutException((Object)this.editDomain, (String)"paletteRoot").get();
    }

    private void updatePalette(Diagram diagram) {
        EObject element = diagram.getElement();
        if (element instanceof DDiagram) {
            DDiagram dDiagram = (DDiagram)element;
            DiagramDescription description = dDiagram.getDescription();
            Session session = null;
            if (dDiagram instanceof DSemanticDiagram) {
                session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)dDiagram).getTarget());
            }
            this.addDefaultTools(diagram);
            this.replaceNoteAttachmentCreationToolIfNeeded();
            if (session != null && description != null && description.eResource() != null && !description.eIsProxy()) {
                this.updatePalette(description, session, dDiagram);
            }
        }
    }

    private void updatePalette(DiagramDescription description, Session session, DDiagram dDiagram) {
        if (LayerService.withoutLayersMode((DiagramDescription)description)) {
            this.updatePaletteForDiagramWithoutLayer(description, session, dDiagram);
        } else {
            this.updatePaletteForDiagramWithLayer(description, session, dDiagram);
        }
    }

    private void updatePaletteForDiagramWithoutLayer(DiagramDescription description, Session session, DDiagram dDiagram) {
        String name = new IdentifiedElementQuery((IdentifiedElement)description).getLabel();
        Option descGroup = this.getPaletteEntry((PaletteContainer)this.paletteRoot, name, PaletteGroup.class);
        if (!descGroup.some()) {
            descGroup = Options.newSome((Object)((Object)new PaletteGroup(name, name)));
            this.paletteRoot.add((PaletteEntry)descGroup.get());
        }
        this.updateFilters(session, (List<? extends ToolEntry>)description.getAllTools());
        this.updateContainer(session, dDiagram, (PaletteContainer)descGroup.get(), (List<? extends ToolEntry>)description.getAllTools());
    }

    private void updatePaletteForDiagramWithLayer(DiagramDescription description, Session session, DDiagram dDiagram) {
        HashSet layersInActivatedViewpoints = new HashSet(new DiagramComponentizationManager().getAllLayers(session.getSelectedViewpoints(false), description));
        HashSet activatedLayers = new HashSet(dDiagram.getActivatedLayers());
        ArrayList activatedLayersOfSelectedViewpoints = Lists.newArrayList((Iterable)Sets.intersection(layersInActivatedViewpoints, activatedLayers));
        ArrayList deactivatedLayersAndAllLayersOfDeselectedViewpoints = Lists.newArrayList((Iterable)Sets.symmetricDifference(layersInActivatedViewpoints, activatedLayers));
        for (ToolSection section : new DiagramComponentizationManager().getRootPaletteSections(session.getSelectedViewpoints(false), description)) {
            this.updateFilters(session, (List<? extends ToolEntry>)new DiagramComponentizationManager().getAllToolEntries(session.getSelectedViewpoints(false), section));
        }
        for (ToolSection section : new DiagramComponentizationManager().getRootPaletteSections(session.getSelectedViewpoints(false), description)) {
            Option<SectionPaletteDrawer> paletteEntry = this.getPaletteEntry((PaletteContainer)this.paletteRoot, MessageTranslator.INSTANCE.getMessage((EObject)section, new IdentifiedElementQuery((IdentifiedElement)section).getLabel()), SectionPaletteDrawer.class);
            if (!paletteEntry.some()) {
                PaletteContainer container = PaletteManagerImpl.createPaletteDrawner(section);
                this.updateContainer(session, dDiagram, container, (List<? extends ToolEntry>)new DiagramComponentizationManager().getAllToolEntries(session.getSelectedViewpoints(false), section));
                this.paletteRoot.add((PaletteEntry)container);
                continue;
            }
            this.updateContainer(session, dDiagram, (PaletteContainer)paletteEntry.get(), (List<? extends ToolEntry>)new DiagramComponentizationManager().getAllToolEntries(session.getSelectedViewpoints(false), section));
        }
        for (Layer layer : Lists.newArrayList((Iterable)deactivatedLayersAndAllLayersOfDeselectedViewpoints)) {
            this.setLayerVisibility(layer, false);
        }
        for (Layer layer : Lists.newArrayList((Iterable)activatedLayersOfSelectedViewpoints)) {
            this.setLayerVisibility(layer, true);
        }
    }

    private <T extends PaletteEntry> Option<T> getPaletteEntry(PaletteContainer container, final String id, Class<T> type) {
        Option matchingPaletteEntry = Options.newNone();
        UnmodifiableIterator matchingPaletteEntries = Iterators.filter((Iterator)Iterators.filter(container.getChildren().iterator(), type), (Predicate)new Predicate<T>(){

            public boolean apply(T paletteEntry) {
                return id.equals(paletteEntry.getId());
            }
        });
        try {
            matchingPaletteEntry = Options.newSome((Object)((PaletteEntry)Iterators.getOnlyElement((Iterator)matchingPaletteEntries)));
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DiagramPlugin.getDefault().logWarning(MessageFormat.format(Messages.PaletteManagerImpl_severalCandidatesInPalette, type.getName(), id));
        }
        return matchingPaletteEntry;
    }

    private void replaceNoteAttachmentCreationToolIfNeeded() {
        CreationToolEntry noteAttachment;
        String notesContainerLabel = Platform.getResourceString((Bundle)DiagramUIPlugin.getInstance().getBundle(), (String)"%NoteStack.Label");
        PaletteContainer notesContainer = this.getPaletteContainer((PaletteContainer)this.paletteRoot, notesContainerLabel);
        if (notesContainer != null && !((noteAttachment = this.getNoteAttachementToolEntry(notesContainer)).getToolProperty(CreationTool.PROPERTY_CREATION_FACTORY) instanceof SiriusDiagramPaletteFactory)) {
            SiriusDiagramPaletteFactory viewpointDiagramPaletteFactory = new SiriusDiagramPaletteFactory();
            PaletteToolEntry paletteEntry = new PaletteToolEntry(noteAttachment.getId(), noteAttachment.getLabel(), (PaletteFactory)viewpointDiagramPaletteFactory);
            paletteEntry.setToolProperty(CreationTool.PROPERTY_CREATION_FACTORY, (Object)viewpointDiagramPaletteFactory);
            paletteEntry.setDescription(noteAttachment.getDescription());
            paletteEntry.setLargeIcon(noteAttachment.getLargeIcon());
            paletteEntry.setSmallIcon(noteAttachment.getSmallIcon());
            notesContainer.add(notesContainer.getChildren().indexOf(noteAttachment), (PaletteEntry)paletteEntry);
            notesContainer.remove((PaletteEntry)noteAttachment);
        }
    }

    private CreationToolEntry getNoteAttachementToolEntry(PaletteContainer container) {
        String noteAttachmentToolLabel = Platform.getResourceString((Bundle)DiagramUIPlugin.getInstance().getBundle(), (String)"%NoteAttachmentTool.Label");
        for (Object child : container.getChildren()) {
            CreationToolEntry paletteToolEntry;
            if (!(child instanceof CreationToolEntry) || !noteAttachmentToolLabel.equals((paletteToolEntry = (CreationToolEntry)child).getLabel())) continue;
            return paletteToolEntry;
        }
        return null;
    }

    private PaletteContainer getPaletteContainer(PaletteContainer container, String searchedLabel) {
        PaletteContainer result = null;
        if (container != null) {
            for (Object child : container.getChildren()) {
                if (child instanceof PaletteContainer) {
                    result = searchedLabel.equals(((PaletteContainer)child).getLabel()) ? (PaletteContainer)child : this.getPaletteContainer((PaletteContainer)child, searchedLabel);
                }
                if (result != null) break;
            }
        }
        return result;
    }

    @Override
    public void hideLayer(Layer layer) {
        this.initPaletteRoot();
        if (this.paletteRoot != null) {
            this.setLayerVisibility(layer, false);
            this.paletteRoot = null;
        }
    }

    @Override
    public void showLayer(Layer layer) {
        PaletteViewer viewer = this.editDomain.getPaletteViewer();
        if (viewer != null) {
            this.paletteRoot = viewer.getPaletteRoot();
            this.setLayerVisibility(layer, true);
            this.paletteRoot = null;
        }
    }

    private void setLayerVisibility(Layer layer, boolean visibility) {
        EList sections = layer.getToolSections();
        for (SectionPaletteDrawer sectionDrawer : Iterables.filter((Iterable)this.paletteRoot.getChildren(), SectionPaletteDrawer.class)) {
            this.setToolSectionsVisibility(layer, sectionDrawer, (Collection<ToolSection>)sections, visibility);
            if (sectionDrawer.getChildren().isEmpty()) {
                sectionDrawer.setVisible(false);
                continue;
            }
            if (!visibility && sectionDrawer.isEmptyOfContributors()) {
                sectionDrawer.setVisible(false);
                continue;
            }
            if (!visibility || sectionDrawer.isEmptyOfContributors()) continue;
            sectionDrawer.setVisible(true);
        }
    }

    private void setToolSectionsVisibility(Layer layer, SectionPaletteDrawer drawer, Collection<ToolSection> sections, boolean visibility) {
        for (ToolSection section : sections) {
            if (drawer.getId().equals(PaletteManagerImpl.getToolSectionId(section))) {
                if (visibility && PaletteManagerImpl.isSectionNotEmpty(section)) {
                    drawer.addLayer(layer);
                } else {
                    drawer.removeLayer(layer);
                }
            }
            PaletteManagerImpl.setToolsVisibility(drawer, layer, section, visibility);
        }
    }

    private static boolean isSectionNotEmpty(ToolSection toolSection) {
        boolean result = !toolSection.getOwnedTools().isEmpty();
        result = result || !toolSection.getReusedTools().isEmpty();
        Iterator iterator = toolSection.getSubSections().iterator();
        while (!result && iterator.hasNext()) {
            ToolSection subSection = (ToolSection)iterator.next();
            result = PaletteManagerImpl.isSectionNotEmpty(subSection);
        }
        return result;
    }

    private static void setToolsVisibility(PaletteDrawer drawner, Layer layer, ToolSection section, boolean visibility) {
        for (PaletteEntry entry : drawner.getChildren()) {
            if (entry instanceof ToolGroupPaletteStack) {
                ToolGroupPaletteStack stack = (ToolGroupPaletteStack)entry;
                PaletteManagerImpl.setPaletteStackVisibility(stack, layer, (Collection<? extends ToolEntry>)section.getOwnedTools(), visibility);
                PaletteManagerImpl.setPaletteStackVisibility(stack, layer, (Collection<? extends ToolEntry>)section.getReusedTools(), visibility);
                for (ToolGroupExtension groupExtension : section.getGroupExtensions()) {
                    if (!stack.getId().equals(PaletteManagerImpl.getToolEntryId((ToolEntry)groupExtension.getGroup()))) continue;
                    if (visibility) {
                        stack.addLayer(layer);
                    } else {
                        stack.removeLayer(layer);
                    }
                    for (PaletteEntry subEntry : stack.getChildren()) {
                        PaletteManagerImpl.setPaletteEntryVisibility(subEntry, (Collection<? extends ToolEntry>)groupExtension.getTools(), visibility);
                    }
                }
                if (!visibility && stack.isEmptyOfContributors()) {
                    stack.setVisible(false);
                    continue;
                }
                if (!visibility || stack.isEmptyOfContributors()) continue;
                stack.setVisible(true);
                continue;
            }
            PaletteManagerImpl.setPaletteEntryVisibility(entry, (Collection<? extends ToolEntry>)section.getOwnedTools(), visibility);
            PaletteManagerImpl.setPaletteEntryVisibility(entry, (Collection<? extends ToolEntry>)section.getReusedTools(), visibility);
        }
    }

    private static void setPaletteStackVisibility(ToolGroupPaletteStack stack, Layer layer, Collection<? extends ToolEntry> toolEntries, boolean visibility) {
        for (ToolEntry toolEntry : toolEntries) {
            if (!(toolEntry instanceof ToolGroup) || !stack.getId().equals(PaletteManagerImpl.getToolEntryId(toolEntry))) continue;
            if (visibility) {
                stack.addLayer(layer);
                continue;
            }
            stack.removeLayer(layer);
        }
    }

    private static void setPaletteEntryVisibility(PaletteEntry entry, Collection<? extends ToolEntry> toolEntries, boolean visibility) {
        for (ToolEntry toolEntry : toolEntries) {
            if (!entry.getId().equals(PaletteManagerImpl.getToolEntryId(toolEntry))) continue;
            entry.setVisible(visibility);
        }
    }

    private static String getToolSectionId(ToolSection toolSection) {
        return new IdentifiedElementQuery((IdentifiedElement)toolSection).getLabel();
    }

    private static String getToolEntryId(ToolEntry entry) {
        return EcoreUtil.getURI((EObject)entry).toString();
    }

    private void addDefaultTools(Diagram diagram) {
        PaletteContainer container = this.paletteRoot.getDefaultEntry().getParent();
        for (Object entry : container.getChildren()) {
            if (!(entry instanceof PaletteSeparator) || !"defaultTools".equals(((PaletteSeparator)entry).getId())) continue;
            return;
        }
        PaletteSeparator marker = new PaletteSeparator("defaultTools");
        marker.setVisible(false);
        container.add((PaletteEntry)marker);
        for (ToolEntry defaultEntry : PaletteManagerImpl.getDefaultTools(TransactionUtil.getEditingDomain((EObject)diagram).getResourceSet())) {
            this.addElementToContainer(container, defaultEntry);
        }
    }

    private static List<ToolEntry> getDefaultTools(ResourceSet context) {
        Resource coreEnvResource = context.getResource(URI.createURI((String)"environment:/viewpoint", (boolean)true), true);
        Environment coreEnv = (Environment)coreEnvResource.getContents().get(0);
        Resource diagramEnvResource = context.getResource(URI.createURI((String)"environment:/diagram", (boolean)true), true);
        Environment diagramEnv = (Environment)diagramEnvResource.getContents().get(0);
        ArrayList defaultTools = Lists.newArrayList();
        defaultTools.addAll(coreEnv.getDefaultTools());
        defaultTools.addAll(diagramEnv.getDefaultTools());
        return defaultTools;
    }

    private static PaletteContainer createPaletteDrawner(ToolSection section) {
        ImageDescriptor descIcon;
        String name = MessageTranslator.INSTANCE.getMessage((EObject)section, new IdentifiedElementQuery((IdentifiedElement)section).getLabel());
        String iconPath = section.getIcon();
        SectionPaletteDrawer paletteDrawner = new SectionPaletteDrawer(name);
        paletteDrawner.setId(PaletteManagerImpl.getToolSectionId(section));
        if (StringUtil.isEmpty((String)iconPath)) {
            iconPath = "icons/obj16/ToolSection.gif";
        }
        if ((descIcon = DiagramUIPlugin.Implementation.findImageDescriptor(iconPath)) != null) {
            paletteDrawner.setSmallIcon(descIcon);
        }
        return paletteDrawner;
    }

    private void clearFilters(Diagram diagram) {
        this.listenersManager.init(diagram);
        ArrayList filtersCopy = Lists.newArrayList(this.filters);
        for (ToolFilter filter : filtersCopy) {
            if (!(filter instanceof ToolFilterFromDescription)) continue;
            this.removeToolFilter(filter);
        }
    }

    protected void updateFilters(Session session, List<? extends ToolEntry> toolEntries) {
        IInterpreter interpreter;
        if (session != null && (interpreter = session.getInterpreter()) != null) {
            for (ToolEntry toolEntry : toolEntries) {
                if (toolEntry instanceof AbstractToolDescription) {
                    for (ToolFilterDescription filterDescription : ((AbstractToolDescription)toolEntry).getFilters()) {
                        ToolFilterFromDescription filter = new ToolFilterFromDescription(interpreter, filterDescription);
                        this.addToolFilter(filter);
                    }
                    this.listenersManager.addListenersForFilters(interpreter, (Collection<ToolFilterDescription>)((AbstractToolDescription)toolEntry).getFilters());
                    continue;
                }
                if (!(toolEntry instanceof ToolGroup)) continue;
                this.updateFilters(session, (List<? extends ToolEntry>)new DiagramComponentizationManager().getTools(session.getSelectedViewpoints(false), (ToolGroup)toolEntry));
            }
        }
    }

    protected void updateContainer(Session session, DDiagram diagram, PaletteContainer container, List<? extends ToolEntry> toolEntries) {
        for (ToolEntry toolEntry : toolEntries) {
            if (toolEntry instanceof AbstractToolDescription) {
                AbstractToolDescription toolDescription = (AbstractToolDescription)toolEntry;
                Option<PaletteEntry> paletteEntry = this.getPaletteEntry(container, new IdentifiedElementQuery((IdentifiedElement)toolEntry).getLabel(), PaletteEntry.class);
                if (!paletteEntry.some()) {
                    paletteEntry = this.getPaletteEntry(container, PaletteManagerImpl.getToolEntryId(toolEntry), PaletteEntry.class);
                }
                if (!this.isFiltered(diagram, toolDescription)) {
                    this.addElementToContainer(container, toolEntry, paletteEntry);
                    continue;
                }
                container.remove((PaletteEntry)paletteEntry.get());
                continue;
            }
            if (!(toolEntry instanceof ToolGroup)) continue;
            Option paletteStack = this.getPaletteEntry(container, PaletteManagerImpl.getToolEntryId(toolEntry), ToolGroupPaletteStack.class);
            boolean paletteWasCreated = false;
            if (!paletteStack.some()) {
                paletteStack = Options.newSome((Object)new ToolGroupPaletteStack(((ToolGroup)toolEntry).getName()));
                paletteWasCreated = true;
            }
            for (AbstractToolDescription tool : new DiagramComponentizationManager().getTools(session.getSelectedViewpoints(false), (ToolGroup)toolEntry)) {
                Option<PaletteEntry> paletteEntry = this.getPaletteEntry((PaletteContainer)paletteStack.get(), PaletteManagerImpl.getToolEntryId((ToolEntry)tool), PaletteEntry.class);
                if (!this.isFiltered(diagram, tool)) {
                    this.addElementToContainer((PaletteContainer)paletteStack.get(), (ToolEntry)tool, paletteEntry);
                    continue;
                }
                if (!paletteEntry.some()) continue;
                ((ToolGroupPaletteStack)paletteStack.get()).remove((PaletteEntry)paletteEntry.get());
                if (!((ToolGroupPaletteStack)paletteStack.get()).getChildren().isEmpty()) continue;
                container.remove((PaletteEntry)paletteStack.get());
            }
            if (!paletteWasCreated || ((ToolGroupPaletteStack)paletteStack.get()).getChildren().isEmpty()) continue;
            ((ToolGroupPaletteStack)paletteStack.get()).setId(PaletteManagerImpl.getToolEntryId(toolEntry));
            container.add((PaletteEntry)paletteStack.get());
        }
    }

    protected void addElementToContainer(PaletteContainer container, ToolEntry toolEntry) {
        this.addElementToContainer(container, toolEntry, (Option<PaletteEntry>)Options.newNone());
    }

    protected void addElementToContainer(PaletteContainer container, ToolEntry toolEntry, Option<PaletteEntry> existingPaletteEntry) {
        if (toolEntry instanceof ToolGroup) {
            ToolGroupPaletteStack paletteStack;
            String newName = this.isFromDiagramEnvironment(toolEntry) ? MessageTranslator.INSTANCE.getMessage(DiagramPlugin.getPlugin().getBundle(), new IdentifiedElementQuery((IdentifiedElement)toolEntry).getLabel()) : MessageTranslator.INSTANCE.getMessage((EObject)toolEntry, new IdentifiedElementQuery((IdentifiedElement)toolEntry).getLabel());
            if (!existingPaletteEntry.some()) {
                paletteStack = new ToolGroupPaletteStack(newName);
                paletteStack.setId(PaletteManagerImpl.getToolEntryId(toolEntry));
                container.add((PaletteEntry)paletteStack);
            } else if (existingPaletteEntry.get() instanceof PaletteStack) {
                paletteStack = (PaletteStack)existingPaletteEntry.get();
            } else {
                throw new IllegalArgumentException(MessageFormat.format(Messages.PaletteManagerImpl_alreadyExistingEntry, newName));
            }
            for (AbstractToolDescription tool : ((ToolGroup)toolEntry).getTools()) {
                Option<PaletteEntry> paletteEntry = this.getPaletteEntry((PaletteContainer)paletteStack, new IdentifiedElementQuery((IdentifiedElement)tool).getLabel(), PaletteEntry.class);
                this.addElementToContainer((PaletteContainer)paletteStack, (ToolEntry)tool, paletteEntry);
            }
        } else if (toolEntry instanceof AbstractToolDescription && !existingPaletteEntry.some()) {
            String descriptionEntry;
            String nameEntry;
            AbstractToolDescription toolDescription = (AbstractToolDescription)toolEntry;
            ImageDescriptor imageEntry = paletteImageProvider.getImageDescriptor(toolDescription);
            if (this.isFromDiagramEnvironment((ToolEntry)toolDescription)) {
                nameEntry = MessageTranslator.INSTANCE.getMessage(DiagramPlugin.getPlugin().getBundle(), new IdentifiedElementQuery((IdentifiedElement)toolDescription).getLabel());
                descriptionEntry = MessageTranslator.INSTANCE.getMessage(DiagramPlugin.getPlugin().getBundle(), toolDescription.getDocumentation());
            } else {
                nameEntry = MessageTranslator.INSTANCE.getMessage((EObject)toolDescription, new IdentifiedElementQuery((IdentifiedElement)toolDescription).getLabel());
                descriptionEntry = toolDescription.getDocumentation();
            }
            PaletteToolBasedCreationFactory creationFactory = new PaletteToolBasedCreationFactory(toolDescription);
            ConnectionCreationToolEntry paletteEntry = null;
            if (toolDescription instanceof EdgeCreationDescription) {
                paletteEntry = new ConnectionCreationToolEntry(nameEntry, descriptionEntry, (CreationFactory)creationFactory, imageEntry, imageEntry);
                paletteEntry.setToolClass(ConnectionCreationTool.class);
                paletteEntry.setId(nameEntry);
            } else if (this.requiresPaletteToolEntry(toolDescription)) {
                paletteEntry = this.createPaletteToolEntry(nameEntry, descriptionEntry, creationFactory, imageEntry);
            }
            if (paletteEntry != null) {
                paletteEntry.setId(PaletteManagerImpl.getToolEntryId((ToolEntry)toolDescription));
                container.add((PaletteEntry)paletteEntry);
            }
        }
    }

    private boolean isFromDiagramEnvironment(ToolEntry toolEntry) {
        URI uri;
        boolean result = false;
        Resource eResource = toolEntry.eResource();
        if (eResource != null && (uri = eResource.getURI()) != null) {
            result = uri.toString().equals("environment:/diagram");
        }
        return result;
    }

    private boolean requiresPaletteToolEntry(AbstractToolDescription toolDescription) {
        boolean result = false;
        if (toolDescription instanceof NodeCreationDescription) {
            result = true;
        } else if (toolDescription instanceof ContainerCreationDescription) {
            result = true;
        } else if (toolDescription instanceof RequestDescription) {
            result = true;
        } else if (toolDescription instanceof SelectionWizardDescription) {
            result = true;
        } else if (toolDescription instanceof PaneBasedSelectionWizardDescription) {
            result = true;
        } else if (toolDescription instanceof ToolDescription) {
            result = true;
        }
        return result;
    }

    private PaletteToolEntry createPaletteToolEntry(String nameEntry, String descriptionEntry, CreationFactory creationFactory, ImageDescriptor imageEntry) {
        CreationToolPaletteFactory paletteFactory = new CreationToolPaletteFactory(creationFactory);
        PaletteToolEntry creationToolEntry = new PaletteToolEntry(nameEntry, descriptionEntry, (PaletteFactory)paletteFactory);
        creationToolEntry.setLabel(nameEntry);
        creationToolEntry.setDescription(descriptionEntry);
        creationToolEntry.setSmallIcon(imageEntry);
        creationToolEntry.setLargeIcon(imageEntry);
        creationToolEntry.setToolProperty(CreationTool.PROPERTY_CREATION_FACTORY, (Object)creationFactory);
        creationToolEntry.setToolClass(CreationTool.class);
        return creationToolEntry;
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    private static class PaletteGroup
    extends org.eclipse.gef.palette.PaletteGroup {
        PaletteGroup(String id, String label) {
            super(label);
            this.setId(id);
        }
    }

    private static class PaletteToolBasedCreationFactory
    implements CreationFactory {
        private AbstractToolDescription toolDescription;

        PaletteToolBasedCreationFactory(AbstractToolDescription toolDescription) {
            this.toolDescription = toolDescription;
        }

        public Object getObjectType() {
            return this.toolDescription.getClass();
        }

        public Object getNewObject() {
            return this.toolDescription;
        }
    }
}

