/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.internal.queries;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class BundledImageExtensionQuery {
    private static final String BUNDLED_IMAGE_SHAPE_EXTENSION_POINT = "org.eclipse.sirius.diagram.bundledImageShape";
    private static final String LABEL_ATTRIBUTE = "label";
    private static final String IMAGE_PATH_ATTRIBUTE = "imagePath";
    private IConfigurationElement[] extensions;

    public BundledImageExtensionQuery() {
        this.getExtensions();
    }

    public IConfigurationElement[] getExtensions() {
        if (this.extensions == null) {
            this.extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(BUNDLED_IMAGE_SHAPE_EXTENSION_POINT);
        }
        return this.extensions;
    }

    public String getLabel(IConfigurationElement extension) {
        return extension.getAttribute(LABEL_ATTRIBUTE);
    }

    public String getImagePath(IConfigurationElement extension) {
        return extension.getAttribute(IMAGE_PATH_ATTRIBUTE);
    }

    public String getIdentifier(IConfigurationElement extension) {
        return ((ExtensionHandle)extension.getParent()).getUniqueIdentifier();
    }

    public List<String> getExtendedLabelsForVSM() {
        ArrayList labels = Lists.newArrayList();
        IConfigurationElement[] iConfigurationElementArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            labels.add(this.getExtendedLabelForVSM(configurationElement));
            ++n2;
        }
        return labels;
    }

    public String getExtendedLabelForVSM(String providedShapeID) {
        IConfigurationElement[] iConfigurationElementArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String identifier = ((ExtensionHandle)configurationElement.getParent()).getUniqueIdentifier();
            if (identifier != null && identifier.equals(providedShapeID)) {
                return this.getExtendedLabelForVSM(configurationElement);
            }
            ++n2;
        }
        return "Unknown ID";
    }

    private String getExtendedLabelForVSM(IConfigurationElement configurationElement) {
        return String.valueOf(configurationElement.getAttribute(LABEL_ATTRIBUTE)) + " - " + configurationElement.getNamespaceIdentifier();
    }

    public IConfigurationElement getExtensionDefiningProvidedShapeID(String providedShapeID) {
        IConfigurationElement[] iConfigurationElementArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String identifier = ((ExtensionHandle)configurationElement.getParent()).getUniqueIdentifier();
            if (identifier != null && identifier.equals(providedShapeID)) {
                return configurationElement;
            }
            ++n2;
        }
        return null;
    }

    public String findParameterInExtension(IConfigurationElement configurationElement, String parameter) {
        if (configurationElement != null) {
            IConfigurationElement[] iConfigurationElementArray = configurationElement.getChildren(parameter);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElementChild = iConfigurationElementArray[n2];
                if (configurationElementChild.getAttribute(parameter) != null) {
                    return configurationElementChild.getAttribute(parameter);
                }
                ++n2;
            }
        }
        return null;
    }
}

