/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.application.e4.fx;

import java.net.URL;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.application.e4.fx.ReferenceServiceFX;
import org.eclipse.emf.ecp.view.model.fx.ECPFXView;
import org.eclipse.emf.ecp.view.model.fx.ECPFXViewRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.common.model.ESModelElementId;
import org.eclipse.emf.emfstore.fx.util.EmfStoreUtil;

public class EditorPart {
    public static final String INPUT = "ecpEditorInput";
    private static final String MODEL_ELEMENT_ID_PERSIST_KEY = "modelElementId";
    private static final String PROJECT_ID_PERSIST_KEY = "projectId";
    private final MPart part;
    private final BorderPane parent;
    private EObject modelElement;
    private Adapter adapter;

    @Inject
    public EditorPart(BorderPane parent, MPart mPart) {
        this.parent = parent;
        this.part = mPart;
        if (this.part.getContext().get(INPUT) == null) {
            this.restorePersistedState();
            this.render();
        }
    }

    @PostConstruct
    public void postConstruct() {
    }

    @Inject
    void setSelection(@Optional @Named(value="ecpEditorInput") EObject person) {
        if (person != null) {
            this.modelElement = person;
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    EditorPart.this.updateImageAndText();
                }
            };
            this.modelElement.eAdapters().add((Object)this.adapter);
            this.persistState();
            this.render();
        }
    }

    private void render() {
        if (this.modelElement != null) {
            ReferenceServiceFX referenceService = new ReferenceServiceFX();
            ECPFXView ecpfxView = ECPFXViewRenderer.INSTANCE.render(this.modelElement, new ViewModelService[]{referenceService});
            this.parent.setCenter(ecpfxView.getFXNode());
            this.updateImageAndText();
        }
    }

    private void restorePersistedState() {
        String projectId = (String)this.part.getPersistedState().get(PROJECT_ID_PERSIST_KEY);
        ESLocalProject project = EmfStoreUtil.getLocalProjectForId((String)projectId);
        if (project != null) {
            String modelElementId = (String)this.part.getPersistedState().get(MODEL_ELEMENT_ID_PERSIST_KEY);
            this.modelElement = EmfStoreUtil.getModelObjectForId((ESLocalProject)project, (String)modelElementId);
            if (this.modelElement != null) {
                this.part.getContext().set(INPUT, (Object)this.modelElement);
            }
        }
    }

    @PreDestroy
    void dispose() {
        if (this.modelElement != null) {
            this.modelElement.eAdapters().remove((Object)this.adapter);
        }
    }

    void persistState() {
        ESLocalProject project = ESWorkspaceProvider.INSTANCE.getWorkspace().getLocalProject(this.modelElement);
        String modelElementId = ((ESModelElementId)project.getModelElementId(this.modelElement)).getId();
        String projectId = project.getLocalProjectId().getId();
        this.part.getPersistedState().put(MODEL_ELEMENT_ID_PERSIST_KEY, modelElementId);
        this.part.getPersistedState().put(PROJECT_ID_PERSIST_KEY, projectId);
    }

    private void updateImageAndText() {
        Object uri;
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)composedAdapterFactory.adapt((Notifier)this.modelElement, IItemLabelProvider.class);
        composedAdapterFactory.dispose();
        this.part.setLabel(itemLabelProvider.getText((Object)this.modelElement));
        this.part.setTooltip(itemLabelProvider.getText((Object)this.modelElement));
        Object image = itemLabelProvider.getImage((Object)this.modelElement);
        String iconUri = null;
        if (ComposedImage.class.isInstance(image)) {
            ComposedImage composedImage = (ComposedImage)image;
            image = composedImage.getImages().get(0);
        }
        if (URI.class.isInstance(image)) {
            uri = (URI)image;
            iconUri = uri.toString();
        }
        if (URL.class.isInstance(image)) {
            uri = (URL)image;
            iconUri = ((URL)uri).toString();
        }
        this.part.setIconURI(iconUri);
    }

    @Focus
    public void onFocus() {
    }
}

