/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import java.net.URL;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.swt.reference.DeleteReferenceAction;
import org.eclipse.emf.ecp.edit.spi.swt.reference.NewReferenceAction;
import org.eclipse.emf.ecp.edit.spi.util.ECPModelElementChangeListener;
import org.eclipse.emf.ecp.view.internal.editor.controls.Activator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class TableDetailViewControlSWTRenderer
extends SimpleControlSWTControlSWTRenderer {
    private final EMFFormsEditSupport emfFormsEditSupport;
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryItemDelegator adapterFactoryItemDelegator;
    private Label label;
    private Label imageLabel;
    private ECPModelElementChangeListener modelElementChangeListener;
    private Composite labelComposite;

    @Inject
    public TableDetailViewControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.emfFormsEditSupport = emfFormsEditSupport;
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        Binding[] bindings = new Binding[3];
        ISWTObservableValue value = WidgetProperties.text().observe((Widget)this.label);
        bindings[0] = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), this.withPreSetValidation(new UpdateValueStrategy(){

            public Object convert(Object value) {
                try {
                    return TableDetailViewControlSWTRenderer.this.getModelValue().getValue();
                }
                catch (DatabindingFailedException ex) {
                    Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return null;
                }
            }
        }), new UpdateValueStrategy(){

            public Object convert(Object value) {
                return TableDetailViewControlSWTRenderer.this.getText(value);
            }
        });
        ISWTObservableValue tooltipValue = WidgetProperties.tooltipText().observe((Widget)this.label);
        bindings[1] = this.getDataBindingContext().bindValue((IObservableValue)tooltipValue, this.getModelValue(), this.withPreSetValidation(new UpdateValueStrategy(){

            public Object convert(Object value) {
                try {
                    return TableDetailViewControlSWTRenderer.this.getModelValue().getValue();
                }
                catch (DatabindingFailedException ex) {
                    Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return null;
                }
            }
        }), new UpdateValueStrategy(){

            public Object convert(Object value) {
                return TableDetailViewControlSWTRenderer.this.getText(value);
            }
        });
        ISWTObservableValue imageValue = WidgetProperties.image().observe((Widget)this.imageLabel);
        bindings[2] = this.getDataBindingContext().bindValue((IObservableValue)imageValue, this.getModelValue(), this.withPreSetValidation(new UpdateValueStrategy(){

            public Object convert(Object value) {
                try {
                    return TableDetailViewControlSWTRenderer.this.getModelValue().getValue();
                }
                catch (DatabindingFailedException ex) {
                    Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return null;
                }
            }
        }), new UpdateValueStrategy(){

            public Object convert(Object value) {
                return TableDetailViewControlSWTRenderer.this.getImage(value);
            }
        });
        return bindings;
    }

    private Object getText(Object value) {
        String textName = this.adapterFactoryItemDelegator.getText(value);
        return textName == null ? "" : textName;
    }

    private Object getImage(Object value) {
        if (value == null) {
            return null;
        }
        return Activator.getImage((URL)this.adapterFactoryItemDelegator.getImage(value));
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        IObservableValue observableValue = Activator.getDefault().getEMFFormsDatabinding().getObservableValue(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        final EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        final EObject eObject = (EObject)((IObserving)observableValue).getObserved();
        observableValue.dispose();
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).spacing(0, 0).applyTo(composite);
        this.labelComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.labelComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.labelComposite);
        this.labelComposite.setBackground(composite.getBackground());
        this.imageLabel = new Label(this.labelComposite, 0);
        this.imageLabel.setBackground(this.labelComposite.getBackground());
        GridDataFactory.fillDefaults().grab(false, false).align(4, 1).hint(20, 20).applyTo((Control)this.imageLabel);
        this.label = new Label(this.labelComposite, 0);
        this.label.setBackground(this.labelComposite.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.label);
        Composite buttonComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 1).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).spacing(2, 0).applyTo(buttonComposite);
        Button deleteButton = this.createButtonForAction((Action)new DeleteReferenceAction(this.getEditingDomain(eObject), eObject, structuralFeature, null), buttonComposite);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Command setCommand = SetCommand.create((EditingDomain)TableDetailViewControlSWTRenderer.this.getEditingDomain(eObject), (Object)eObject, (Object)structuralFeature, null);
                TableDetailViewControlSWTRenderer.this.getEditingDomain(eObject).getCommandStack().execute(setCommand);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button createButton = this.createButtonForAction((Action)new NewReferenceAction(this.getEditingDomain(eObject), eObject, structuralFeature, this.emfFormsEditSupport, this.getEMFFormsLabelProvider(), null, this.getReportService(), ((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel()), buttonComposite);
        createButton.addSelectionListener((SelectionListener)new CreateNewElementHandler(eObject, structuralFeature));
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
        return composite;
    }

    private Button createButtonForAction(Action action, Composite composite) {
        Button selectButton = new Button(composite, 8);
        selectButton.setImage(Activator.getImage(action));
        selectButton.setEnabled(true);
        selectButton.setToolTipText(action.getToolTipText());
        return selectButton;
    }

    protected void dispose() {
        this.composedAdapterFactory.dispose();
        this.composedAdapterFactory = null;
        this.adapterFactoryItemDelegator = null;
        if (this.modelElementChangeListener != null) {
            this.modelElementChangeListener.remove();
        }
        super.dispose();
    }

    protected String getUnsetText() {
        return "";
    }

    private final class CreateNewElementHandler
    implements SelectionListener {
        private final EObject eObject;
        private final EStructuralFeature structuralFeature;

        private CreateNewElementHandler(EObject eObject, EStructuralFeature structuralFeature) {
            this.eObject = eObject;
            this.structuralFeature = structuralFeature;
        }

        public void widgetSelected(SelectionEvent e) {
            VView detailView = VViewFactory.eINSTANCE.createView();
            VTableControl tableControl = (VTableControl)this.eObject;
            if (tableControl.getDomainModelReference() == null) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Set Domain Model Reference", (String)"Please set a Domain Model Reference first.");
                return;
            }
            VTableDomainModelReference domainModelReference = (VTableDomainModelReference)tableControl.getDomainModelReference();
            EReference ref = null;
            if (domainModelReference.getDomainModelReference() == null) {
                ref = (EReference)domainModelReference.getDomainModelEFeature();
            } else {
                IValueProperty valueProperty;
                try {
                    valueProperty = Activator.getDefault().getEMFFormsDatabinding().getValueProperty((VDomainModelReference)domainModelReference, TableDetailViewControlSWTRenderer.this.getViewModelContext().getDomainModel());
                }
                catch (DatabindingFailedException ex) {
                    Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                    return;
                }
                EStructuralFeature feature = (EStructuralFeature)valueProperty.getValueType();
                if (EReference.class.isInstance(feature)) {
                    ref = (EReference)EReference.class.cast(feature);
                }
            }
            if (ref == null) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Set Domain Model Reference", (String)"Please set a Domain Model Reference first.");
                return;
            }
            detailView.setRootEClass(ref.getEReferenceType());
            Command setCommand = SetCommand.create((EditingDomain)TableDetailViewControlSWTRenderer.this.getEditingDomain(this.eObject), (Object)this.eObject, (Object)this.structuralFeature, (Object)detailView);
            TableDetailViewControlSWTRenderer.this.getEditingDomain(this.eObject).getCommandStack().execute(setCommand);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

