/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core.di;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererService;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsContextProvider;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;

public class EMFFormsDIRendererFactory
implements EMFFormsRendererService<VElement> {
    private ReportService reportService;
    private final Set<EMFFormsDIRendererService<VElement>> diRendererServices = new LinkedHashSet<EMFFormsDIRendererService<VElement>>();

    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    protected ReportService getReportService() {
        return this.reportService;
    }

    protected void addEMFFormsDIRendererService(EMFFormsDIRendererService<VElement> diRendererService) {
        this.diRendererServices.add(diRendererService);
    }

    protected void removeEMFFormsDIRendererService(EMFFormsDIRendererService<VElement> diRendererService) {
        this.diRendererServices.remove(diRendererService);
    }

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        double highestPriority = Double.MIN_VALUE;
        EMFFormsDIRendererService bestRendererService = null;
        LinkedHashSet<EMFFormsDIRendererService<VElement>> rendererServicesCopy = new LinkedHashSet<EMFFormsDIRendererService<VElement>>(this.diRendererServices);
        for (EMFFormsDIRendererService eMFFormsDIRendererService : rendererServicesCopy) {
            double isCurrentApplicable = eMFFormsDIRendererService.isApplicable(vElement, viewModelContext);
            if (Double.isNaN(isCurrentApplicable) || !(isCurrentApplicable > highestPriority)) continue;
            highestPriority = isCurrentApplicable;
            bestRendererService = eMFFormsDIRendererService;
        }
        if (bestRendererService != null) {
            return highestPriority;
        }
        return Double.NaN;
    }

    public AbstractSWTRenderer<VElement> getRendererInstance(VElement vElement, ViewModelContext viewModelContext) {
        AbstractSWTRenderer rendererInstance;
        Class<?>[] elementInterfaces;
        double highestPriority = Double.MIN_VALUE;
        EMFFormsDIRendererService bestRendererService = null;
        LinkedHashSet<EMFFormsDIRendererService<VElement>> rendererServicesCopy = new LinkedHashSet<EMFFormsDIRendererService<VElement>>(this.diRendererServices);
        for (EMFFormsDIRendererService eMFFormsDIRendererService : rendererServicesCopy) {
            double isCurrentApplicable = eMFFormsDIRendererService.isApplicable(vElement, viewModelContext);
            if (Double.isNaN(isCurrentApplicable) || !(isCurrentApplicable > highestPriority)) continue;
            highestPriority = isCurrentApplicable;
            bestRendererService = eMFFormsDIRendererService;
        }
        if (bestRendererService == null) {
            return null;
        }
        EMFFormsContextProvider eMFFormsContextProvider = (EMFFormsContextProvider)viewModelContext.getService(EMFFormsContextProvider.class);
        if (eMFFormsContextProvider == null) {
            this.reportService.report(new AbstractReport("The given ViewModelContext does not have a EMFFormsContextProvider. Hence, no renderer instance can be created."));
            return null;
        }
        IEclipseContext eclipseContext = eMFFormsContextProvider.getContext();
        IEclipseContext childContext = eclipseContext.createChild();
        childContext.set(ViewModelContext.class, (Object)viewModelContext);
        childContext.set(VElement.class, (Object)vElement);
        Class<?> elementClass = vElement.getClass();
        Class<?>[] classArray = elementInterfaces = elementClass.getInterfaces();
        int n = elementInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> elementInterface = classArray[n2];
            if (VElement.class.isAssignableFrom(elementInterface)) {
                childContext.set(elementInterface, elementInterface.cast(vElement));
            }
            ++n2;
        }
        Class rendererClass = bestRendererService.getRendererClass();
        try {
            rendererInstance = (AbstractSWTRenderer)ContextInjectionFactory.make(rendererClass, (IEclipseContext)childContext);
        }
        catch (InjectionException ex) {
            this.reportService.report(new AbstractReport((Throwable)ex));
            return null;
        }
        return rendererInstance;
    }
}

