/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.core.swt.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffect;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.IEMFObservable;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.EMFUtils;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlJFaceViewerSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class EnumComboViewerSWTRenderer
extends SimpleControlJFaceViewerSWTRenderer {
    private final EMFFormsEditSupport emfFormsEditSupport;
    private IObservableValue<Collection<?>> availableChoicesValue;
    private ISideEffect pushValue;

    @Inject
    public EnumComboViewerSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.emfFormsEditSupport = emfFormsEditSupport;
    }

    @Override
    protected Binding[] createBindings(Viewer viewer) throws DatabindingFailedException {
        IViewerObservableValue viewerInput = ViewerProperties.input().observe(viewer);
        Binding inputBinding = this.getDataBindingContext().bindValue((IObservableValue)viewerInput, this.getAvailableChoicesValue());
        IObservableValue modelValue = this.getModelValue();
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)viewer), modelValue);
        this.pushValue = ISideEffect.create(() -> ((IObservableValue)viewerInput).getValue(), input -> {
            if (input != null) {
                binding.updateModelToTarget();
            }
        });
        Binding tooltipBinding = this.getDataBindingContext().bindValue((IObservableValue)WidgetProperties.tooltipText().observe((Widget)viewer.getControl()), this.getModelValue());
        return new Binding[]{inputBinding, binding, tooltipBinding};
    }

    protected ComboViewer createComboViewer(Composite parent, EEnum eEnum) {
        return new ComboViewer(parent);
    }

    @Override
    protected Viewer createJFaceViewer(Composite parent) throws DatabindingFailedException {
        IValueProperty valueProperty = this.getEMFFormsDatabinding().getValueProperty(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        EEnum eEnum = (EEnum)EEnum.class.cast(structuralFeature.getEType());
        ComboViewer combo = this.createComboViewer(parent, eEnum);
        combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        combo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return EnumComboViewerSWTRenderer.this.getEMFFormsEditSupport().getText(((VControl)EnumComboViewerSWTRenderer.this.getVElement()).getDomainModelReference(), EnumComboViewerSWTRenderer.this.getViewModelContext().getDomainModel(), element);
            }
        });
        combo.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_enum");
        return combo;
    }

    public List<EEnumLiteral> getELiterals(EEnum eEnum) {
        ArrayList<EEnumLiteral> filtered = new ArrayList<EEnumLiteral>();
        EList eLiterals = eEnum.getELiterals();
        for (EEnumLiteral literal : eLiterals) {
            String isInputtable = EcoreUtil.getAnnotation((EModelElement)literal, (String)"http://org/eclipse/emf/ecp/view/model/170", (String)"isInputtable");
            if (isInputtable != null && !Boolean.getBoolean(isInputtable)) continue;
            filtered.add(literal);
        }
        return filtered;
    }

    protected IObservableValue<Collection<?>> getAvailableChoicesValue() throws DatabindingFailedException {
        if (this.availableChoicesValue == null) {
            IEMFObservable emfObservable = (IEMFObservable)this.getModelValue();
            final EObject domainObject = (EObject)emfObservable.getObserved();
            final EStructuralFeature feature = emfObservable.getStructuralFeature();
            Optional propertySource = EMFUtils.adapt((EObject)domainObject, IItemPropertySource.class);
            final Optional<IItemPropertyDescriptor> propertyDescriptor = propertySource.map(source -> source.getPropertyDescriptor((Object)domainObject, (Object)feature));
            this.availableChoicesValue = new ComputedValue<Collection<?>>(Collection.class, propertySource){
                private final Optional<IChangeNotifier> changeNotifier;
                private final INotifyChangedListener listener;
                {
                    super($anonymous0);
                    this.changeNotifier = optional.filter(IChangeNotifier.class::isInstance).map(IChangeNotifier.class::cast);
                    this.listener = __ -> this.getRealm().exec(() -> (this).makeDirty());
                    this.changeNotifier.ifPresent(cn -> cn.addListener(this.listener));
                }

                public synchronized void dispose() {
                    this.changeNotifier.ifPresent(cn -> cn.removeListener(this.listener));
                    super.dispose();
                }

                protected Collection<?> calculate() {
                    List<EEnumLiteral> allLiterals = EnumComboViewerSWTRenderer.this.getELiterals((EEnum)feature.getEType());
                    List filteredByAnnotation = allLiterals.stream().map(EEnumLiteral::getInstance).collect(Collectors.toList());
                    if (propertyDescriptor.isPresent()) {
                        filteredByAnnotation.retainAll(((IItemPropertyDescriptor)propertyDescriptor.get()).getChoiceOfValues((Object)domainObject));
                    }
                    return filteredByAnnotation;
                }
            };
        }
        return this.availableChoicesValue;
    }

    @Override
    protected void rootDomainModelChanged() throws DatabindingFailedException {
        if (this.availableChoicesValue != null) {
            this.availableChoicesValue.dispose();
        }
        this.availableChoicesValue = null;
        super.rootDomainModelChanged();
    }

    @Override
    protected void dispose() {
        super.dispose();
        if (this.pushValue != null) {
            this.pushValue.dispose();
        }
    }

    @Override
    protected String getUnsetText() {
        return LocalizationServiceHelper.getString(((Object)((Object)this)).getClass(), (String)"EEnumControl_NoValueSetClickToSetValue");
    }

    protected EMFFormsEditSupport getEMFFormsEditSupport() {
        return this.emfFormsEditSupport;
    }
}

