/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ConcurrentLinkedSetQueue<E>
extends ConcurrentLinkedQueue<E> {
    private static final long serialVersionUID = 290189755090394151L;
    private final Set<Object> concurrentSet = Collections.newSetFromMap(new ConcurrentHashMap());

    @Override
    public void clear() {
        super.clear();
        this.concurrentSet.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = super.removeAll(c);
        this.concurrentSet.removeAll(c);
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = super.retainAll(c);
        this.concurrentSet.retainAll(c);
        return result;
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (!this.concurrentSet.contains(e)) {
            this.concurrentSet.add(e);
            return super.offer(e);
        }
        return false;
    }

    @Override
    public E poll() {
        Object next = super.poll();
        if (next != null) {
            this.concurrentSet.remove(next);
        }
        return next;
    }

    @Override
    public boolean remove(Object o) {
        if (o != null) {
            this.concurrentSet.remove(o);
        }
        return super.remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ArrayList<E> newColl = new ArrayList<E>(c);
        newColl.removeAll(this.concurrentSet);
        this.concurrentSet.addAll(newColl);
        return super.addAll(newColl);
    }

    @Override
    public Iterator<E> iterator() {
        Iterator iter = super.iterator();
        return new IterWithRemove(iter);
    }

    private class IterWithRemove<I>
    implements Iterator<I> {
        private final Iterator<I> delegate;
        private I lastReturnedElement;

        IterWithRemove(Iterator<I> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public I next() {
            if (this.delegate.hasNext()) {
                this.lastReturnedElement = this.delegate.next();
                return this.lastReturnedElement;
            }
            this.lastReturnedElement = null;
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastReturnedElement != null) {
                ConcurrentLinkedSetQueue.this.concurrentSet.remove(this.lastReturnedElement);
                this.lastReturnedElement = null;
            }
            this.delegate.remove();
        }
    }
}

