/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.common;

import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecp.view.internal.model.common.Activator;
import org.eclipse.emf.ecp.view.model.common.ECPRendererTester;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;

public class XMLDateControlRendererTester
implements ECPRendererTester {
    private static final String XML_TYPE_DATE = "http://www.eclipse.org/emf/2003/XMLType#date";
    private static final String BASE_TYPE = "baseType";
    private static final String TYPE_DATE = "date";
    private static final String TYPE_NAME = "name";
    private static final String EXTENDED_META_DATA = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";

    @Override
    public int isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        IValueProperty valueProperty;
        if (!VControl.class.isInstance(vElement)) {
            return -1;
        }
        VControl control = (VControl)vElement;
        if (control.getDomainModelReference() == null) {
            return -1;
        }
        try {
            valueProperty = Activator.getDefault().getEMFFormsDatabinding().getValueProperty(control.getDomainModelReference(), viewModelContext.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return -1;
        }
        EStructuralFeature feature = (EStructuralFeature)valueProperty.getValueType();
        if (!this.isSingleAttribute(feature)) {
            return -1;
        }
        EDataType eAttributeType = ((EAttribute)EAttribute.class.cast(feature)).getEAttributeType();
        if (eAttributeType == XMLTypePackage.eINSTANCE.getDate()) {
            return this.getPriority();
        }
        Class instanceClass = eAttributeType.getInstanceClass();
        if (instanceClass == null || !this.getSupportedClassType().isAssignableFrom(instanceClass)) {
            return -1;
        }
        if (this.checkFeatureETypeAnnotations((EList<EAnnotation>)feature.getEType().getEAnnotations())) {
            return this.getPriority();
        }
        return -1;
    }

    private boolean isSingleAttribute(EStructuralFeature feature) {
        if (feature.isMany()) {
            return false;
        }
        return !EReference.class.isInstance(feature);
    }

    private int getPriority() {
        return 3;
    }

    private Class<?> getSupportedClassType() {
        return XMLGregorianCalendar.class;
    }

    private boolean checkFeatureETypeAnnotations(EList<EAnnotation> eAnnotations) {
        for (EAnnotation annotation : eAnnotations) {
            if (!annotation.getSource().equals(EXTENDED_META_DATA)) continue;
            if (annotation.getDetails().containsKey((Object)TYPE_NAME) && ((String)annotation.getDetails().get((Object)TYPE_NAME)).equals(TYPE_DATE)) {
                return true;
            }
            if (!annotation.getDetails().containsKey((Object)BASE_TYPE) || !((String)annotation.getDetails().get((Object)BASE_TYPE)).equals(XML_TYPE_DATE)) continue;
            return true;
        }
        return false;
    }
}

