/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.treemasterdetail.ui.swt;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.ChildrenDescriptorCollector;
import org.eclipse.emf.ecp.edit.internal.swt.util.OverlayImageDescriptor;
import org.eclipse.emf.ecp.edit.spi.ConditionalDeleteService;
import org.eclipse.emf.ecp.edit.spi.DeleteService;
import org.eclipse.emf.ecp.edit.spi.EMFDeleteServiceImpl;
import org.eclipse.emf.ecp.edit.spi.ReferenceService;
import org.eclipse.emf.ecp.edit.spi.swt.util.SWTValidationHelper;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.internal.swt.ContextMenuViewModelService;
import org.eclipse.emf.ecp.view.internal.treemasterdetail.ui.swt.Activator;
import org.eclipse.emf.ecp.view.model.common.edit.provider.CustomReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeAddRemoveListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.masterdetail.DetailViewCache;
import org.eclipse.emf.ecp.view.spi.swt.masterdetail.DetailViewManager;
import org.eclipse.emf.ecp.view.spi.swt.selection.IMasterDetailSelectionProvider;
import org.eclipse.emf.ecp.view.spi.swt.services.ECPSelectionProviderService;
import org.eclipse.emf.ecp.view.spi.treemasterdetail.ui.swt.MasterDetailAction;
import org.eclipse.emf.ecp.view.treemasterdetail.model.VTreeMasterDetail;
import org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.internal.RootObject;
import org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.internal.TreeMasterDetailSelectionManipulatorHelper;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.action.ecp.CreateChildAction;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.osgi.framework.FrameworkUtil;

public class TreeMasterDetailSWTRenderer
extends AbstractSWTRenderer<VTreeMasterDetail> {
    private static final String ENABLE_MULTI_EDIT = "enableMultiEdit";
    public static final String DETAIL_KEY = "detail";
    public static final String GLOBAL_ADDITIONS = "global_additions";
    public static final String ROOT_KEY = "root";
    private SWTGridDescription rendererGridDescription;
    private Font detailsFont;
    private Color titleColor;
    private Font titleFont;
    private Color headerBgColor;
    private TreeViewer treeViewer;
    private ScrolledComposite rightPanel;
    private Composite container;
    private Composite rightPanelContainerComposite;
    private ModelChangeListener domainModelListener;
    private ViewModelContext childContext;
    private DetailViewManager detailManager;

    @Inject
    public TreeMasterDetailSWTRenderer(VTreeMasterDetail vElement, ViewModelContext viewContext, ReportService reportService) {
        super((VElement)vElement, viewContext, reportService);
    }

    protected void dispose() {
        this.rendererGridDescription = null;
        if (this.detailManager != null) {
            this.detailManager.dispose();
        }
        this.childContext = null;
        if (this.getViewModelContext() != null && this.domainModelListener != null) {
            this.getViewModelContext().unregisterDomainChangeListener(this.domainModelListener);
        }
        this.domainModelListener = null;
        if (this.treeViewer != null) {
            this.treeViewer.setInput(null);
        }
        super.dispose();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Composite form = this.createMasterDetailForm(parent);
        this.createHeader(form);
        SashForm sash = this.createSash(form);
        Composite masterPanel = this.createMasterPanel(sash);
        this.createRightPanelContent((Composite)sash);
        sash.setWeights(new int[]{1, 3});
        this.createMasterTree(masterPanel);
        if (this.hasContextMenu()) {
            this.registerControlAsContextMenuReceiver();
        }
        form.layout(true);
        return form;
    }

    private void registerControlAsContextMenuReceiver() {
        if (!this.getViewModelContext().hasService(ContextMenuViewModelService.class)) {
            return;
        }
        ContextMenuViewModelService service = (ContextMenuViewModelService)this.getViewModelContext().getService(ContextMenuViewModelService.class);
        if (service != null) {
            service.setParentControl((Control)this.treeViewer.getTree());
            service.registerContextMenu();
        }
    }

    protected SashForm createSash(Composite parent) {
        Composite sashComposite = new Composite(parent, 4);
        GridLayout sashLayout = GridLayoutFactory.fillDefaults().create();
        sashLayout.marginWidth = 5;
        sashComposite.setLayout((Layout)sashLayout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)sashComposite);
        SashForm sash = new SashForm(sashComposite, 256);
        sash.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo((Composite)sash);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)sash);
        sash.setSashWidth(5);
        return sash;
    }

    protected Composite createMasterDetailForm(Composite parent) {
        Composite form = new Composite(parent, 2048);
        GridLayout layout = GridLayoutFactory.fillDefaults().create();
        form.setLayout((Layout)layout);
        form.setBackgroundMode(2);
        return form;
    }

    protected TreeViewer createMasterTree(Composite masterPanel) {
        EObject modelElement = this.getViewModelContext().getDomainModel();
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)modelElement);
        final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new CustomReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        final AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)adapterFactory){

            public Object[] getElements(Object object) {
                return new Object[]{((RootObject)object).getRoot()};
            }
        };
        final TreeMasterDetailLabelProvider labelProvider = new TreeMasterDetailLabelProvider((AdapterFactory)adapterFactory);
        this.treeViewer = new TreeViewer(masterPanel);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(100, -1).applyTo((Control)this.treeViewer.getTree());
        this.treeViewer.setContentProvider((IContentProvider)adapterFactoryContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider(labelProvider));
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setInput((Object)new RootObject(modelElement));
        this.domainModelListener = new ModelChangeAddRemoveListener(){

            public void notifyChange(ModelChangeNotification notification) {
            }

            public void notifyAdd(Notifier notifier) {
                if (TreeMasterDetailSWTRenderer.this.isRenderingFinished()) {
                    TreeMasterDetailSWTRenderer.this.treeViewer.expandToLevel((Object)notifier, 1);
                }
            }

            public void notifyRemove(Notifier notifier) {
                if (TreeMasterDetailSWTRenderer.this.childContext != null && notifier == TreeMasterDetailSWTRenderer.this.childContext.getDomainModel()) {
                    TreeMasterDetailSWTRenderer.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)TreeMasterDetailSWTRenderer.this.getViewModelContext().getDomainModel()));
                }
            }
        };
        this.getViewModelContext().registerDomainChangeListener(this.domainModelListener);
        if (this.hasDnDSupport()) {
            this.addDragAndDropSupport(modelElement, this.treeViewer, editingDomain);
        }
        final TreeMasterViewSelectionListener treeMasterViewSelectionListener = new TreeMasterViewSelectionListener();
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)treeMasterViewSelectionListener);
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)modelElement));
        if (this.hasContextMenu()) {
            this.fillContextMenu(this.treeViewer, editingDomain);
        }
        this.treeViewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                adapterFactoryContentProvider.dispose();
                labelProvider.dispose();
                adapterFactory.dispose();
                if (TreeMasterDetailSWTRenderer.this.titleFont != null) {
                    TreeMasterDetailSWTRenderer.this.titleFont.dispose();
                }
                if (TreeMasterDetailSWTRenderer.this.detailsFont != null) {
                    TreeMasterDetailSWTRenderer.this.detailsFont.dispose();
                }
                if (TreeMasterDetailSWTRenderer.this.titleColor != null) {
                    TreeMasterDetailSWTRenderer.this.titleColor.dispose();
                }
                if (TreeMasterDetailSWTRenderer.this.headerBgColor != null) {
                    TreeMasterDetailSWTRenderer.this.headerBgColor.dispose();
                }
                TreeMasterDetailSWTRenderer.this.treeViewer.removeSelectionChangedListener((ISelectionChangedListener)treeMasterViewSelectionListener);
            }
        });
        ECPSelectionProviderService sps = (ECPSelectionProviderService)this.getViewModelContext().getService(ECPSelectionProviderService.class);
        IMasterDetailSelectionProvider mdSelectionProvider = sps.createMasterDetailSelectionProvider((Viewer)this.treeViewer, () -> this.rightPanel);
        sps.registerSelectionProvider(this.getVElement(), (ISelectionProvider)mdSelectionProvider);
        return this.treeViewer;
    }

    protected boolean hasContextMenu() {
        return !((VTreeMasterDetail)this.getVElement()).isEffectivelyReadonly();
    }

    protected boolean hasDnDSupport() {
        return !((VTreeMasterDetail)this.getVElement()).isEffectivelyReadonly();
    }

    protected ILabelProvider getLabelProvider(AdapterFactoryLabelProvider adapterFactoryLabelProvider) {
        return adapterFactoryLabelProvider;
    }

    protected Composite createMasterPanel(SashForm sash) {
        Composite leftPanel = new Composite((Composite)sash, 0);
        leftPanel.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)leftPanel);
        leftPanel.setBackgroundMode(2);
        return leftPanel;
    }

    protected void createHeader(Composite parent) {
        Composite headerComposite = new Composite(parent, 0);
        GridLayout headerLayout = GridLayoutFactory.fillDefaults().create();
        headerComposite.setLayout((Layout)headerLayout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)headerComposite);
        this.headerBgColor = new Color((Device)parent.getDisplay(), new RGB(220, 240, 247));
        headerComposite.setBackground(this.headerBgColor);
        EObject modelElement = this.getViewModelContext().getDomainModel();
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)modelElement);
        if (modelElement.eContainer() == null && !DynamicEObjectImpl.class.isInstance(modelElement)) {
            Composite header = this.getPageHeader(headerComposite);
            List<Action> actions = this.readToolbarActions(modelElement, editingDomain);
            ToolBar toolBar = new ToolBar(header, 0x820000);
            FormData formData = new FormData();
            formData.right = new FormAttachment(100, 0);
            toolBar.setLayoutData((Object)formData);
            toolBar.layout();
            ToolBarManager toolBarManager = new ToolBarManager(toolBar);
            for (Action action : actions) {
                toolBarManager.add((IAction)action);
            }
            toolBarManager.update(true);
            header.layout();
        }
    }

    private Composite getPageHeader(Composite parent) {
        Composite header = new Composite(parent, 4);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        header.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)header);
        header.setBackground(parent.getBackground());
        Label titleImage = new Label(header, 4);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/view.png"));
        titleImage.setImage(new Image((Device)parent.getDisplay(), imageDescriptor.getImageData()));
        FormData titleImageData = new FormData();
        int imageOffset = -titleImage.computeSize((int)-1, (int)-1).y / 2;
        titleImageData.top = new FormAttachment(50, imageOffset);
        titleImageData.left = new FormAttachment(0, 10);
        titleImage.setLayoutData((Object)titleImageData);
        Label title = new Label(header, 64);
        title.setText("View Editor");
        this.titleFont = new Font((Device)title.getDisplay(), this.getDefaultFontName((Control)title), 12, 1);
        title.setFont(this.titleFont);
        title.setForeground(this.getTitleColor(parent));
        int titleHeight = title.computeSize((int)-1, (int)-1).y;
        FormData titleData = new FormData();
        titleData.left = new FormAttachment((Control)titleImage, 5, -1);
        titleData.top = new FormAttachment(50, -titleHeight / 2);
        title.setLayoutData((Object)titleData);
        return header;
    }

    private Color getTitleColor(Composite parent) {
        if (this.titleColor == null) {
            this.titleColor = new Color((Device)parent.getDisplay(), new RGB(25, 76, 127));
        }
        return this.titleColor;
    }

    protected ScrolledComposite createRightPanelContent(Composite parent) {
        this.rightPanel = new ScrolledComposite(parent, 768);
        this.rightPanel.setShowFocusedControl(true);
        this.rightPanel.setExpandVertical(true);
        this.rightPanel.setExpandHorizontal(true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.rightPanel);
        this.rightPanel.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.rightPanel.setBackground(parent.getDisplay().getSystemColor(1));
        this.container = new Composite((Composite)this.rightPanel, 4);
        this.container.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.container);
        this.container.setBackground(this.rightPanel.getBackground());
        Composite header = new Composite(this.container, 4);
        GridLayout headerLayout = GridLayoutFactory.fillDefaults().create();
        header.setLayout((Layout)headerLayout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)header);
        header.setBackground(this.rightPanel.getBackground());
        Label label = new Label(header, 64);
        label.setText("Details");
        this.detailsFont = new Font((Device)label.getDisplay(), this.getDefaultFontName((Control)label), 10, 1);
        label.setFont(this.detailsFont);
        label.setForeground(this.getTitleColor(parent));
        label.setBackground(header.getBackground());
        this.rightPanelContainerComposite = new Composite(this.container, 4);
        this.rightPanelContainerComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.rightPanelContainerComposite);
        this.rightPanelContainerComposite.setBackground(this.rightPanel.getBackground());
        this.rightPanel.setContent((Control)this.container);
        this.rightPanel.layout();
        this.container.layout();
        Point point = this.container.computeSize(-1, -1);
        this.rightPanel.setMinSize(point);
        this.detailManager = new DetailViewManager(this.rightPanelContainerComposite);
        this.detailManager.setCache(DetailViewCache.createCache((ViewModelContext)this.getViewModelContext()));
        this.detailManager.layoutDetailParent(this.rightPanelContainerComposite);
        return this.rightPanel;
    }

    protected String getDefaultFontName(Control control) {
        return control.getDisplay().getSystemFont().getFontData()[0].getName();
    }

    private List<Action> readToolbarActions(EObject modelElement, EditingDomain editingDomain) {
        IConfigurationElement[] controls;
        ArrayList<Action> actions = new ArrayList<Action>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return actions;
        }
        if (!VView.class.isInstance(modelElement)) {
            return actions;
        }
        final VView view = (VView)modelElement;
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.masterDetailActions");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String location = e.getAttribute("location");
                if (location.equals("toolbar")) {
                    String label = e.getAttribute("label");
                    String imagePath = e.getAttribute("imagePath");
                    final MasterDetailAction command = (MasterDetailAction)((Object)e.createExecutableExtension("command"));
                    Action newAction = new Action(){

                        public void run() {
                            super.run();
                            command.execute((EObject)view);
                        }
                    };
                    newAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)FrameworkUtil.getBundle(((Object)((Object)command)).getClass()).getResource(imagePath)));
                    newAction.setText(label);
                    actions.add(newAction);
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            ++n2;
        }
        return actions;
    }

    private void addDragAndDropSupport(EObject modelElement, TreeViewer treeViewer, EditingDomain editingDomain) {
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        treeViewer.addDragSupport(7, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)treeViewer));
        EditingDomainViewerDropAdapter editingDomainViewerDropAdapter = new EditingDomainViewerDropAdapter(editingDomain, (Viewer)treeViewer);
        treeViewer.addDropSupport(7, transfers, (DropTargetListener)editingDomainViewerDropAdapter);
    }

    private void fillContextMenu(TreeViewer treeViewer, EditingDomain editingDomain) {
        ChildrenDescriptorCollector childrenDescriptorCollector = new ChildrenDescriptorCollector();
        List<MasterDetailAction> menuActions = this.readMasterDetailActions();
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new MasterTreeContextMenuListener(editingDomain, treeViewer, childrenDescriptorCollector, menuActions));
        Menu menu = menuMgr.createContextMenu(treeViewer.getControl());
        treeViewer.getControl().setMenu(menu);
    }

    protected List<MasterDetailAction> readMasterDetailActions() {
        IConfigurationElement[] controls;
        ArrayList<MasterDetailAction> commands = new ArrayList<MasterDetailAction>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return commands;
        }
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.treemasterdetail.ui.swt.masterDetailActions");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String location = e.getAttribute("location");
                if (location.equals("menu")) {
                    String label = e.getAttribute("label");
                    String imagePath = e.getAttribute("imagePath");
                    MasterDetailAction command = (MasterDetailAction)((Object)e.createExecutableExtension("command"));
                    command.setLabel(label);
                    command.setImagePath(imagePath);
                    command.setTreeViewer(this.treeViewer);
                    commands.add(command);
                }
            }
            catch (CoreException ex) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex));
            }
            ++n2;
        }
        return commands;
    }

    private void fillContextMenu(IMenuManager manager, Collection<?> descriptors, final EditingDomain domain, final EObject eObject) {
        for (Object descriptor : descriptors) {
            final CommandParameter cp = (CommandParameter)descriptor;
            if (!CommandParameter.class.isInstance(descriptor) || cp.getEReference() == null || !cp.getEReference().isMany() && eObject.eIsSet(cp.getEStructuralFeature()) || cp.getEReference().isMany() && cp.getEReference().getUpperBound() != -1 && cp.getEReference().getUpperBound() <= ((List)eObject.eGet((EStructuralFeature)cp.getEReference())).size()) continue;
            manager.add((IAction)new CreateChildAction(domain, (ISelection)new StructuredSelection((Object)eObject), descriptor){

                @Override
                public void run() {
                    super.run();
                    EReference reference = ((CommandParameter)this.descriptor).getEReference();
                    domain.getCommandStack().execute(AddCommand.create((EditingDomain)domain, (Object)eObject, (Object)reference, (Object)cp.getEValue()));
                }
            });
        }
    }

    private void addDeleteActionToContextMenu(EditingDomain editingDomain, IMenuManager manager, final IStructuredSelection selection) {
        Action deleteAction = new Action(){

            public void run() {
                super.run();
                DeleteService deleteService = (DeleteService)TreeMasterDetailSWTRenderer.this.getViewModelContext().getService(DeleteService.class);
                if (deleteService == null) {
                    deleteService = new EMFDeleteServiceImpl();
                }
                deleteService.deleteElements((Collection)selection.toList());
            }
        };
        String deleteImagePath = "icons/delete.png";
        deleteAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/delete.png")));
        deleteAction.setText("Delete");
        deleteAction.setEnabled(ConditionalDeleteService.getDeleteService((EMFFormsViewContext)this.getViewModelContext()).canDelete((Iterable)selection.toList()));
        manager.add((IAction)deleteAction);
    }

    protected void manipulateViewContext(ViewModelContext viewContext) {
    }

    protected Composite getDetailContainer() {
        return this.rightPanelContainerComposite;
    }

    protected Object manipulateSelection(Object treeSelected) {
        return TreeMasterDetailSelectionManipulatorHelper.manipulateSelection(treeSelected);
    }

    protected void cleanCustomOnSelectionChange() {
    }

    protected void relayoutDetail() {
        this.rightPanelContainerComposite.layout();
        Point point = this.container.computeSize(-1, -1);
        this.rightPanel.setMinSize(point);
    }

    public boolean reveal(Object object) {
        TreePath treePath = this.getTreePathFor(object);
        return this.reveal(treePath);
    }

    public TreePath getTreePathFor(Object object) {
        ITreeContentProvider content = (ITreeContentProvider)this.treeViewer.getContentProvider();
        List<Object> roots = Arrays.asList(content.getElements(this.treeViewer.getInput()));
        LinkedList<Object> path = new LinkedList<Object>();
        path.add(object);
        Object parent = content.getParent(object);
        while (parent != null) {
            path.add(0, parent);
            if (roots.contains(parent)) break;
            parent = content.getParent(parent);
        }
        return new TreePath(path.toArray());
    }

    public boolean reveal(TreePath path) {
        TreeSelection newSelection = new TreeSelection(path);
        if (!newSelection.equals(this.treeViewer.getSelection())) {
            this.treeViewer.setSelection((ISelection)new TreeSelection(path), true);
        }
        this.treeViewer.reveal((Object)path);
        return this.treeViewer.getStructuredSelection().getFirstElement() == path.getLastSegment();
    }

    public boolean hasPath(TreePath path) {
        if (path.equals((Object)TreePath.EMPTY)) {
            return true;
        }
        TreePath parentPath = path.getParentPath();
        if (!this.hasPath(parentPath)) {
            return false;
        }
        ITreeContentProvider content = (ITreeContentProvider)this.treeViewer.getContentProvider();
        Collection<Object> children = parentPath.equals((Object)TreePath.EMPTY) ? Arrays.asList(content.getElements(this.treeViewer.getInput())) : (content.hasChildren(parentPath.getLastSegment()) ? Arrays.asList(content.getChildren(parentPath.getLastSegment())) : Collections.EMPTY_SET);
        return children.contains(path.getLastSegment());
    }

    public ViewModelContext getDetailContext() {
        return this.childContext;
    }

    protected void applyEnable() {
        this.treeViewer.setSelection((ISelection)new StructuredSelection(this.treeViewer.getStructuredSelection().getFirstElement()));
    }

    protected void applyValidation(final VDiagnostic oldDia, final VDiagnostic newDia) {
        super.applyValidation();
        if (this.treeViewer == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TreeMasterDetailSWTRenderer.this.treeViewer.getTree().isDisposed()) {
                    return;
                }
                TreeMasterDetailSWTRenderer.this.updateTree(oldDia, newDia);
            }
        });
    }

    private void updateTree(VDiagnostic oldDia, VDiagnostic newDia) {
        ArrayList diff = new ArrayList();
        if (newDia != null) {
            diff.addAll(newDia.getDiagnostics());
        }
        if (oldDia != null) {
            diff.removeAll((Collection<?>)oldDia.getDiagnostics());
        }
        ArrayList diff2 = new ArrayList();
        if (oldDia != null) {
            diff2.addAll(oldDia.getDiagnostics());
        }
        if (newDia != null) {
            diff2.removeAll((Collection<?>)newDia.getDiagnostics());
        }
        diff.addAll(diff2);
        LinkedHashSet<Object> toUpdate = new LinkedHashSet<Object>();
        ITreeContentProvider provider = (ITreeContentProvider)ITreeContentProvider.class.cast(this.treeViewer.getContentProvider());
        for (Object o : diff) {
            EObject toAdd = (EObject)((Diagnostic)Diagnostic.class.cast(o)).getData().get(0);
            toUpdate.add(toAdd);
            Object parent = provider.getParent((Object)toAdd);
            while (EObject.class.isInstance(parent)) {
                toUpdate.add(parent);
                parent = provider.getParent(parent);
            }
        }
        if (!(!toUpdate.isEmpty() || oldDia.getDiagnostics().isEmpty() && newDia.getDiagnostics().isEmpty())) {
            this.treeViewer.refresh();
            return;
        }
        this.treeViewer.update(toUpdate.toArray(), null);
    }

    private final class MasterTreeContextMenuListener
    implements IMenuListener {
        private final EditingDomain editingDomain;
        private final TreeViewer treeViewer;
        private final ChildrenDescriptorCollector childrenDescriptorCollector;
        private final List<MasterDetailAction> menuActions;

        private MasterTreeContextMenuListener(EditingDomain editingDomain, TreeViewer treeViewer, ChildrenDescriptorCollector childrenDescriptorCollector, List<MasterDetailAction> menuActions) {
            this.editingDomain = editingDomain;
            this.treeViewer = treeViewer;
            this.childrenDescriptorCollector = childrenDescriptorCollector;
            this.menuActions = menuActions;
        }

        public void menuAboutToShow(IMenuManager manager) {
            if (((VTreeMasterDetail)TreeMasterDetailSWTRenderer.this.getVElement()).isEffectivelyReadonly() || !((VTreeMasterDetail)TreeMasterDetailSWTRenderer.this.getVElement()).isEffectivelyEnabled()) {
                return;
            }
            if (this.treeViewer.getSelection().isEmpty()) {
                this.fillMenu(null, manager);
                return;
            }
            EObject root = ((RootObject)this.treeViewer.getInput()).getRoot();
            if (this.treeViewer.getSelection() instanceof IStructuredSelection) {
                IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
                if (selection.size() == 1 && EObject.class.isInstance(selection.getFirstElement())) {
                    EObject eObject = (EObject)selection.getFirstElement();
                    EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
                    if (domain == null) {
                        return;
                    }
                    Collection descriptors = this.childrenDescriptorCollector.getDescriptors(eObject);
                    TreeMasterDetailSWTRenderer.this.fillContextMenu(manager, descriptors, this.editingDomain, eObject);
                }
                if (!selection.toList().contains(root)) {
                    manager.add((IContributionItem)new Separator(TreeMasterDetailSWTRenderer.GLOBAL_ADDITIONS));
                    TreeMasterDetailSWTRenderer.this.addDeleteActionToContextMenu(this.editingDomain, manager, selection);
                }
                manager.add((IContributionItem)new Separator());
                if (selection.getFirstElement() != null && EObject.class.isInstance(selection.getFirstElement())) {
                    EObject selectedObject = (EObject)selection.getFirstElement();
                    this.fillMenu(selectedObject, manager);
                }
            }
        }

        private void fillMenu(final EObject selectedObject, IMenuManager manager) {
            for (final MasterDetailAction menuAction : this.menuActions) {
                if (!menuAction.shouldShow(selectedObject)) continue;
                Action newAction = new Action(){

                    public void run() {
                        super.run();
                        menuAction.execute(selectedObject);
                    }
                };
                newAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)FrameworkUtil.getBundle(((Object)((Object)menuAction)).getClass()).getResource(menuAction.getImagePath())));
                newAction.setText(menuAction.getLabel());
                manager.add((IAction)newAction);
            }
        }
    }

    private class TreeMasterDetailLabelProvider
    extends AdapterFactoryLabelProvider {
        TreeMasterDetailLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Image getImage(Object object) {
            Image image = super.getImage(object);
            if (!EObject.class.isInstance(object)) {
                return image;
            }
            return this.getValidationOverlay(image, (EObject)object);
        }

        protected Image getValidationOverlay(Image image, EObject object) {
            ImageDescriptor overlay;
            VDiagnostic vDiagnostic = ((VTreeMasterDetail)TreeMasterDetailSWTRenderer.this.getVElement()).getDiagnostic();
            int highestSeverity = 0;
            if (vDiagnostic != null) {
                for (Diagnostic diagnostic : vDiagnostic.getDiagnostics(object)) {
                    if (diagnostic.getSeverity() <= highestSeverity) continue;
                    highestSeverity = diagnostic.getSeverity();
                }
            }
            if ((overlay = SWTValidationHelper.INSTANCE.getValidationOverlayDescriptor(highestSeverity)) == null) {
                return image;
            }
            OverlayImageDescriptor imageDescriptor = new OverlayImageDescriptor(image, overlay, 2);
            Image resultImage = imageDescriptor.createImage();
            return resultImage;
        }
    }

    private class TreeMasterDetailReferenceService
    implements ReferenceService {
        private final ReferenceService delegate;

        TreeMasterDetailReferenceService(ReferenceService delegate) {
            this.delegate = delegate;
        }

        public void instantiate(ViewModelContext context) {
        }

        public void dispose() {
        }

        public int getPriority() {
            if (this.delegate == null) {
                return 0;
            }
            return this.delegate.getPriority() - 1;
        }

        public void addNewModelElements(EObject eObject, EReference eReference) {
            this.addNewModelElements(eObject, eReference, true);
        }

        public Optional<EObject> addNewModelElements(EObject eObject, EReference eReference, boolean openInNewContext) {
            if (this.delegate == null) {
                return Optional.empty();
            }
            return this.delegate.addNewModelElements(eObject, eReference, openInNewContext);
        }

        public void addExistingModelElements(EObject eObject, EReference eReference) {
            if (this.delegate == null) {
                return;
            }
            this.delegate.addExistingModelElements(eObject, eReference);
        }

        public void openInNewContext(EObject eObject) {
            TreeMasterDetailSWTRenderer.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)eObject), true);
            ISelection selection = TreeMasterDetailSWTRenderer.this.treeViewer.getSelection();
            if (!selection.isEmpty()) {
                return;
            }
            if (this.delegate == null) {
                return;
            }
            this.delegate.openInNewContext(eObject);
        }
    }

    private class TreeMasterViewSelectionListener
    implements ISelectionChangedListener {
        private TreeMasterViewSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object selectedObject;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object treeSelected = this.getSelection(selection);
            TreeMasterDetailSWTRenderer.this.detailManager.cacheCurrentDetail();
            TreeMasterDetailSWTRenderer.this.cleanCustomOnSelectionChange();
            Object object = selectedObject = treeSelected == null ? treeSelected : TreeMasterDetailSWTRenderer.this.manipulateSelection(treeSelected);
            if (selectedObject instanceof EObject) {
                EObject selected = (EObject)selectedObject;
                Object root = TreeMasterDetailSWTRenderer.this.manipulateSelection(((RootObject)((TreeViewer)event.getSource()).getInput()).getRoot());
                boolean rootSelected = selected == root;
                VView view = null;
                if (rootSelected) {
                    view = ((VTreeMasterDetail)TreeMasterDetailSWTRenderer.this.getVElement()).getDetailView();
                }
                if (view == null || view.getChildren().isEmpty()) {
                    view = TreeMasterDetailSWTRenderer.this.detailManager.getDetailView(TreeMasterDetailSWTRenderer.this.getViewModelContext(), selected, properties -> {
                        if (rootSelected) {
                            properties.addNonInheritableProperty(TreeMasterDetailSWTRenderer.ROOT_KEY, (Object)true);
                        }
                    });
                }
                if (TreeMasterDetailSWTRenderer.this.detailManager.isCached(selected)) {
                    TreeMasterDetailSWTRenderer.this.detailManager.activate(selected);
                } else {
                    ReferenceService referenceService = (ReferenceService)TreeMasterDetailSWTRenderer.this.getViewModelContext().getService(ReferenceService.class);
                    if (TreeMasterDetailSWTRenderer.this.getViewModelContext().getContextValue(TreeMasterDetailSWTRenderer.ENABLE_MULTI_EDIT) == Boolean.TRUE && selection.size() > 1 && selected != this.getSelection((IStructuredSelection)new StructuredSelection(selection.getFirstElement()))) {
                        TreeMasterDetailSWTRenderer.this.childContext = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)view, selected, new ViewModelService[]{new TreeMasterDetailReferenceService(referenceService)});
                    } else {
                        TreeMasterDetailSWTRenderer.this.childContext = TreeMasterDetailSWTRenderer.this.getViewModelContext().getChildContext(selected, TreeMasterDetailSWTRenderer.this.getVElement(), view, new ViewModelService[]{new TreeMasterDetailReferenceService(referenceService)});
                    }
                    TreeMasterDetailSWTRenderer.this.manipulateViewContext(TreeMasterDetailSWTRenderer.this.childContext);
                    TreeMasterDetailSWTRenderer.this.detailManager.render(TreeMasterDetailSWTRenderer.this.childContext, (arg_0, arg_1) -> ((ECPSWTViewRenderer)ECPSWTViewRenderer.INSTANCE).render(arg_0, arg_1));
                }
                TreeMasterDetailSWTRenderer.this.detailManager.setDetailReadOnly(!((VTreeMasterDetail)TreeMasterDetailSWTRenderer.this.getVElement()).isEffectivelyEnabled() || ((VTreeMasterDetail)TreeMasterDetailSWTRenderer.this.getVElement()).isEffectivelyReadonly());
            } else {
                TreeMasterDetailSWTRenderer.this.childContext = null;
            }
            TreeMasterDetailSWTRenderer.this.relayoutDetail();
        }

        private Object getSelection(IStructuredSelection selection) {
            Object treeSelected;
            Object object = treeSelected = selection != null ? selection.getFirstElement() : null;
            if (TreeMasterDetailSWTRenderer.this.getViewModelContext().getContextValue(TreeMasterDetailSWTRenderer.ENABLE_MULTI_EDIT) == Boolean.TRUE && treeSelected instanceof EObject && selection.size() > 1) {
                boolean allOfSameType = true;
                EObject dummy = EcoreUtil.create((EClass)((EObject)treeSelected).eClass());
                Iterator iterator = selection.iterator();
                LinkedHashSet<EObject> selectedEObjects = new LinkedHashSet<EObject>();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    if (!(allOfSameType &= eObject.eClass() == dummy.eClass())) break;
                    for (EAttribute attribute : dummy.eClass().getEAllAttributes()) {
                        if (eObject == treeSelected) {
                            dummy.eSet((EStructuralFeature)attribute, eObject.eGet((EStructuralFeature)attribute));
                            continue;
                        }
                        if (dummy.eGet((EStructuralFeature)attribute) == null || dummy.eGet((EStructuralFeature)attribute).equals(eObject.eGet((EStructuralFeature)attribute))) continue;
                        dummy.eUnset((EStructuralFeature)attribute);
                    }
                    selectedEObjects.add(eObject);
                }
                if (allOfSameType) {
                    treeSelected = dummy;
                    dummy.eAdapters().add((Object)new MultiEditAdapter(dummy, selectedEObjects));
                }
            }
            return treeSelected;
        }

        private final class MultiEditAdapter
        extends AdapterImpl {
            private final EObject dummy;
            private final Set<EObject> selectedEObjects;

            private MultiEditAdapter(EObject dummy, Set<EObject> selectedEObjects) {
                this.dummy = dummy;
                this.selectedEObjects = selectedEObjects;
            }

            public void notifyChanged(Notification notification) {
                EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)TreeMasterDetailSWTRenderer.this.getViewModelContext().getDomainModel());
                if (this.dummy.eClass().getEAllAttributes().contains(notification.getFeature())) {
                    CompoundCommand cc = new CompoundCommand();
                    block6: for (EObject selected : this.selectedEObjects) {
                        Command command = null;
                        switch (notification.getEventType()) {
                            case 1: {
                                command = SetCommand.create((EditingDomain)editingDomain, (Object)selected, (Object)notification.getFeature(), (Object)notification.getNewValue());
                                break;
                            }
                            case 2: {
                                command = SetCommand.create((EditingDomain)editingDomain, (Object)selected, (Object)notification.getFeature(), (Object)SetCommand.UNSET_VALUE);
                                break;
                            }
                            case 3: 
                            case 5: {
                                command = AddCommand.create((EditingDomain)editingDomain, (Object)selected, (Object)notification.getFeature(), (Object)notification.getNewValue());
                                break;
                            }
                            case 4: 
                            case 6: {
                                command = DeleteCommand.create((EditingDomain)editingDomain, (Object)notification.getOldValue());
                                break;
                            }
                            default: {
                                continue block6;
                            }
                        }
                        cc.append(command);
                    }
                    editingDomain.getCommandStack().execute((Command)cc);
                }
            }
        }
    }
}

