/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.editor.controls;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.editor.controls.ExpectedValueControlRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackItem;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackLayout;
import org.eclipse.emf.ecp.view.spi.stack.model.VStackPackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class StackItemControlRenderer
extends ExpectedValueControlRenderer {
    @Override
    protected void onSelectButton(Label control) {
        EStructuralFeature.Setting setting = this.getSetting((VControl)this.getVElement());
        VStackItem stackItem = (VStackItem)setting.getEObject();
        VStackLayout eContainer = (VStackLayout)stackItem.eContainer();
        if (eContainer.getDomainModelReference() == null) {
            MessageDialog.openError((Shell)control.getShell(), (String)"No Feature Path Domain Model Reference found", (String)"A Feature Path Domain Model Reference needs to be added to the Stack Layout first. ");
            return;
        }
        EStructuralFeature structuralFeature = ((VFeaturePathDomainModelReference)eContainer.getDomainModelReference()).getDomainModelEFeature();
        if (structuralFeature == null) {
            MessageDialog.openError((Shell)control.getShell(), (String)"No value selected", (String)"Please set a value to the Domain Model Reference first. ");
            return;
        }
        if (EReference.class.isInstance(structuralFeature)) {
            return;
        }
        Object object = this.getSelectedObject((EAttribute)structuralFeature);
        if (object != null) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)stackItem);
            editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)stackItem, (Object)VStackPackage.eINSTANCE.getStackItem_Value(), (Object)object));
            control.setText(object.toString());
        }
    }
}

