/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.validation.bean;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.Configuration;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.validation.ValidationProvider;
import org.eclipse.emf.ecp.view.internal.validation.bean.Activator;
import org.osgi.framework.Bundle;

public abstract class BeanValidationProvider
implements ValidationProvider {
    private ValidatorContext validatorContext;

    public BeanValidationProvider() {
        this(new InputStream[0]);
    }

    public BeanValidationProvider(InputStream ... inputStreams) {
        this.instantiateValidator(inputStreams);
    }

    private void instantiateValidator(InputStream[] inputStreams) {
        Configuration configure = Validation.byDefaultProvider().configure();
        ArrayList<InputStream> allInputStreams = new ArrayList<InputStream>(Arrays.asList(inputStreams));
        allInputStreams.addAll(this.readExtensionPoints());
        for (InputStream is : allInputStreams) {
            configure = configure.addMapping(is);
        }
        ValidatorFactory validatorFactory = configure.buildValidatorFactory();
        MessageInterpolator interpolator = this.getMessageInterpolator(validatorFactory.getMessageInterpolator());
        this.validatorContext = validatorFactory.usingContext().messageInterpolator(interpolator);
        for (InputStream is : allInputStreams) {
            try {
                is.close();
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
    }

    private Collection<InputStream> readExtensionPoints() {
        IConfigurationElement[] controls;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return Collections.emptyList();
        }
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        IConfigurationElement[] iConfigurationElementArray = controls = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.validation.bean.violations");
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String xmlViolationPath = e.getAttribute("xml");
                Bundle bundle = Platform.getBundle((String)e.getContributor().getName());
                inputStreams.add(bundle.getResource(xmlViolationPath).openStream());
            }
            catch (IOException e1) {
                Activator.log(e1);
            }
            ++n2;
        }
        return inputStreams;
    }

    public List<Diagnostic> validate(EObject eObject) {
        Validator validator = this.validatorContext.getValidator();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        Set validationResult = validator.validate((Object)eObject, new Class[0]);
        for (ConstraintViolation violation : validationResult) {
            Path.Node lastNode2 = null;
            for (Path.Node lastNode2 : violation.getPropertyPath()) {
            }
            EObject leafBean = (EObject)violation.getLeafBean();
            EStructuralFeature eStructuralFeature = leafBean.eClass().getEStructuralFeature(lastNode2.getName());
            int severity = this.getSeverity((ConstraintViolation<EObject>)violation);
            BasicDiagnostic diagnostic = new BasicDiagnostic(severity, "Bean Validation", 0, violation.getMessage(), new Object[]{violation.getLeafBean(), eStructuralFeature});
            diagnostics.add((Diagnostic)diagnostic);
        }
        return diagnostics;
    }

    protected abstract MessageInterpolator getMessageInterpolator(MessageInterpolator var1);

    protected abstract int getSeverity(ConstraintViolation<EObject> var1);
}

