/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OperationImplementation {
    protected abstract void execute(Metamodel var1, Model var2) throws MigrationException;

    public final List<String> checkPreconditions(Metamodel metamodel) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.checkRequiredParameters());
        result.addAll(this.checkConstraints(metamodel));
        return result;
    }

    public void checkAndExecute(Metamodel metamodel, Model model) throws MigrationException {
        List<String> messages = this.checkPreconditions(metamodel);
        if (!messages.isEmpty()) {
            throw new MigrationException("The preconditions of the operation are not fulfilled: " + messages, null);
        }
        this.execute(metamodel, model);
    }

    private Collection<? extends String> checkRequiredParameters() {
        ArrayList<String> result = new ArrayList<String>();
        Field[] fieldArray = this.getClass().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            EdaptParameter p = field.getAnnotation(EdaptParameter.class);
            if (p != null && !p.optional()) {
                try {
                    Object value = field.get(this);
                    if (field.getType() == List.class) {
                        if (value == null || ((List)value).isEmpty()) {
                            result.add("Parameter '" + field.getName() + "' must be set");
                        }
                    } else if (value == null) {
                        result.add("Parameter '" + field.getName() + "' must be set");
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return result;
    }

    private List<String> checkConstraints(Metamodel metamodel) {
        ArrayList<String> result = new ArrayList<String>();
        Method[] methodArray = this.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            EdaptConstraint constraint = method.getAnnotation(EdaptConstraint.class);
            if (constraint != null) {
                if (constraint.restricts().length() > 0) {
                    this.checkRestriction(method, constraint, metamodel, result);
                } else {
                    this.invokeMethodAndAddResult(method, constraint, metamodel, result, new Object[0]);
                }
            }
            ++n2;
        }
        return result;
    }

    private void checkRestriction(Method method, EdaptConstraint constraint, Metamodel metamodel, List<String> result) {
        block5: {
            try {
                Field field = this.getClass().getField(constraint.restricts());
                Object value = field.get(this);
                if (field.getType() == List.class) {
                    for (Object v : (List)value) {
                        if (!this.invokeMethodAndAddResult(method, constraint, metamodel, result, v)) {
                            continue;
                        }
                        break block5;
                    }
                    break block5;
                }
                this.invokeMethodAndAddResult(method, constraint, metamodel, result, value);
            }
            catch (Exception exception) {}
        }
    }

    private boolean invokeMethodAndAddResult(Method method, EdaptConstraint constraint, Metamodel metamodel, List<String> result, Object ... parameters) {
        try {
            boolean fulfilled = true;
            if (method.getParameterTypes().length > parameters.length) {
                parameters = Arrays.copyOf(parameters, parameters.length + 1);
                parameters[parameters.length - 1] = metamodel;
                fulfilled = (Boolean)method.invoke((Object)this, parameters);
            } else {
                fulfilled = (Boolean)method.invoke((Object)this, parameters);
            }
            if (!fulfilled) {
                result.add(constraint.description());
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public List<String> checkRestriction(String parameterName, Metamodel metamodel) {
        ArrayList<String> result = new ArrayList<String>();
        for (Method method : this.getRestrictions(parameterName)) {
            try {
                EdaptConstraint constraint = method.getAnnotation(EdaptConstraint.class);
                this.checkRestriction(method, constraint, metamodel, result);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private List<Method> getRestrictions(String parameterName) {
        ArrayList<Method> restrictions = new ArrayList<Method>();
        Method[] methodArray = this.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            EdaptConstraint constraint = method.getAnnotation(EdaptConstraint.class);
            if (constraint != null && parameterName.equals(constraint.restricts())) {
                restrictions.add(method);
            }
            ++n2;
        }
        return restrictions;
    }

    public List<String> checkRestriction(String parameterName, Object value, Metamodel metamodel) {
        ArrayList<String> result = new ArrayList<String>();
        for (Method method : this.getRestrictions(parameterName)) {
            EdaptConstraint constraint = method.getAnnotation(EdaptConstraint.class);
            this.invokeMethodAndAddResult(method, constraint, metamodel, result, value);
        }
        return result;
    }

    public void initialize(Metamodel metamodel) {
    }

    protected void deleteFeatureValue(Instance instance, EStructuralFeature feature) {
        EReference reference;
        Object value = instance.unset(feature);
        if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            Model model = instance.getType().getModel();
            if (reference.isMany()) {
                for (Instance v : (List)value) {
                    model.delete(v);
                }
            } else if (value != null) {
                model.delete((Instance)value);
            }
        }
    }

    protected boolean hasSameValue(List<? extends EObject> elements, EStructuralFeature feature) {
        if (elements.isEmpty()) {
            return true;
        }
        Object referenceValue = elements.get(0).eGet(feature);
        return this.hasValue(elements, feature, referenceValue);
    }

    protected boolean hasValue(List<? extends EObject> elements, EStructuralFeature feature, Object referenceValue) {
        for (EObject eObject : elements) {
            Object value = eObject.eGet(feature);
            if (this.isSame(referenceValue, value)) continue;
            return false;
        }
        return true;
    }

    private boolean isSame(Object referenceValue, Object value) {
        if (referenceValue != value) {
            if (referenceValue == null || value == null) {
                return false;
            }
            if (!referenceValue.equals(value)) {
                return false;
            }
        }
        return true;
    }

    protected boolean isOfType(List<? extends EObject> elements, EClass eClass) {
        for (EObject eObject : elements) {
            if (eObject.eClass() == eClass) continue;
            return false;
        }
        return true;
    }

    protected boolean isOfSameType(List<? extends EObject> elements) {
        if (elements.isEmpty()) {
            return true;
        }
        return this.isOfType(elements, elements.get(0).eClass());
    }

    protected boolean hasSameValue(List<? extends EObject> first, List<? extends EObject> second, EStructuralFeature feature) {
        if (first.size() != second.size()) {
            return false;
        }
        int i = 0;
        while (i < first.size()) {
            if (!this.isSame(first.get(i).eGet(feature), second.get(i).eGet(feature))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

