/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.framework;

import ee.jakarta.tck.concurrent.common.managedTaskListener.ListenerEvent;
import ee.jakarta.tck.concurrent.common.managedTaskListener.ManagedTaskListenerImpl;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.testng.Assert;

public final class TestUtil {
    public static final TestLogger log = TestLogger.get(TestUtil.class);
    public static final String nl = System.lineSeparator();

    public static String getResponse(URLConnection con) throws IOException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            String line;
            StringBuffer response = new StringBuffer();
            while ((line = br.readLine()) != null) {
                response.append(line).append(nl);
            }
            String string = response.toString();
            return string;
        }
    }

    public static URLConnection sendPostData(URL url, Properties props) throws IOException {
        log.info("Opening url connection to: " + url.toString());
        URLConnection urlConn = url.openConnection();
        String argString = TestUtil.toEncodedString(props);
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setUseCaches(false);
        DataOutputStream out = new DataOutputStream(urlConn.getOutputStream());
        out.writeBytes(argString);
        out.flush();
        out.close();
        return urlConn;
    }

    static String toEncodedString(Properties args) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        Enumeration<?> names = args.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = args.getProperty(name);
            buf.append(URLEncoder.encode(name, StandardCharsets.UTF_8.name())).append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8.name()));
            if (!names.hasMoreElements()) continue;
            buf.append("&");
        }
        return buf.toString();
    }

    public static <T> T lookup(String jndiName) {
        InitialContext ctx = null;
        Object targetObject = null;
        try {
            ctx = new InitialContext();
            targetObject = ctx.lookup(jndiName);
        }
        catch (NamingException e) {
            throw new RuntimeException("failed to lookup resource.", e);
        }
        finally {
            try {
                ctx.close();
            }
            catch (Exception exception) {}
        }
        return (T)targetObject;
    }

    public static ContextService getContextService() {
        return (ContextService)TestUtil.lookup("java:comp/DefaultContextService");
    }

    public static ManagedExecutorService getManagedExecutorService() {
        return (ManagedExecutorService)TestUtil.lookup("java:comp/DefaultManagedExecutorService");
    }

    public static ManagedScheduledExecutorService getManagedScheduledExecutorService() {
        return (ManagedScheduledExecutorService)TestUtil.lookup("java:comp/DefaultManagedScheduledExecutorService");
    }

    public static ManagedThreadFactory getManagedThreadFactory() {
        return (ManagedThreadFactory)TestUtil.lookup("java:comp/DefaultManagedThreadFactory");
    }

    public static void sleep(Duration duration) throws InterruptedException {
        log.config("Sleeping " + duration.toMillis() + " milliseconds");
        Thread.sleep(duration.toMillis());
    }

    public static <T> T waitForTaskComplete(Future<T> future) {
        return TestUtil.waitForTaskComplete(future, TestConstants.WaitTimeout.toMillis());
    }

    public static <T> T waitForTaskComplete(Future<T> future, long maxWaitTimeMillis) {
        T result = null;
        try {
            result = future.get(maxWaitTimeMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("waitForTaskComplete", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("waitForTaskComplete", e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("failed to finish task in " + maxWaitTimeMillis + " milliseconds. ", e);
        }
        catch (Exception e) {
            throw new RuntimeException("waitForTaskComplete failed to finish task", e);
        }
        return result;
    }

    public static void waitForListenerComplete(ManagedTaskListenerImpl managedTaskListener) {
        TestUtil.waitForListenerComplete(managedTaskListener, TestConstants.WaitTimeout.toMillis(), TestConstants.PollInterval.toMillis());
    }

    public static void waitForListenerComplete(ManagedTaskListenerImpl managedTaskListener, long maxWaitTimeMillis, long pollIntervalMillis) {
        long stopTime = System.currentTimeMillis() + maxWaitTimeMillis;
        while (!managedTaskListener.eventCalled(ListenerEvent.DONE) && System.currentTimeMillis() < stopTime) {
            try {
                Thread.sleep(pollIntervalMillis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread was inerrupted while sleeping", e);
            }
        }
    }

    public static void waitTillFutureIsDone(Future<?> future) {
        long start = System.currentTimeMillis();
        while (!future.isDone()) {
            try {
                Thread.sleep(TestConstants.PollInterval.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start <= TestConstants.WaitTimeout.toMillis()) continue;
            throw new RuntimeException("Future did not finish before wait timeout elapsed.");
        }
    }

    public static void waitTillFutureThrowsException(Future future, Class<?> expected) {
        long start = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(TestConstants.PollInterval.toMillis());
                future.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable e) {
                if (!e.getClass().equals(expected)) continue;
                return;
            }
        } while (System.currentTimeMillis() - start <= TestConstants.WaitTimeout.toMillis());
        throw new RuntimeException("Future did not throw exception before wait timeout elapased.");
    }

    public static void waitTillThreadFinish(Thread thread) {
        long start = System.currentTimeMillis();
        while (thread.isAlive()) {
            try {
                Thread.sleep(TestConstants.PollInterval.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start <= TestConstants.WaitTimeout.toMillis()) continue;
            throw new RuntimeException("Thread did not finish before wait timeout elapsed.");
        }
    }

    public static void assertInRange(Object[] range, Object actual) {
        Object expected = "";
        for (Object each : range) {
            expected = (String)expected + each.toString();
            expected = (String)expected + ",";
        }
        expected = ((String)expected).substring(0, ((String)expected).length() - 1);
        String msg = "expected in " + (String)expected + " but you got " + actual;
        for (Object each : range) {
            if (!each.equals(actual)) continue;
            return;
        }
        Assert.fail((String)msg);
    }

    public static void assertIntInRange(int low, int high, int actual) {
        String msg = "expected in range " + low + " , " + high;
        msg = msg + " but you got " + actual;
        if (actual < low || actual > high) {
            Assert.fail((String)msg);
        }
    }
}

