/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.ManagedExecutors;

import ee.jakarta.tck.concurrent.common.CallableTask;
import ee.jakarta.tck.concurrent.common.RunnableTask;
import ee.jakarta.tck.concurrent.common.managedTaskListener.ListenerEvent;
import ee.jakarta.tck.concurrent.common.managedTaskListener.ManagedTaskListenerImpl;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import jakarta.enterprise.concurrent.ManagedExecutors;
import jakarta.enterprise.concurrent.ManagedTask;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import jakarta.servlet.annotation.WebServlet;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

@WebServlet(value={"/ManagedExecutorsServlet"})
public class ManagedExecutorsServlet
extends TestServlet {
    private static final TestLogger log = TestLogger.get(ManagedExecutorsServlet.class);
    private static final String ENV_ENTRY_JNDI_NAME = "java:comp/env/StringValue";
    private static final String ENV_ENTRY_VALUE = "something";
    private ManagedTaskListenerImpl managedTaskListener = new ManagedTaskListenerImpl();
    private boolean shutdown = true;

    @Override
    public void after() {
        this.managedTaskListener.clearEvents();
    }

    private RunnableTask createRunnableTask() {
        return new RunnableTask(ENV_ENTRY_JNDI_NAME, ENV_ENTRY_VALUE, ((Object)((Object)this)).getClass().getName());
    }

    private CallableTask<String> createCallableTask(String expectedReturnValue) {
        return new CallableTask<String>(ENV_ENTRY_JNDI_NAME, ENV_ENTRY_VALUE, ((Object)((Object)this)).getClass().getName(), expectedReturnValue);
    }

    public void IsCurrentThreadShutdown() {
        Thread createdThread = TestUtil.getManagedThreadFactory().newThread(new Runnable(){

            @Override
            public void run() {
                ManagedExecutorsServlet.this.shutdown = ManagedExecutors.isCurrentThreadShutdown();
            }
        });
        Future<?> future = Executors.newSingleThreadExecutor().submit(createdThread);
        TestUtil.waitForTaskComplete(future);
        if (this.shutdown) {
            throw new RuntimeException("Failed because shutdown is set to be true when running job");
        }
    }

    public void IsCurrentThreadShutdown_ManageableThread() {
        Thread createdThread = TestUtil.getManagedThreadFactory().newThread(new Runnable(){

            @Override
            public void run() {
                ManagedExecutorsServlet.this.shutdown = ManagedExecutors.isCurrentThreadShutdown();
            }
        });
        Future<?> future = Executors.newSingleThreadExecutor((ThreadFactory)TestUtil.getManagedThreadFactory()).submit(createdThread);
        TestUtil.waitForTaskComplete(future);
        if (this.shutdown) {
            throw new RuntimeException("Failed because shutdown is set to be true when running job");
        }
    }

    public void ManageRunnableTaskWithTaskListener() {
        RunnableTask runnableTask = this.createRunnableTask();
        Runnable taskWithListener = ManagedExecutors.managedTask((Runnable)runnableTask, (ManagedTaskListener)this.managedTaskListener);
        Future futureResult = TestUtil.getManagedExecutorService().submit(taskWithListener);
        this.assertTaskAndListenerComplete(futureResult, runnableTask);
    }

    public void ManageRunnableTaskWithNullArg() {
        Runnable nullTask = null;
        try {
            ManagedExecutors.managedTask(nullTask, (ManagedTaskListener)this.managedTaskListener);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (Exception e) {
            log.warning("Unexpected Exception Caught", e);
        }
        throw new RuntimeException("Failed to get expected exception");
    }

    public void ManageRunnableTaskWithTaskListenerAndMap() {
        ManagedTask managedTask;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", "value");
        RunnableTask runnableTask = this.createRunnableTask();
        Runnable task = ManagedExecutors.managedTask((Runnable)runnableTask, properties, (ManagedTaskListener)this.managedTaskListener);
        boolean pass = false;
        if (task instanceof ManagedTask && (managedTask = (ManagedTask)task).getExecutionProperties().get("key") != "value") {
            throw new RuntimeException("Failed to get expected property");
        }
        this.assertTaskAndListenerComplete(TestUtil.getManagedExecutorService().submit(task), runnableTask);
    }

    public void ManageRunnableTaskWithMapAndNullArg() {
        Runnable nullTask = null;
        HashMap properties = new HashMap();
        try {
            ManagedExecutors.managedTask(nullTask, properties, (ManagedTaskListener)this.managedTaskListener);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (Exception e) {
            log.warning("Unexpected Exception Caught", e);
        }
        throw new RuntimeException("Failed to get expected exception");
    }

    public void ManageCallableTaskWithTaskListener() {
        String expectedResultStr = "expected something";
        CallableTask<String> callableTask = this.createCallableTask(expectedResultStr);
        Callable taskWithListener = ManagedExecutors.managedTask(callableTask, (ManagedTaskListener)this.managedTaskListener);
        Future futureResult = TestUtil.getManagedExecutorService().submit(taskWithListener);
        this.assertTaskAndListenerComplete(expectedResultStr, futureResult, callableTask);
    }

    public void ManageCallableTaskWithNullArg() {
        Callable nullTask = null;
        try {
            ManagedExecutors.managedTask(nullTask, (ManagedTaskListener)this.managedTaskListener);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (Exception e) {
            log.warning("Unexpected Exception Caught", e);
        }
        throw new RuntimeException("Failed to get expected exception");
    }

    public void ManageCallableTaskWithTaskListenerAndMap() {
        ManagedTask managedTask;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", "value");
        properties.put("jakarta.enterprise.concurrent.IDENTITY_NAME", "id");
        String expectedResultStr = "expected something";
        CallableTask<String> callableTask = this.createCallableTask(expectedResultStr);
        Callable task = ManagedExecutors.managedTask(callableTask, properties, (ManagedTaskListener)this.managedTaskListener);
        boolean pass = false;
        if (task instanceof ManagedTask && (managedTask = (ManagedTask)task).getExecutionProperties().get("key") != "value") {
            throw new RuntimeException("Failed to get expected property");
        }
        this.assertTaskAndListenerComplete(expectedResultStr, TestUtil.getManagedExecutorService().submit(task), callableTask);
    }

    public void ManageCallableTaskWithMapAndNullArg() {
        Callable nullTask = null;
        HashMap properties = new HashMap();
        try {
            ManagedExecutors.managedTask(nullTask, properties, (ManagedTaskListener)this.managedTaskListener);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (Exception e) {
            log.warning("Unexpected Exception Caught", e);
        }
        throw new RuntimeException("Failed to get expected exception");
    }

    private void assertTaskAndListenerComplete(Future<?> future, RunnableTask runnableTask) {
        TestUtil.waitForTaskComplete(future);
        this.assertListenerComplete(runnableTask);
    }

    private void assertTaskAndListenerComplete(String expectedResult, Future<String> future, CallableTask<?> callableTask) {
        String result = TestUtil.waitForTaskComplete(future);
        if (!expectedResult.endsWith(result)) {
            throw new RuntimeException("Task return different value with expected one.");
        }
        this.assertListenerComplete(callableTask);
    }

    private void assertListenerComplete(RunnableTask task) {
        TestUtil.waitForListenerComplete(this.managedTaskListener);
        if (!(this.managedTaskListener.eventCalled(ListenerEvent.SUBMITTED) && this.managedTaskListener.eventCalled(ListenerEvent.STARTING) && this.managedTaskListener.eventCalled(ListenerEvent.DONE))) {
            throw new RuntimeException("TaskListener is not completely executed.");
        }
    }
}

