/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedThreadFactory.apitests;

import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ManageableThread;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.testng.Assert;

@WebServlet(value={"/APIServlet"})
public class APIServlet
extends TestServlet {
    @Resource(lookup="java:comp/DefaultManagedThreadFactory")
    private ManagedThreadFactory factory;

    public void interruptThreadApiTest(HttpServletRequest req, HttpServletResponse res) throws Exception {
        CounterRunnable task = new CounterRunnable();
        Thread thread = this.factory.newThread((Runnable)task);
        thread.start();
        thread.interrupt();
        TestUtil.waitTillThreadFinish(thread);
        Assert.assertEquals((int)task.getCount(), (int)0);
    }

    public void implementsManageableThreadInterfaceTest(HttpServletRequest req, HttpServletResponse res) throws Exception {
        CounterRunnable task = new CounterRunnable();
        Thread thread = this.factory.newThread((Runnable)task);
        Assert.assertTrue((boolean)(thread instanceof ManageableThread), (String)"The thread returned by ManagedThreadFactory should be instance of ManageableThread.");
    }

    public static class CounterRunnable
    implements Runnable {
        private volatile int count = 0;

        public int getCount() {
            return this.count;
        }

        @Override
        public void run() {
            try {
                TestUtil.sleep(TestConstants.PollInterval);
                ++this.count;
            }
            catch (InterruptedException ignore) {
                return;
            }
        }
    }
}

