/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.TransformerException;
import jakarta.validation.ValidatorFactory;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.appclient.client.acc.ACCClassLoader;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.persistence.jpa.ProviderContainerContractInfoBase;

public class ProviderContainerContractInfoImpl
extends ProviderContainerContractInfoBase {
    private final ACCClassLoader classLoader;
    private final Instrumentation inst;
    private final String applicationLocation;
    private final Collection<EntityManagerFactory> emfs = new HashSet<EntityManagerFactory>();

    public ProviderContainerContractInfoImpl(ACCClassLoader classLoader, Instrumentation inst, String applicationLocation, ConnectorRuntime connectorRuntime) {
        super(connectorRuntime);
        this.classLoader = classLoader;
        this.inst = inst;
        this.applicationLocation = applicationLocation;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getTempClassloader() {
        PrivilegedAction<URLClassLoader> action = () -> new GlassfishUrlClassLoader(this.classLoader.getURLs());
        return AccessController.doPrivileged(action);
    }

    public void addTransformer(ClassTransformer transformer) {
        TransformerWrapper tw = new TransformerWrapper(transformer, (ClassLoader)((Object)this.classLoader));
        if (this.inst != null) {
            this.inst.addTransformer(tw);
        } else {
            this.classLoader.addTransformer(tw);
        }
    }

    public String getApplicationLocation() {
        return this.applicationLocation;
    }

    public ValidatorFactory getValidatorFactory() {
        return null;
    }

    public DeploymentContext getDeploymentContext() {
        return null;
    }

    public boolean isJava2DBRequired() {
        return false;
    }

    public void registerEMF(String unitName, String persistenceRootUri, RootDeploymentDescriptor containingBundle, EntityManagerFactory emf) {
        this.emfs.add(emf);
    }

    public SimpleJndiName getJTADataSourceOverride() {
        return null;
    }

    public Collection<EntityManagerFactory> emfs() {
        return this.emfs;
    }

    public static class TransformerWrapper
    implements ClassFileTransformer {
        private final ClassTransformer persistenceTransformer;
        private final ClassLoader classLoader;

        TransformerWrapper(ClassTransformer persistenceTransformer, ClassLoader classLoader) {
            this.persistenceTransformer = persistenceTransformer;
            this.classLoader = classLoader;
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            try {
                return loader.equals(this.classLoader) ? this.persistenceTransformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer) : null;
            }
            catch (TransformerException e) {
                throw (IllegalClassFormatException)new IllegalClassFormatException().initCause(e);
            }
        }
    }
}

